/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2007 by KURUSUGAWA Electronics Industry Inc, JAPAN
 *  Copyright (C) 2008 by Takahisa Yokota
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.h,v 1.14 2003/07/08 14:57:12 hiro Exp $
 */

/*
 *	ץå¸⥸塼CFV2ѡ
 *
 *  Υ󥯥롼ɥեϡt_config.h Τߤ饤󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤƤϤʤʤ
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  ͥ̾Υ͡
 */
#include <cpu_rename.h>

/*
 *  ͥǡʸѥޥ
 */
#include <util.h>

/*
 *  桼
 */
#include <user_config.h>

/*
 *  ǽʺǹͥ
 */
#ifdef GDB_STUB
#define MAX_IPM  0x6	/* ֤ξͥ6CPUå   */
#else
#define MAX_IPM  0x7	/* ֤ʤξϺǹͥ٤CPUå */
#endif /*  GDB_STUB  */

#define str_MAX_IPM  		TO_STRING(MAX_IPM)

/*
 *  ץåü̿Υ饤ؿ
 */
#ifndef _MACRO_ONLY
#include <cpu_insn.h>
#endif /* _MACRO_ONLY */

/*
 *  chg_ipm/get_ipm 򥵥ݡȤ뤫ɤ
 */
#define	SUPPORT_CHG_IPM

/*
 *  TCB ΥեɤΥӥå
 *
 *  cpu_context.h 쥬ȤȤΰ¸δطǡ
 *  cpu_context.h ˤʤ
 */
#define	TBIT_TCB_TSTAT		8	/* tstat եɤΥӥå */
#define	TBIT_TCB_PRIORITY	8	/* priority եɤΥӥå */

#ifndef _MACRO_ONLY
/*
 *  ƥȥ֥å
 */
typedef struct task_context_block {
	VP	msp;		/* åݥ */
	FP	pc;		/* ץ५ */
} CTXB;

/*
 *  ߥޥ饤֥
 *
 *  ߥޥintmaskˤϡIPMInterrupt Priority Maskˤ8ӥå
 *  ˥եȤΤǤ롥
 */

/*
 *  ߤγߥޥɽФ
 */
Inline UH
current_intmask()
{
	return(current_sr() & 0x0700);
}

/*
 *  ߥޥ
 */
Inline void
set_intmask(UH intmask)
{
	set_sr((current_sr() & ~0x0700) | intmask);
}

/*
 *  ߡCPU㳰ͥȥ
 */
extern UW	intnest;

/*
 *  ƥֻ
 */

Inline BOOL
sense_context()
{
	return(intnest > 0);
}

Inline BOOL
sense_lock()
{
	return(current_intmask() == (MAX_IPM << 8));
}

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

/*
 *  CPUåȤβʥƥѡ
 *
 *  task_intmask ϡchg_ipm 򥵥ݡȤ뤿ѿchg_ipm 򥵥ݡ
 *  Ȥʤˤϡtask_intmask  0 ˤʤäƤȹͤФ褤
 */

#ifdef SUPPORT_CHG_IPM
extern UH	task_intmask;	/* ƥȤǤγߥޥ */
#endif /* SUPPORT_CHG_IPM */

Inline void
t_lock_cpu()
{
	disint();
}

Inline void
t_unlock_cpu()
{
#ifdef SUPPORT_CHG_IPM
	/*
	 *  t_unlock_cpu ƤӽФΤ CPUå֤ΤߤǤ뤿
	 *  ᡤ task_intmask 񤭴뤳ȤϤʤ
	 */
	set_intmask(task_intmask);
#else /* SUPPORT_CHG_IPM */
	enaint();
#endif /* SUPPORT_CHG_IPM */
}

/*
 *  CPUåȤβ󥿥ƥѡ
 */

extern UH	int_intmask;	/* 󥿥ƥȤǤγߥޥ */

Inline void
i_lock_cpu()
{
	UH	intmask;

	/*
	 *  ѿ intmask ȤäƤΤϡcurrent_intmask() 
	 *  ľ˳ߤȯư줿ߥϥɥ
	 *  int_intmask ѹǽ뤿Ǥ롥
	 */
	intmask = current_intmask();
	disint();
	int_intmask = intmask;
}

Inline void
i_unlock_cpu()
{
	set_intmask(int_intmask);
}

/*
 *  ǥѥå
 */

/*
 *  ǹ̥ͥؤΥǥѥåcpu_support.S
 *
 *  dispatch ϡƥȤƤӽФ줿ӥ
 *  ǡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	dispatch(void);

/*
 *  ߤΥƥȤΤƤƥǥѥåcpu_support.S
 *
 *  exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	exit_and_dispatch(void);

#endif  /* _MACRO_ONLY */

/*
 *  ߥϥɥ顿CPU㳰ϥɥ
 */

/*
 *  㳰٥ơ֥
 *  ޥ
 *  KERNEL_HAS_A_VECTOR_TABLE
 *  ͥ뤬㳰٥ơ֥
 *  SIO_RESERVED
 *  ꥢǥХǥХåˤäƻѤƤ
 */
#ifndef _MACRO_ONLY

#ifdef KERNEL_HAS_A_VECTOR_TABLE
extern FP vector_table[];	/*  㳰٥ơ֥  */
#endif /* KERNEL_HAS_A_VECTOR_TABLE */

typedef struct exc_vector_entry {
	FP	exchdr;			/* 㳰ϥɥεư */
} EXCVE;

/*
 *  ߥϥɥ
 *
 *  ٥ȥֹ inhno γߥϥɥεưϤ inthdr ꤹ롥
 */
Inline void
define_inh(INHNO inhno, FP inthdr)
{
#ifdef GDB_STUB
        Asm("moveq.l #0x8,%%d0;  move.l %0,%%d2; move.l %1,%%d3; trap #0xf"
	    : /* no output */
	    : "r"(inhno), "r"(inthdr)
	    : "%%d0", "%%d2", "%%d3");
#else	/*  GDB_STUB  */

#ifdef KERNEL_HAS_A_VECTOR_TABLE

/* SIO_RESERVEDϻѤʤsys_config.hǥȤˤƤ */
/*#ifdef SIO_RESERVED	*//*  ꥢߤ򤱤  */
/*	if ((inhno != RXI0) && (inhno != TXI0))*/
/*#endif *//* SIO_RESERVED */ 
	vector_table[inhno] = inthdr;

#endif /* KERNEL_HAS_A_VECTOR_TABLE */

#endif	/*  GDB_STUB  */
}

/*
 *  CPU㳰ϥɥ
 *
 *  ٥ȥֹ excno CPU㳰ϥɥεưϤ exchdr ꤹ롥
 */
Inline void
define_exc(EXCNO excno, FP exchdr)
{
	define_inh(excno, exchdr);
}

/*  C롼δؿ̾Υ٥  
 *     kernel_cfg.cǻ
 */
#define	INT_ENTRY(inthdr)	_kernel_##inthdr##_entry
#define	EXC_ENTRY(exchdr)	_kernel_##exchdr##_entry


/*
 *  ߥϥɥ顿CPU㳰ϥɥζʬ
 *
 *	ColdFireǤϡߤCPU㳰ΰۤȤƱʤΤǡ
 *	Υޥⶦ̤Ƥ
 *
 *
 *	labelΥ٥
 *	inthdrC롼Ƭɥ쥹
 *	common_routinecpu_support.Sʬ襢ɥ쥹
 *			interrupt_entryߤξ
 *			cpu_exception_entryCPU㳰ξ
 *
 *쥸
 *d1߼ľSRΥԡ
 *a0C롼Ƭɥ쥹
 *
 *	ߤCPU㳰
 *	CPU㳰ϥɥ˰Ϳ
 *	CPU㳰Ǥϡ㳰ȯIPMƱͤǳߤĤ
 *		CPU㳰ˤꡢIPMѲʤ
 *
 *	ߥϥɥξ				
 *	  	߼ջ˥ϡɥIPMꤹ	
 *	  	ߵĤˤϤIPMͤѤ		
 *	CPU㳰ϥɥξ				
 *	  	CPU㳰ջIPMͤѲʤ		
 *	  	ߵĤˤCPU㳰ȯIPMͤѤ	
 */
#define	HANDLER_ENTRY_PROC(label, handler, common_routine)		   \
asm(".text								\n"\
"	.align 2							\n"\
"	.global "#label"						\n"\
#label":								\n"\
"	lea.l   -16(%sp), %sp		\n"                                \
"	movem.l %d0-%d1/%a0-%a1, (%sp)	\n" /* å쥸¸ */ \
				/*  ߶ػߤSRν  		*/ \
"	move.w	%sr,%d1							\n"\
	/*  ߶ػ  						*/ \
	/*     ߤػߤ̤γߤä 	*/ \
	/*     cpu_suppourt.Sret_int򻲾 				*/ \
"	move.l	#("str_MAX_IPM" << 8),%d0	                        \n"\
"	ori.l	#0x00002000,%d0	                                        \n"\
"	move.w	%d0,%sr	                                                \n"\
"	move.l	#"#handler", %a0				                \n"\
"	jbra	_kernel_"#common_routine"        \n" /* C롼Ƭɥ쥹*/\
)

/*
 *  ߥϥɥޥ
 *
 */
#define INTHDR_ENTRY(inthdr)	INTHDR_ENTRY2(INT_ENTRY(inthdr), inthdr)

#define INTHDR_ENTRY2(entry, inthdr)					\
	extern void entry(void);					\
	HANDLER_ENTRY_PROC(entry, inthdr, interrupt_entry)


/*
 *  CPU㳰ϥɥޥ
 */
#define	EXCHDR_ENTRY(exchdr)	EXCHDR_ENTRY2(EXC_ENTRY(exchdr), exchdr)

#define EXCHDR_ENTRY2(entry, exchdr)					\
	extern void entry(void);					\
	HANDLER_ENTRY_PROC(entry, exchdr, cpu_exception_entry)
	/*
	 *  void entry()ñʤ륨ȥΥ٥ʤΤǡ
	 *  դʤ
	 */

/*
 *  CPU㳰ȯΥƥ֤λ
 */

/*
 *  CPU㳰ȯΥƥȤλ
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
	/* 
	 *  ӤΤϡ߼¹CPU㳰ʬ
	 *  ߥͥȥ󥿤󥯥ȤƤ뤿 	
	 *  
	 *  CPU㳰̤CPU㳰ȯʤȲ
	 *  Ƥ
	 */
	return(intnest > 0);
}

/*
 *  CPU㳰ȯCPUå֤λ
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	return((*((UH *) p_excinf) & 0x0700) == 0x0700);
}

/*
 *  ץå¸ν
 */
extern void	cpu_initialize(void);

/*
 *  ץå¸νλ
 */
extern void	cpu_terminate(void);
/*
 *  ΥϻΥå¤
 */
typedef struct exc_stack {
	VW	d0;
	VW	d1;
	VW	d2;
	VW	d3;
	VW	d4;
	VW	d5;
	VW	d6;
	VW	d7;
	VW	a0;
	VW	a1;
	VW	a2;
	VW	a3;
	VW	a4;
	VW	a5;
	VW	a6;
	VW	a7;
	VW	sr;	/*  ơ쥸  	*/
	VW	pc;	/*  ץࡦ  	*/
} EXCSTACK;


/*
 * 㳰ȯΥ (cpu_config.c, cpu_support.S)
 */
extern void     cpu_experr(EXCSTACK *);

#endif /* _MACRO_ONLY */


/*
 *  㳰٥ꤹǥեȤ
 *  	ʲ㳰װǥǥեȤȤϰۤʤ㳰٥
 *	ϡsys_config.hǳޥ롣
 */
#define RESET_VECTOR 	start		/*  ꥻåȥ٥  */
#define INIT_STACK  	STACKTOP	/*  åݥ󥿤ν  */

#define RESERVED_VECTOR	RESET_VECTOR	/*  ƥͽΥꥻåȥ٥  */
					/*  ºݤˤϻѤʤ  */

#ifndef ACC_VECTOR	/*  顼  */
#define ACC_VECTOR	RESET_VECTOR
#endif /* ACC_VECTOR */

#ifndef ADD_VECTOR	/*  顼  */
#define ADD_VECTOR	RESET_VECTOR
#endif /* ACC_VECTOR */

#ifndef II_VECTOR	/*  ̿  */
#define II_VECTOR	RESET_VECTOR
#endif /* II_VECTOR */

#ifndef PV_VECTOR	/*  å̿  */
#define PV_VECTOR	RESET_VECTOR
#endif /* SII_VECTOR */

#ifndef CAE_VECTOR	/*  CPUɥ쥹顼  */
#define CAE_VECTOR	RESET_VECTOR
#endif /* CAE_VECTOR */

#ifndef DAE_VECTOR	/*  DMAɥ쥹顼  */
#define DAE_VECTOR	RESET_VECTOR
#endif /* DAE_VECTOR */

#ifndef NMI_VECTOR	/*  NMI  */
#define NMI_VECTOR	RESET_VECTOR
#endif /* NMI_VECTOR */

#endif /* _CPU_CONFIG_H_ */
