/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _H8S_H_
#define _H8S_H_

#include <util.h>

/*
 *  H8S/2600, H8S/2000 CPU 
 *    ӡХȥ顢ߥȥϢ
 */

/*
 *  ǥ󥳡ɥ쥸(CCR)
 */
#define CCR_I		BIT7
#define CCR_UI		BIT6
#define CCR_H		BIT5
#define CCR_U		BIT4
#define CCR_N		BIT3
#define CCR_Z		BIT2
#define CCR_V		BIT1
#define CCR_C		BIT0

/*
 *  ƥɥ쥸(EXR)
 */
#define EXR_T		BIT7		/* ȥ졼ӥå */
#define EXR_I2		BIT2		/* ߥޥӥå */
#define EXR_I1		BIT1		/* ߥޥӥå */
#define EXR_I0		BIT0		/* ߥޥӥå */

/* ߥޥӥåȼѥޥ */
#define EXR_I_MASK	(EXR_I2|EXR_I1|EXR_I0)

/*
 *  MCUư⡼ɴϢΥ쥸
 */

/* 쥸Υɥ쥹 */
#define MDCR		0xff3b
#define SYSCR		0xff39

/* ƥ쥸Υӥåȥѥ */

/* MDCR */
#define MDS2		BIT2
#define MDS1		BIT1
#define MDS0		BIT0

/* SYSCR */
#define INTM1		BIT5
#define INTM0		BIT4
#define NMIEG		BIT3
#define RAME		BIT0

#define RAME_BIT	0x0

/*
 *  ߥȥ
 */
/* 쥸Υɥ쥹 */
/* ƥॳȥ쥸ϡѤ */
#define ISCRH		0xff2c		/* IRQ󥹥ȥ쥸H */
#define ISCRL		0xff2d		/* IRQ󥹥ȥ쥸L */
#define IER		0xff2e		/* IRQ֥͡쥸 */
#define ISR		0xff2f		/* IRQơ쥸 */
#define IPRA		0xfec4		/* 󥿥ץȥץ饤ƥ쥸A */
#define IPRB 		0xfec5		/* 󥿥ץȥץ饤ƥ쥸B */
#define IPRC		0xfec6		/* 󥿥ץȥץ饤ƥ쥸C */
#define IPRD		0xfec7		/* 󥿥ץȥץ饤ƥ쥸D */
#define IPRE		0xfec8		/* 󥿥ץȥץ饤ƥ쥸E */
#define IPRF		0xfec9		/* 󥿥ץȥץ饤ƥ쥸F */
#define IPRG		0xfeca		/* 󥿥ץȥץ饤ƥ쥸G */
#define IPRH		0xfecb		/* 󥿥ץȥץ饤ƥ쥸H */
#define IPRI		0xfecc		/* 󥿥ץȥץ饤ƥ쥸I */
#define IPRJ		0xfecd		/* 󥿥ץȥץ饤ƥ쥸J */
#define IPRK		0xfece		/* 󥿥ץȥץ饤ƥ쥸K */

/* ƥ쥸Υӥåȥѥ */

/* IPRx (x = A-K) */
#define IPR6		BIT6
#define IPR5		BIT5
#define IPR4		BIT4
#define IPR2		BIT2
#define IPR1		BIT1
#define IPR0		BIT0

/* icu_set_ilv */
#define IPR_UPR		TRUE
#define IPR_LOW		FALSE
#define IPR_UPR_MASK	(IPR6|IPR5|IPR4)	/* IPR̥ӥåȥޥ */
#define IPR_LOW_MASK	(IPR2|IPR1|IPR0)	/* IPR̥ӥåȥޥ */

/* IER */
#define IRQ7E		BIT7
#define IRQ6E		BIT6
#define IRQ5E		BIT5
#define IRQ4E		BIT4
#define IRQ3E		BIT3
#define IRQ2E		BIT2
#define IRQ1E		BIT1
#define IRQ0E		BIT0

/* ISCRH */
#define IRQ7SCB		BIT7
#define IRQ7SCA		BIT6
#define IRQ6SCB		BIT5
#define IRQ6SCA		BIT4
#define IRQ5SCB		BIT3
#define IRQ5SCA		BIT2
#define IRQ4SCB		BIT1
#define IRQ4SCA		BIT0

/* ISCRL */
#define IRQ3SCB		BIT7
#define IRQ3SCA		BIT6
#define IRQ2SCB		BIT5
#define IRQ2SCA		BIT4
#define IRQ1SCB		BIT3
#define IRQ1SCA		BIT2
#define IRQ0SCB		BIT1
#define IRQ0SCA		BIT0

/* ISR */
#define IRQ7F		BIT7
#define IRQ6F		BIT6
#define IRQ5F		BIT5
#define IRQ4F		BIT4
#define IRQ3F		BIT3
#define IRQ2F		BIT2
#define IRQ1F		BIT1
#define IRQ0F		BIT0

/* 㳰٥ơ֥Υ٥ֹ */
					/* ׵ȯ */
#define IRQ_POWRESET	0		/* ѥꥻå */
#define IRQ_MANRESET	1		/* ޥ˥奢ꥻå */
/* 2-4 ϡ㳰٥ơ֥бΤǡά */
#define IRQ_TRACE	5		/* ȥ졼 */
/* 6 ϡ㳰٥ơ֥бΤǡά */
#define IRQ_NMI		7		/* ü */
#define IRQ_TRAP0	8		/* ȥå̿ */
#define IRQ_TRAP1	9		/* ȥå̿ */
#define IRQ_TRAP2	10		/* ȥå̿ */
#define IRQ_TRAP3	11		/* ȥå̿ */
/* 12-15 ϡ㳰٥ơ֥бΤǡά */
#define IRQ_IRQ0	16		/* ü */
#define IRQ_IRQ1	17		/* ü */
#define IRQ_IRQ2	18		/* ü */
#define IRQ_IRQ3	19		/* ü */
#define IRQ_IRQ4	20		/* ü */
#define IRQ_IRQ5	21		/* ü */
#define IRQ_IRQ6	22		/* ü */
#define IRQ_IRQ7	23		/* ü */
#define IRQ_SWDTEND	24		/* DTC */
#define IRQ_WOVI	25		/* åɥå */
#define IRQ_CMI 	26		/* եå女ȥ */
/* 27 ֤ϡꥶ */
#define IRQ_ADI		28		/* A/D */
/* 29, 30, 31 ֤ϡꥶ */
#define IRQ_TGI0A	32		/* TPUͥ0 */
#define IRQ_TGI0B	33		/* TPUͥ0 */
#define IRQ_TGI0C	34		/* TPUͥ0 */
#define IRQ_TGI0D	35		/* TPUͥ0 */
#define IRQ_TCI0V	36		/* TPUͥ0 */
/* 37, 38, 39 ֤ϡꥶ */
#define IRQ_TGI1A	40		/* TPUͥ1 */
#define IRQ_TGI1B	41		/* TPUͥ1 */
#define IRQ_TCI1V	42		/* TPUͥ1 */
#define IRQ_TCI1U	43		/* TPUͥ1 */
#define IRQ_TGI2A	44		/* TPUͥ2 */
#define IRQ_TGI2B	45		/* TPUͥ2 */
#define IRQ_TCI2V	46		/* TPUͥ2 */
#define IRQ_TCI2U	47		/* TPUͥ2 */
#define IRQ_TGI3A	48		/* TPUͥ3 */
#define IRQ_TGI3B	49		/* TPUͥ3 */
#define IRQ_TGI3C	50		/* TPUͥ3 */
#define IRQ_TGI3D	51		/* TPUͥ3 */
#define IRQ_TCI3V	52		/* TPUͥ3 */
/* 53, 54, 55 ֤ϡꥶ */
#define IRQ_TGI4A	56		/* TPUͥ4 */
#define IRQ_TGI4B	57		/* TPUͥ4 */
#define IRQ_TCI4V	58		/* TPUͥ4 */
#define IRQ_TCI4U	59		/* TPUͥ4 */
#define IRQ_TGI5A	60		/* TPUͥ5 */
#define IRQ_TGI5B	61		/* TPUͥ5 */
#define IRQ_TCI5V	62		/* TPUͥ5 */
#define IRQ_TCI5U	63		/* TPUͥ5 */
/* 64, 65, 66, 67, 68, 69, 70, 71 ֤ϡꥶ */
#define IRQ_DEND0A	72		/* DMAC */
#define IRQ_DEND0B	73		/* DMAC */
#define IRQ_DEND1A	74		/* DMAC */
#define IRQ_DEND1B	75		/* DMAC */
/* 76, 77, 78, 79 ֤ϡꥶ */
#define IRQ_ERI0	80		/* SCIͥ0 */
#define IRQ_RXI0	81		/* SCIͥ0 */
#define IRQ_TXI0	82		/* SCIͥ0 */
#define IRQ_TEI0	83		/* SCIͥ0 */
#define IRQ_ERI1	84		/* SCIͥ1 */
#define IRQ_RXI1	85		/* SCIͥ1 */
#define IRQ_TXI1	86		/* SCIͥ1 */
#define IRQ_TEI1	87		/* SCIͥ1 */
/* 88, 89, 90, 91 ֤ϡꥶ */

/*
 *  Хȥ
 */
/* 쥸Υɥ쥹 */
#define ABWCR		0xfed0		/* Хȥ쥸 */
#define ASTCR		0xfed1		/* ơȥȥ쥸 */
#define WCRH		0xfed2		/* ȥȥ쥸H */
#define WCRL      	0xfed3		/* ȥȥ쥸L */
#define BCRH		0xfed4		/* Хȥ쥸H */
#define BCRL		0xfed5		/* Хȥ쥸L */
#define MCR		0xfed6		/* ꥳȥ쥸 */
#define DRAMCR		0xfed7		/* DRAMȥ쥸 */
#define RTCNT		0xfed8		/* եå奿ޥ */
#define RTCOR		0xfed9		/* եå奿ޥ󥹥ȥ쥸 */

/* ƥ쥸Υӥåȥѥ */

/* ASTCR */
#define AST7 		BIT7
#define AST6 		BIT6
#define AST5 		BIT5
#define AST4 		BIT4
#define AST3 		BIT3
#define AST2 		BIT2
#define AST1 		BIT1
#define AST0 		BIT0

/* WCRH */
#define W71 		BIT7
#define W70 		BIT6
#define W61 		BIT5
#define W60 		BIT4
#define W51 		BIT3
#define W50 		BIT2
#define W41 		BIT1
#define W40 		BIT0

/* WCRL */
#define W31 		BIT7
#define W30 		BIT6
#define W21 		BIT5
#define W20 		BIT4
#define W11 		BIT3
#define W10 		BIT2
#define W01 		BIT1
#define W00 		BIT0

/* BCRH */
#define ICIS1 		BIT7
#define ICIS0 		BIT6
#define BRSTRM		BIT5
#define BRSTS1 		BIT4
#define BRSTS0		BIT3
#define RMTS2		BIT2
#define RMTS1		BIT1
#define RMTS0 		BIT0

/*
 *  ߻ΥåˤEXR쥸Υեå
 */
#define EXR_offset	28

/*
 *  ̤ȯΥ顼ϻΥå¤
 */
#ifndef _MACRO_ONLY

typedef struct exc_stack {
	UW	er6;
	UW	er5;
	UW	er4;
	UW	er3;
	UW	er2;
	UW	er1;
	UW	er0;
	UB	exr;
	UB	tmp;
	UH	ccr;	/* 1 byte : 1 byte = CCR : PC(̣Х) */
	UH	pc;	/* 1 byte : 1 byte = PC(̣Х) */
} EXCSTACK;

#endif /* _MACRO_ONLY */

#endif /* _H8S_H_ */
