/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000,2001 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2002 by Monami software, Limited Partners.
 *  Copyright (C) 2002 by MURANAKA Masaki
 *  Copyright (C) 2008-     by Monami Software Limited Partnership, JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *	COMɥ饤СPC/ATѡ
 */

#ifndef _PCAT_COM_H_
#define _PCAT_COM_H_

#include <s_services.h>

#define SIO_ERDY_RCV (1u)
#define SIO_ERDY_SND (2u)

#ifndef _MACRO_ONLY

/*
 *  ꥢݡȤΥϡɥ¸
 */
typedef struct {
  short base_address;
  short com_irq;
	UH divisor_latch;
} SIOPINIB;
typedef struct pcat_hardware_serial_port_descripter {
	const SIOPINIB *siopinib;
  INT	    initflag;	   /* ѥե饰ؤΥݥ   */
  VP_INT spcb;
} SIOPCB;

/*
 *  ꥢI/OݡȤν
 */
extern void pcat_com_initialize();

extern void pcat_com1_handler();
#if TNUM_PORT >= 2
extern void pcat_com2_handler();
#endif

extern SIOPCB *pcat_com_opn_por(ID portid, VP_INT spcb);

/*
 *  ꥢI/OݡȤνλ
 */
extern void pcat_com_cls_por(SIOPCB *p);

extern void pcat_com_ierdy_rcv(VP_INT exinf);

extern void pcat_com_ierdy_snd(VP_INT exinf);

/*
 *  ʸμФ
 */
extern INT pcat_com_rcv_chr(SIOPCB *p);

/*
 *  ʸν񤭹
 */
extern BOOL pcat_com_snd_chr(SIOPCB *p, char c);

extern void pcat_com_ena_cbr(SIOPCB *siopcb, UINT cbrtn);

extern void pcat_com_dis_cbr(SIOPCB *siopcb, UINT cbrtn);

extern void pcat_com_init(ID siopid);

extern void pcat_com_putc(ID siopid, char c);

#endif /* _MACRO_ONLY */

#endif /* _PCAT_COM_H_ */
