/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2007 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 * 32 (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_timer.h,v 1.2 2007/05/28 02:03:55 honda Exp $
 */

/*
 *  åȰ¸ޥ⥸塼M32R ¢(MFT0)ѡ
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <sys_config.h>

#define WAIT __asm("nop;nop;nop;nop");

/*
 *  ޳ߥϥɥΥ٥ֹ
 */

#define	INHNO_TIMER 20 //INT_MFT0(16) + TIMER_PORT(4) 

#ifndef _MACRO_ONLY

/*
 *  ͤɽη
 */
typedef UW	CLOCK;

/*                                                                             
 *  ͤɽȥߥáñ̤ȤѴ                               
 */
#define TO_CLOCK(nume, deno)  	(TIMER_CLKCNT * (nume) / (deno))
#define TO_USEC(clock)      	((TO_CLOCK(TIC_NUME, TIC_DENO) - (clock)) * 1000 / TIMER_CLKCNT)

/*
 *  ǽɾѥƥФݤν֤θѤ͡ñ̤ɽ
 */
#define GET_TOLERANCE			100
#define BEFORE_IREQ(clock)    	((clock) <= GET_TOLERANCE)

/*
 *  ޤν
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
hw_timer_initialize()
{
	/* ޽ */
	*(volatile unsigned short *)(ICUCR(MFT,TIMER_PORT)+2) = 0x1000;
	*(volatile unsigned short *)(MFTMOD(TIMER_PORT)+2) = 0x8001;
	*(volatile unsigned short *)(MFTCUT(TIMER_PORT)+2) = TIMER_CLKCNT;
	*(volatile unsigned short *)(MFTCR+2) = 0x8080 >> TIMER_PORT;
}

/*
 *  ޳׵Υꥢ
 */
Inline void
hw_timer_int_clear()
{	
	*(volatile unsigned char *)(ICUCR(MFT,TIMER_PORT)+2) = 0x10;	
}

/*
 *  ޤ߽
 *
 *  ޤưߤ롥
 */
Inline void
hw_timer_terminate()
{	
	*(volatile unsigned char *)(ICUCR(MFT,TIMER_PORT)+2) = 0x0;	
}

/*
 *  ޤθͤɽФ
 */
Inline CLOCK
hw_timer_get_current(void)
{
	return *(volatile unsigned short *)(MFTCUT(TIMER_PORT)+2); 
}

/*
 *  ޳׵Υå
 */
Inline BOOL
hw_timer_fetch_interrupt(void)
{
	return *(volatile unsigned char *)(ICUCR(MFT,TIMER_PORT)+2) & 0x1;
}

#endif /* _MACRO_ONLY */

#endif /* _HW_TIMER_H_ */
