/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_support.S,v 1.2 2004/10/07 17:10:56 honda Exp $
 */

/*
 *	åȥƥ¸⥸塼 ֥
 *ͥǻѤMPC860T TB6102Sѡ
 *  
 *  ܡɰ¸ʬΥȡΥեϤۤȤɶˤʤä
 *  ޤΤǡΤޤޤˤƤ롣
 *  
 */

#define _MACRO_ONLY
#include "jsp_kernel.h"

/*
 *  ꥳޥɥ쥸MCRꤹWRITEڥ
 *
 *  OP=00WRITE
 *  UM=0UPMA
 *  MB=000RUNޥɤΤͭ
 *  MCLF=0RUNޥɤΤͭ
 *  MAD=0ꥢ쥤ǥå
 *  ʶˤƤơ̤Υǡ
 *  
 */
#define MCR_WRITE_OP	0

/*
 *  ٥Υåȥƥ¸ν
 *
 *  ȥåץ⥸塼ǡν˸ƤӽФ롥
 *  
 *  쥸
 *  r10쥸ΰƬɥ쥹
 *  
 */
    .text
    .globl hardware_init_hook
hardware_init_hook: 
    /*  ipm_tableSPRG3˥ԡ  */
    LI32(r4, ipm_table)
    mtspr   SPRG3, r4

    /*  ޥåץ쥸IMMRν  */
    /* 쥸ΰƬɥ쥹 */  
    lis     r10, IMMR_UPPER_2BYTE /*  2Х  */
    mtspr   IMMR, r10   /*  2ХȤϾ񤭤Ƥ˲ʤ  */
    
#ifdef DOWNLOAD_TO_RAM      /*  ǥХå  */
    
    /*
     *  RAM˥ɤ
     *
     *  㳰٥ΥեåȤ0x000x,xxxxˤ롣
     */
    li      r5, 0
    mtmsr   r5		/*  MSR.IP0  */
    blr
    
#else /* DOWNLOAD_TO_RAM */ /*  ROM  */
    

    /*  Хȥν  */    

    /*
     *  եȥåɥåޤν
     */

    /*  åɥåޤ򥯥ꥢ  */
    li      r6, SWSR_CLEAR1
    sth     r6, TADR_SIU_SWSR(r10)
    ori     r6, r0, SWSR_CLEAR2
    sth     r6, TADR_SIU_SWSR(r10)
    
    /*
     *  åɥåޤǥ֥ˤ
     *    SYPCR.SWE0
     */
    lwz     r5, TADR_SIU_SYPCR(r10)
    ori	    r5, r5, SYPCR_SWE
    xori    r5, r5, SYPCR_SWE
    stw     r5, TADR_SIU_SYPCR(r10)


    /*
     *  FlashROMХȥν
     *  2MB
     *  ɥ쥹ޥåס0x1000,0000-0x101f,ffff
     *  åץ쥯ȿ桧CS0
     *  ꥳȥ顧ѥåס쥯ȡޥGPCM
     *  16ӥåȥ
     *  
     *  ֡ȥåץ쥯CS0˴ؤƤ
     *  BR0OR0νꤷʤФʤʤ
     *  
     */

    /*
     *  Хʬ
     *  SCCR.EBDF=00CLKOUTGCLK21ʬ
     */
    LI32(r4, UNLOCK_KEY)
    stw     r4, TADR_SCCRK(r10)     /* SCCRå */
    lwz     r5, TADR_SCCR(r10)
    oris    r6, r5, (SCCR_EBDF>>16)
    xoris   r7, r6, (SCCR_EBDF>>16)
    stw     r7, TADR_SCCR(r10)
    li      r0, 0
    stw     r0, TADR_SCCRK(r10)     /* SCCRå */


    /*
     *  ١쥸BR0 = 0x1000,0801
     *  BA=0x1000(0b)ϰ 0x1000,0000
     *  PS=10ݡȥ 16ӥå
     *  PARE=0ѥƥǥ֥
     *  WP=0꡼ɡ饤ȵġݸʤˡ׸Ƥ
     *  MS=00UPMA
     *  V=1BR0,OR0ͭ
     *
     *ϡɥޥ˥奢ˤBR0ϥ꡼ɥ꡼
     *뤬餷
     */
    LI32(r3, 0x10000801)
    stw     r3, TADR_BR0(r10)

    /*
     *  ץ󡦥쥸OR0 = 0xffe0,0936
     *  MA=0xffe0(0b)ϰ21ӥåȡʡ2MB
     *  CSNT=1åס쥯ȡͥȴ
     *  ACS=00CS򥢥ɥ쥹饤Ʊ˽
     *  BIH=1СȶػߡGPCMʤ饻åȤʤФʤʤ
     *  SYC=3Ĺ
     *  SETA=0žΥåϺǽΥǧ
     *  TRLX=1ߥ󥰴
     *  EHTR=1꡼ɻΥۡɻֱĹ
     */
    LI32(r4, 0xffe00936)
    stw     r4, TADR_OR0(r10)

    /*  MSR.IP=0(A20=L)ξϤ˥  */
    LI32(r5, activate_A20_line)
    mtctr   r5
    bctr
    
    /*  A20γ  */
activate_A20_line:
    /*  I/OǽPBPAR.DD270  */
    lhz     r6, (TADR_PBPAR + 2)(r10)
    andi.   r6, r6, (~PBPAR_DD27 & 0xffff)
    sth     r6, (TADR_PBPAR + 2)(r10)

    /*  ʽϡˡPBDIR.DR271  */
    lhz     r7, (TADR_PBDIR + 2)(r10)
    ori     r7, r7, PBDIR_DR27
    sth     r7, (TADR_PBDIR + 2)(r10)
    
    /*  ƥ֤˥ɥ饤֡PBODR.OD270  */
    lhz     r8, (TADR_PBODR + 2)(r10)
    andi.   r8, r8, (~PBODR_OD27 & 0xffff)
    sth     r8, (TADR_PBODR + 2)(r10)
    
    /*  A20=1ϡPBDAT.D271  */
    lhz     r9, (TADR_PBDAT + 2)(r10)
    ori     r9, r9, PBDAT_D27
    sth     r9, (TADR_PBDAT + 2)(r10)
    nop
    nop
    nop


    /*
     *  SDRAMХȥν
     *  50MHz
     *  16MB
     *  ɥ쥹ޥåס0x0000,0000-0x00ff,ffff
     *  åץ쥯ȿ桧CS2
     *  ꥳȥ顧桼ץޥ֥롦ޥUPMA
     *  32ӥåȥ
     *  
     *  쥸
     *  r10쥸ΰƬɥ쥹
     *  
     *  
     *  UPM쥸ORxBRxνꤹ
     *  
     *  
     */

    /*
     *  ꥳȥUPMA쥸
     *  
     *  եå1CLKߥץꥹ͡ߥ޼
     *  20nsecߡ 32 ߡ24
     *  15.36sec
     */

    /*
     *  ޡץꥹ顦쥸MPTPR = 0x0200
     *  PTP=0x232ˤʬ
     */
    ori     r3, r0, 0x0200
    sth     r3, TADR_MPTPR(r10)

    /*
     *  ޥA⡼ɡ쥸MAMR = 0x1880,2111
     *  PTx=24եå
     *  PTxE=1ޥ֥͡
     *  AMx=0ɥ쥹¿ť
     *  DSx=00ǥ֥ 1
     *  G0CLx=001GPL0Ф륢ɥ쥹饤ϤA11
     *  GPLx4DIS=0UPWAIT/GPL_x4GPL_x4
     *  RLFx=0001꡼ɥΥ롼 1
     *  WLFx=0001饤ȥΥ롼 1
     *  TLFx=0001ޥӥΥ롼 1
     */
    LI32(r4, 0x18802111)
    stw     r4, TADR_MAMR(r10)

    /*
     *  ץ󡦥쥸OR2 = 0xff00,0600
     *  MA=0xff00(0b)ϰ24ӥåȡʡ16MB
     *  SAM=0¿Ųɥ쥹ʤ
     *  G5LA=1GPL_A5GPL5
     *  G5LS=1GPL5GCLK1_50Ω夬ꥨåH˥ɥ饤
     *  BIH=0Сȥ򥵥ݡ
     */
    LI32(r5, 0xff000600)
    stw     r5, TADR_OR2(r10)

    /*
     *  ١쥸BR2 = 0x0000,0081
     *  BA=0x0000(0b)ϰ 0x0000,0000
     *  PS=00ݡȥ 32ӥå
     *  PARE=0ѥƥǥ֥
     *  WP=0꡼ɡ饤ȵġݸʤ
     *  MS=10UPMA
     *  V=1BR2,OR2ͭ
     */
    ori     r6, r0, 0x0081
    stw     r6, TADR_BR2(r10)
    
    /*
     *  RAM쥤ν
     *  RAM쥤MPC860¢Ǥꡢ˥
     *  ݤγƥˤԥξ֤ꤹ롣
     *  
     *  쥸
     *  r3ݥ󥿥ơ֥ؤΥݥ
     *  r4񤭹ɿʻĤ
     *  r5ǡΥɥ쥹
     *  r6žΥǥå
     *  r10쥸ΰƬɥ쥹
     */
	    /*  lwzu̿᤬Ȥ䤹ʤ褦  */
	    /*  ɥ쥹-4Ƥ  */
    LI32(r3, (RAM_array_index-4))

    /*  ֥åǡ񤭹ߥ롼  */
RAM_array_block_init_loop:
    lwzu    r4, 4(r3)       /*  ɿ  */
    			    /*    r3󥯥Ȥ */
    cmpwi   crf0, r4, 0     /*  ơ֥˻ꤵ줿ɿ  */
    beq     SDRAM_init      /*  ʤСǥХν  */
    lwzu    r5, 4(r3)       /*  ǡΥɥ쥹  */
    			    /*  lwzu̿᤬Ȥ䤹ʤ褦  */
    			    /*  ɥ쥹-4ƳǼƤ  */
    lwzu    r6, 4(r3)       /*  žΥǥå  */
    			    /*    r3󥯥Ȥ */

    /*
     *  ɥǡ񤭹ߥ롼
     *  ǡ쥸MDR˽񤭹ǡ
     *  WRITEڥɤˤRAM쥤ž
     */
RAM_array_word_init_loop:
    lwzu    r8, 4(r5)   /*  ǡ  */
			/*    r5󥯥Ȥ */
    stw     r8, TADR_MDR(r10)   /*  񤭹ߥǡ  */
    ori     r9, r6, MCR_WRITE_OP
    stw     r9, TADR_MCR(r10)   /*  WRITEޥȯ  */
    subi    r4, r4, 1
    addi    r6, r6, 1
    cmpwi   crf0, r4, 0         /*  񤭹٤ǡĤäƤ  */
    bne     RAM_array_word_init_loop    /*  Υɥǡν  */
                    /*  ǡĤäƤʤСΥ֥åν  */
    b       RAM_array_block_init_loop


    /*  SDRAMʥǥХΡˤν  */
SDRAM_init: 
    /*
     *  Х󥯡ץ㡼
     *  
     *  ꥳޥɥ쥸MCR = 0x8000,4105
     *  OP=10RUN
     *  UM=0UPMA
     *  MB=010CS2
     *  MCLF=1롼1
     *  MAD=5ꥢ쥤ǥå
     *  Х󥯥ץ㡼̿᤬äƤ
     */
    LI32(r3, 0x80004105)
    stw     r3, TADR_MCR(r10)
        
    /*
     *  ȥեå 8
     *  
     *  ꥳޥɥ쥸MCR = 0x8000,4830
     *  OP=10RUN
     *  UM=0UPMA
     *  MB=010CS2
     *  MCLF=8롼 8 ʥեå
     *  MAD=0x30ꥢ쥤ǥå
     *  ʥȥեå̿᤬äƤ
     */
    LI32(r4, 0x80004830)
    stw     r4, TADR_MCR(r10)
    
    
    /*
     *  ư⡼
     *  CAS쥤ƥ󥷡2
     *  СĹ 4
     *  
     *  ꥢɥ쥹쥸MAR = 0x0000,0088
     *  ɥ쥹Х˽Ϥ졢SDRAMؤ̿Ȥʤ
     *  
     *  ꥳޥɥ쥸MCR = 0x8000,4106
     *  OP=10RUN
     *  UM=0UPMA
     *  MB=010CS2
     *  MCLF=1롼 1 
     *  MAD=6ꥢ쥤ǥå
     *  ư⡼̿᤬äƤ
     */
    ori     r5, r0, 0x0088
    stw     r5, TADR_MAR(r10)
    LI32(r6, 0x80004106)
    stw     r6, TADR_MCR(r10)
    

/*
 *  㳰٥Υԡ
 */
copy_exception_vector:
	/*  lwzu̿Ȥ-4Ƥ  */
	LI32(r7, EXCEPTION_VECTOR_START_SRC - 4)
	LI32(r8, EXCEPTION_VECTOR_END_SRC - 4)
	LI32(r9, EXCEPTION_VECTOR_START_DST - 4)
copy_exception_vector_1:
	lwzu	r10, 4(r7)	/*  r7ι1̿Ǽ¹Ԥ  */
	stwu	r10, 4(r9)	/*  r9ι1̿Ǽ¹Ԥ  */
	cmpw	crf0, r7, r8
	blt	copy_exception_vector_1
	
        /*
         *  MSR.IP0
         *㳰ץեå0x000n,nnnn
         */
	li	r3, MSR_IP
	mfmsr	r4
	or	r4, r4, r3
	xor	r4, r4, r3
	mtmsr	r4
	
	LI32(r10, start_1)
	mtctr	r10
	bctr
	nop
	nop
	nop
	nop

/*
 *  RAM쥤ν˻ѤǡؤΥݥ󥿥ơ֥
 *  ɿǡΥɥ쥹žΥǥå
 *  1åȡ1֥åʬ
 *  ǡΥɥ쥹lwzu̿᤬Ȥ䤹ʤ褦
 *  -4Ƥ롣
 *  
 *  ǸϥɿΥǡ֤롼׽λȽѤ
 */
RAM_array_index:    
    /*
     *  ꡼ɡ󥰥롦ӡ׵ʷ 16ɡ
     *  ꡼ɡ󥰥롦ӡ׵5ɡ
     *  Х󥯥ץ㡼1ɡ
     *  ⡼2ɡ
     *  ꡼ɡС׵8ɡ
     */
    .int    16                  /*  ɿ  */
    .int    RAM_array_RSS - 4   /*  ǡΥɥ쥹  */
    .int    0x0                 /*  žΥǥå  */

    /*
     *  饤ȡ󥰥롦ӡ׵
     */
    .int    4                   /*  ɿ  */
    .int    RAM_array_WSS - 4   /*  ǡΥɥ쥹  */
    .int    0x18                /*  žΥǥå  */

    /*
     *  饤ȡС׵
     */
    .int    7                   /*  ɿ  */
    .int    RAM_array_WBS - 4   /*  ǡΥɥ쥹  */
    .int    0x20                /*  žΥǥå  */

    /*
     *  ׵ʥȥեå
     */
    .int    5                   /*  ɿ  */
    .int    RAM_array_TPS - 4   /*  ǡΥɥ쥹  */
    .int    0x30                /*  žΥǥå  */

    /*
     *  㳰׵
     */
    .int    1                   /*  ɿ  */
    .int    RAM_array_EXS - 4   /*  ǡΥɥ쥹  */
    .int    0x3c                /*  žΥǥå  */

    /*
     *  롼׽λȽѥǡ
     */
    .int    0                   /*  ɿ  */
    

/*
 *  RAM쥤˥ԡǡ
 */

    /*
     *  ʲΣĤ̿ᷲϢ³ΰ֡ʷ 16ɡ
     *  ꡼ɡ󥰥롦ӡ׵5ɡ
     *  Х󥯥ץ㡼1ɡ
     *  ⡼2ɡ
     *  ꡼ɡС׵8ɡ
     */
RAM_array_RSS:  
    /*  ꡼ɡ󥰥롦ӡ׵  */
    .int    0x1f07fc04                      /*  0  */
    .int    0xeeaef004                      /*  1  */
    .int    0x11adf004                      /*  2  */
    .int    0xefbbbc00                      /*  3  */
    .int    0x1ff77c47                      /*  4  */
    /*  Х󥯥ץ㡼  */
    .int    0x1ff77c07                      /*  5  */
    /*  ⡼ѥǡ  */
    .int    0xefcab034                      /*  6  */
    .int    0x1f357405                      /*  7  */
    /*  ꡼ɡС׵  */
    .int    0x1f07fc04                      /*  8  */
    .int    0xeeaef004                      /*  9  */
    .int    0x10adf004                      /*  a  */
    .int    0xf0affc00                      /*  b  */
    .int    0xf0affc00                      /*  c  */
    .int    0xf1affc00                      /*  d  */
    .int    0xefbbbc00                      /*  e  */
    .int    0x1ff77c47                      /*  f  */

    /*
     *  饤ȡ󥰥롦ӡ׵
     */
RAM_array_WSS:
    .int    0x1f07fc04                      /*  0x18 + 0  */
    .int    0xeeaeb000                      /*  0x18 + 1  */
    .int    0x01b93004                      /*  0x18 + 2  */
    .int    0x1ff77c47                      /*  0x18 + 3  */

    /*
     *  饤ȡС׵
     */
RAM_array_WBS:
    .int    0x1f07fc04                      /*  0x20 + 0  */
    .int    0xeeaeb000                      /*  0x20 + 1  */
    .int    0x10ad7000                      /*  0x20 + 2  */
    .int    0xf0affc00                      /*  0x20 + 3  */
    .int    0xf0affc00                      /*  0x20 + 4  */
    .int    0xe1bbbc04                      /*  0x20 + 5  */
    .int    0x1ff77c47                      /*  0x20 + 6  */

    /*
     *  ׵ʥȥեå
     */
RAM_array_TPS:
    .int    0x1ff5fc84                      /*  0x30 + 0  */
    .int    0xfffffc04                      /*  0x30 + 1  */
    .int    0xfffffc04                      /*  0x30 + 2  */
    .int    0xfffffc84                      /*  0x30 + 3  */
    .int    0xfffffc05                      /*  0x30 + 4  */

    /*
     *  㳰׵
     */
RAM_array_EXS:
    .int    0xfffffc07                      /*  0x3c + 0  */


#endif  /*  DOWNLOAD_TO_RAM  */
/*  end of file  */
