/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: tb6102s.h,v 1.2 2004/10/07 17:10:56 honda Exp $
 */

/*
 *  ХåMPC860T CPUܡTB6102S
 *  Υϡɥ񸻤
 */

#ifndef _TB6102S_H_
#define _TB6102S_H_


/*
 *  ߴϢ
 */

/*  ̤γߤФIPMΥǥե  */
#define DEFAULT_IPM	0x00	/*  ٤Ƥγߤػ  */

/*  CPMSIUؤγ׵٥  */
	/*  CICR.IRL0͡ʥӥå16-182ʿ  */
#define CICR_IRL0	(CPM_INT_LEVEL << (31 - 18))

/*  SIU鸫CPMγֹ  */
#define INHNO_CPM		LEVEL_TO_INHNO(CPM_INT_LEVEL)

/*  SIU鸫CPMγߵĥӥå  */
#define ENABLE_CPM		LEVEL_TO_ENABLE_BIT(CPM_INT_LEVEL)

/*  CPMߤIPM  */
#define IPM_CPM			LEVEL_TO_IPM(CPM_INT_LEVEL)


/*
 *  ޴Ϣ
 *
 */
/* ޤγߥ٥SIU٥ */
#define INTLVL_PIT	INTLVL_TIMER


/*
 *  GDB STUBƽФ롼̤
 */
#ifndef _MACRO_ONLY
#ifdef GDB_STUB

#define tb6102s_exit	stub_exit
#define tb6102s_putc	stub_putc

Inline void
stub_exit(void)
{
}

Inline void
stub_putc(char c)
{
}

/*
 *  GDB stubȤʤROMѡ
 */
#else /* GDB_STUB */

extern void	smc_putc_pol(char c);	/*  mpc860_smc.c  */

/*
 *  SILΥǽͭˤ
 */
#ifdef SIL_DEBUG

#define SIL_BUFFER_SIZE	10000
char sil_buffer[SIL_BUFFER_SIZE];
int sil_pos;
BOOL sil_debug_on;

Inline void
tb6102s_exit()
{
	int i;

	sil_debug_on = FALSE;
	
	/*  󥰥ХåեŤ˥ǡɽ  */
	for(i=sil_pos; i<SIL_BUFFER_SIZE; i++) {
		smc_putc_pol(sil_buffer[i]);
	}
	for(i=0; i<sil_pos; i++) {
		smc_putc_pol(sil_buffer[i]);
	}
	while(1);
}

Inline void 
tb6102s_putc(char c)
{
	++sil_pos;
	sil_pos %= SIL_BUFFER_SIZE;
	sil_buffer[sil_pos] = c;
}

#else	/* SIL_DEBUG */

Inline void
tb6102s_exit()
{
	while(1);
}

Inline void 
tb6102s_putc(char c)
{
	smc_putc_pol(c);
}

#endif	/* SIL_DEBUG */

#endif /* GDB_STUB */
#endif /* _MACRO_ONLY */
#endif /* _TB6102S_H_ */
/*  end of file  */
