/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_support.S,v 1.3 2015/06/28 16:47:29 ssuzuki Exp $
 */

#define	_MACRO_ONLY
#include "rx63n.h"

	.text
	.globl _hardware_init_hook
_hardware_init_hook:
	mov.l	#RX63N_PRCR, r1
	mov.w	#0xa503,[r1]

	/*
	 *  ꥻåȸưƤյǽ(DMAEXDMA)
	 */
	mov.l	#RX63N_MSTPCRA, r1	
	mov.l	[r1], r2
	bset	#28, r2			; DMA
	bset	#29, r2			; EXDMA
	mov.l	r2, [r1]

	/*
	 *  ¸ߤʤݡȤ
	 */
	mov.l	#RX63N_PORT0_PDR, r1
	mov.b	#0x0f, [r1]		; P00-P03
	mov.l	#RX63N_PORT1_PDR, r1
	mov.b	#0x03, [r1]		; P10-P11
	mov.l	#RX63N_PORT2_PDR, r1
	mov.b	#0x00, [r1]		; none
	mov.l	#RX63N_PORT3_PDR, r1
	mov.b	#0x00, [r1]		; none
	mov.l	#RX63N_PORT4_PDR, r1
	mov.b	#0x00, [r1]		; none
	mov.l	#RX63N_PORT5_PDR, r1
	mov.b	#0xc0, [r1]		; P56-P57
	mov.l	#RX63N_PORT6_PDR, r1
	mov.b	#0xff, [r1]		; P60-67
	mov.l	#RX63N_PORT7_PDR, r1
	mov.b	#0xff, [r1]		; P70-77
	mov.l	#RX63N_PORT8_PDR, r1
	mov.b	#0xff, [r1]		; P80-87
	mov.l	#RX63N_PORT9_PDR, r1
	mov.b	#0xff, [r1]		; P90-97
	mov.l	#RX63N_PORTA_PDR, r1
	mov.b	#0x00, [r1]		; none
	mov.l	#RX63N_PORTB_PDR, r1
	mov.b	#0x00, [r1]		; none
	mov.l	#RX63N_PORTC_PDR, r1
	mov.b	#0x00, [r1]		; none
	mov.l	#RX63N_PORTD_PDR, r1
	mov.b	#0x00, [r1]		; none
	mov.l	#RX63N_PORTE_PDR, r1
	mov.b	#0x00, [r1]		; none
	mov.l	#RX63N_PORTF_PDR, r1
	mov.b	#0x3f, [r1]		; PF0-PF5
	mov.l	#RX63N_PORTG_PDR, r1
	mov.b	#0xff, [r1]		; PG0-OG7
	mov.l	#RX63N_PORTJ_PDR, r1
	mov.b	#0x20, [r1]		; PJ5

	/* öå®åץ졼ڤؤ */
	mov.l	#RX63N_SCKCR3, r1
	mov.w	#0x0000, [r1]

	/*
	 *  ᥤ󥯥åȯ(tMAINOSC)  20 ms Ȳꤹȡ
	 *
	 *    MOSCWTCR.MSTS[4:0]=14(262,144 cycle > 20.00 ms = 240,000 cycles)
	 *
	 *  ξ硢ᥤ󥯥åȯԵ
	 *  (桼եȥˤäԤĻ)ϰʲΤ褦ˤʤ:
	 *
	 *    tMAINOSC + (262,144 + 16384)/ fMAIN
	 *    = 20 + (262,144 + 16,384) / 12,000 = 43.23 ms
	 */
	mov.l	#RX63N_MOSCWTCR, r1
	mov.b	#14, [r1]

	; ᥤ󥯥åȯư
	mov.l	#RX63N_MOSCCR, r1
	bclr	#0, [r1].b		; MOSCCR.MOSTP=0
	; MOSCCR.MOSTP  0 ɤ褦ˤʤޤԵ
1:	movu.b	[r1], r2
	tst	r2, r2
	bnz	1b

	mov.l	#44, r1
	bsr	mdelay

	/* 
	 *  ᥤ󥯥å 1 ʬ8 ܤ
	 *  96MHz  PLL å硢
	 *
	 *    PLLWTCR.PSTS=9(n = 65536 cycles = 682.7 us)
	 *
	 *  ꤹ롣
	 *  ξ硢PLL åȯԵ֤ϰʲΤ褦ˤʤ롣
	 *
	 *   tPLL1 + (n + 131,072) / fPLL
	 *   = 0.5 + (65,536 + 131,072)/ 96,000 = 2.548 ms
	 */
	mov.l	#RX63N_PLLCR, r1
	mov.w	#0x0700, [r1]
	mov.l	#RX63N_PLLWTCR, r1
	mov.b	#9, [r1]
	mov.l	#RX63N_PLLCR2, r1
	bclr	#0, r1			; PLLCR2.PLLEN=0

	mov.l	#3, r1
	bsr	mdelay

	/*
	 * FCLKICLKBCLK  PCLK ʬʲΤ褦ꤹ:
	 *   FCLK: 4 ʬ
	 *   ICLK: 4 ʬ
	 *   BCLK: 64 ʬ
	 *   PCLKA: 4 ʬ
	 *   PCLKB: 4 ʬ
	 *   IECLK: 64 ʬ
	 */
	mov.l	#RX63N_SCKCR, r1
	mov.l	#0x22c62211, [r1]
	mov.l	#RX63N_SCKCR2, r1
	mov.w	#0x0012, [r1]

	/* å PLL åڤؤ */
	mov.l	#RX63N_SCKCR3, r1
	mov.w	#0x0400, [r1]

	mov.l	#RX63N_PRCR, r1
	mov.w	#0xa500, [r1]

	rts

mdelay:
	tst	r1, r1
	bz	2f
1:	.rept	125 - 4
	nop
	.endr
	sub	#1, r1
	bnz	1b
2:	rts
