/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: rx63nsci.h,v 1.3 2015/06/28 15:32:41 ssuzuki Exp $
 */

/*
 *	RX63N¢SCI ʰSIOɥ饤
 */

#ifndef _RX63NSCI_H_
#define _RX63NSCI_H_

#include <t_config.h>

/*
 *  ꥢI/Oݡȴ֥å
 */
typedef struct sio_port_control_block	SIOPCB;

/*
 *  Хå롼μֹ
 */
#define SIO_ERDY_SND	1u		/* ǽХå */
#define SIO_ERDY_RCV	2u		/* ΥХå */

/*
 *  SIOɥ饤Фν롼
 */
extern void	rx63nsci_initialize(void);

/*
 *  ץ󤷤ƤݡȤ뤫
 */
extern BOOL	rx63nsci_openflag(ID siopid);

/*
 *  ꥢI/OݡȤΥץ
 */
extern SIOPCB	*rx63nsci_opn_por(ID siopid, VP_INT exinf);

/*
 *  ꥢI/OݡȤΥ
 */
extern void	rx63nsci_cls_por(SIOPCB *siopcb);

/*
 *  ꥢI/OݡȤؤʸ
 */
extern BOOL	rx63nsci_snd_chr(SIOPCB *siopcb, char c);

/*
 *  ꥢI/OݡȤؤʸ(ݡ)
 */
extern BOOL	rx63nsci_snd_chr_pol(ID siopid, char c);

/*
 *  ꥢI/OݡȤʸ
 */
extern INT	rx63nsci_rcv_chr(SIOPCB *siopcb);

/*
 *  ꥢI/OݡȤΥХåε
 */
extern void	rx63nsci_ena_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  ꥢI/OݡȤΥХåζػ
 */
extern void	rx63nsci_dis_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  SIOγߥӥ롼
 */
extern void	rx63nsci_isr_rxi(ID siopid);
extern void	rx63nsci_isr_txi(ID siopid);
extern void	rx63nsci_isr_tei(ID siopid);

/*
 *  ꥢI/OݡȤǽХå
 */
extern void	rx63nsci_ierdy_snd(VP_INT exinf);

/*
 *  ꥢI/OݡȤμΥХå
 */
extern void	rx63nsci_ierdy_rcv(VP_INT exinf);

#endif /* _RX63NSCI_H_ */
