/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  Copyright (C) 2004 by SEIKO EPSON Corp, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 */
OUTPUT_FORMAT("elf32-c33", "elf32-c33",
              "elf32-c33")
OUTPUT_ARCH(c33)

PROVIDE (hardware_init_hook = 0) ;
PROVIDE (software_init_hook = 0) ;
PROVIDE (software_term_hook = 0) ;

SECTIONS
{
	/* data pointer symbol By GWB33 */
	__dp = 0x00000000;

	/* section information By GWB33 */
	. = 0x00600000;

	/* Map vector table */
	__START_vector_lma = 0x0c00000;
	.vector : AT( __START_vector_lma ){
		__START_vector = . ;
		sys_start.o(.data)
	}
	__END_vector = .;
	__END_vector_lma = __START_vector_lma + SIZEOF( .vector );

	/* section information */
	. = __END_vector_lma ;

	.text : {
	   __START_text = . ; 
	   *(.text) 
	}
	__END_text = . ; 

	.rodata : {
	   __START_rodata = . ; 
	   *(.rodata) 
	}
	__END_rodata = . ; 

	. = __END_vector;

	.bss : {
	   __START_bss = . ; 
	   *(.bss) 
	}
	 __END_bss = . ; 

	.data __END_bss : AT( __END_rodata ) {
	   __START_data = . ; 
	   *(.data) 
	}
	__START_data_lma = LOADADDR( .data );
	__END_data_lma = __START_data_lma + SIZEOF( .data );


}
