/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 *  Copyright (C) 2010 by Cronus Computer Works, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id
 */

#include "jsp_kernel.h"
#include <sil.h>
#include <s_services.h>
#include "sh726xscif.h"

/*
 *  åȥƥ¸ν
 */
/*
 *  ꥢI/OݡȤν bannerϤΤᥫͥν̵ط˹Ԥ
 */
void
sys_initialize ()
{
	SIOPCB *siopcb;

	/* ѤյϤͭˤƤ */
	/*  SCIFǡϥݡȤ  */

#ifndef GDB_STUB

	/* SCIF3 */
	sil_wrb_mem (STBCR4, (VB) ((VB) sil_reb_mem (STBCR4) & ~0x10));
	sil_wrh_mem (PECRL4, sil_reh_mem (PECRL4) | (0x0030 | 0x0003));

#else /* GDB_STUB */

	/* SCIF3 */
	sil_wrb_mem (STBCR4, (VB) ((VB) sil_reb_mem (STBCR4) & ~0x10));
	sil_wrh_mem (PECRL4, sil_reh_mem (PECRL4) | (0x0003 | 0x0030));

#endif /* GDB_STUB */

	/* CMT0 */
	sil_wrb_mem (STBCR4, (VB) ((VB) sil_reb_mem (STBCR4) & ~0x04));
	/*
	 *  ǥХ¸Υץ
	 */
	/*ХʡϤ뤿 */
	sh2scif_initialize();
	siopcb = sh2scif_opn_por (LOGTASK_PORTID, 0);
}

/*
 *  åȥƥνλ
 */
void
sys_exit ()
{
	sh2_exit ();
}

/*
 *  åȥƥʸ
 */
void
sys_putc (char c)
{
	if (c == '\n') {
		sh2_putc (LOGTASK_PORTID, '\r');
	}
	sh2_putc (LOGTASK_PORTID, c);
}

/* ϡɥ */
/* ǤϥХΤ߹Ԥյsys_initializeǹԤ */
#ifndef GDB_STUB
void
hardware_init_hook (void)
{
	/* åȯν */
	sil_wrh_mem (FRQCR, 0x0104);	/* å I=200MHz, B=66.666MHz, P=33.333MHz */

	/* Хȥ */
	sil_wrw_mem (CMNCR, 0x00001010);
	sil_wrw_mem (CS0BCR, 0x24920400);
	sil_wrw_mem (CS0WCR, 0x00001382);
	sil_wrw_mem (CS3BCR, 0x24924600);
	sil_wrw_mem (CS3WCR, 0x00004912);
	sil_wrw_mem (SDCR, 0x00000909);
	sil_wrw_mem (RTCSR, 0xa55a0010);
	sil_wrw_mem (RTCOR, 0xa55a0040);

	/* I/OݡȤ */
	sil_wrh_mem (PBIORL, 0x0c00);	/* PC11,PC10  (LED³ݡ) */
	sil_wrh_mem (PBCRL4, 0x5a00);
	sil_wrh_mem (PBCRL3, 0x0000);	/* PC11,PC10⡼ ݡ (LED³ݡ) */
	sil_wrh_mem (PBCRL2, 0x0000);
	sil_wrh_mem (PBCRL1, 0x0000);
	sil_wrh_mem (PCIORL, 0x0000);
	sil_wrh_mem (PCCRL4, 0x0011);
	sil_wrh_mem (PCCRL3, 0x1111);
	sil_wrh_mem (PCCRL2, 0x1111);
	sil_wrh_mem (PCCRL1, 0x1111);
	sil_wrh_mem (PDIORL, 0x0000);
	sil_wrh_mem (PDCRL4, 0x1111);
	sil_wrh_mem (PDCRL3, 0x1111);
	sil_wrh_mem (PDCRL2, 0x1111);
	sil_wrh_mem (PDCRL1, 0x1111);
	sil_wrh_mem (PEIORL, 0x0000);
	sil_wrh_mem (PECRL4, 0x0000);
	sil_wrh_mem (PECRL3, 0x1010);
	sil_wrh_mem (PECRL2, 0x1111);
	sil_wrh_mem (PECRL1, 0x1111);
	sil_wrh_mem (PFIORH, 0x7fff);
	sil_wrh_mem (PFIORL, 0xffff);
	sil_wrh_mem (PFCRH4, 0x0000);
	sil_wrh_mem (PFCRH3, 0x0000);
	sil_wrh_mem (PFCRH2, 0x0000);
	sil_wrh_mem (PFCRH1, 0x0000);
	sil_wrh_mem (PFCRL4, 0x0000);
	sil_wrh_mem (PFCRL3, 0x0000);
	sil_wrh_mem (PFCRL2, 0x0000);
	sil_wrh_mem (PFCRL1, 0x0000);

	/* CMT إå */
	sil_wrb_mem (STBCR4, (VB) ((VB) sil_reb_mem (STBCR4) & ~0x04));

	/* 100usec Ԥ */
	sil_wrh_mem (CMSTR, 0x0000);	/* STR0=0 0  */
	sil_wrh_mem (CMCSR_0, 0x0000);	/* CKS=00 å P/8 */
	sil_wrh_mem (CMCNT_0, 0);		/* 0 ꥢ󥹥 */
	sil_wrh_mem (CMCOR_0, ((((PCLOCK / 8)/1000000) * 100) - 1));
	sil_wrh_mem (CMSTR, 0x0001);	/* STR0=1 0  */
	while ((sil_reh_mem (CMCSR_0) & 0x0080) == 0);
									/* CMF==1 ˤʤޤԤ */

	sil_wrh_mem (SDRAM_MODE, 0x000);	/* SDRAM⡼ɥ쥸 */

	/* å */
	sil_wrw_mem (CCR1, 0x00000808);	/* åեå */
	sil_wrw_mem (CCR1, CCR_MODE);	/* å⡼ɤ */
}
#else /*  GDB_STUB  */
void
hardware_init_hook (void)
{
}
#endif /*  GDB_STUB  */
