/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_context.h,v 1.5 2005/07/06 00:45:07 honda Exp $
 */

/*
 *	ƥ롼SH2ѡ
 *
 *  Υե cpu_config.h ʬΥƤΤϡΥե TCB
 *  줿ɤɬפΤФơcpu_config.h ˤ TCB 
 *  ɤɬפޤǤ뤿Ǥ롥
 */

#ifndef _CPU_CONTEXT_H_
#define _CPU_CONTEXT_H_

#include "task.h"

/*
 *  ƥȤν
 *
 *  ٻ߾֤˰ܹԤʥνλˤ˸
 *  Ф롥ŪˤϡƥȤ򥿥ưǤ֤
 *  ꤹcreate_context  activate_context ǹԤФ褤
 */
Inline void
create_context(TCB *tcb)
{
	Asm("nop");
}

/*
 *  εư
 *
 *  ٻ߾֤¹ԤǤ֤˰ܹԤ˸ƤФ롥
 *
 *  åˤϲѤޤʤ
 *  activate_rǤruntskɬפʾФΤǡ
 *  åѤɬפϤʤʸΨ
 */
extern void	activate_r(void);

Inline void
activate_context(TCB *tcb)
{
	UW	*sp;

	sp = (UW *)(((VB *) tcb->tinib->stk) + tcb->tinib->stksz);
	tcb->tskctxb.sp = sp;
	tcb->tskctxb.pc = activate_r;	/*  cpu_support.S  */
}

/*
 *  ext_tsk å˳ݤߡΰΥ
 *     
 *      SH1/2Ǥϥå˥ߡΰ褬ʤΤǡޥ
 *      ACTIVATED_STACK_SIZEʤ
 */

/*
 *  calltex ϻѤʤ
 */
#define OMIT_CALLTEX

#endif /* _CPU_CONTEXT_H_ */
