/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000,2001 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002 by Hokkaido Industrial Research Institute, JAPAN
 *  Copyright (C) 2010 by Cronus Computer Works, JAPAN
 *
 *  嵭ԤϡFree Software Foundation ˤäƸɽƤ
 *  GNU General Public License  Version 2 ˵ҤƤ狼
 *  ξΤ줫˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥѲǽʥХʥꥳɡʥ֥륪
 *      ȥե饤֥ʤɡˤηѤˤϡ
 *      ȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭ɽ
 *      Ѿ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥԲǽʥХʥꥳɤηޤϵ
 *      ߹ѤˤϡΤ줫ξȡ
 *    (a) ѤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) Ѥη֤̤ˡˤäơ嵭Ԥ𤹤
 *        ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭Ԥդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥϡ
 *  ܥեȥ˴ؤơŬѲǽޤơʤݾڤԤ
 *  ʤޤܥեȥѤˤľŪޤϴŪ
 *  ʤ»˴ؤƤ⡤Ǥʤ
 *
 *  @(#) $Id
 */

#ifndef _SH7263_H_
#define _SH7263_H_

#include <sil.h>

/*
 *  ߥ٥ֹ
 */
#define INT_IRQ0        64          /* IRQ0 () */
#define INT_IRQ1        65          /* IRQ1 () */
#define INT_IRQ2        66          /* IRQ2 () */
#define INT_IRQ3        67          /* IRQ3 () */
#define INT_IRQ4        68          /* IRQ4 () */
#define INT_IRQ5        69          /* IRQ5 () */
#define INT_IRQ6        70          /* IRQ6 () */
#define INT_IRQ7        71          /* IRQ7 () */
#define INT_PINT0       80          /* PINT0 () */
#define INT_PINT1       81          /* PINT1 () */
#define INT_PINT2       82          /* PINT2 () */
#define INT_PINT3       83          /* PINT3 () */
#define INT_PINT4       84          /* PINT4 () */
#define INT_PINT5       85          /* PINT5 () */
#define INT_PINT6       86          /* PINT6 () */
#define INT_PINT7       87          /* PINT7 () */
#define INT_DEI0        108         /* DMACͥ0 ȥ󥹥ե */
#define INT_HEI0        109         /* DMACͥ0 ϡե */
#define INT_DEI1        112         /* DMACͥ1 ȥ󥹥ե */
#define INT_HEI1        113         /* DMACͥ1 ϡե */
#define INT_DEI2        116         /* DMACͥ2 ȥ󥹥ե */
#define INT_HEI2        117         /* DMACͥ2 ϡե */
#define INT_DEI3        120         /* DMACͥ3 ȥ󥹥ե */
#define INT_HEI3        121         /* DMACͥ3 ϡե */
#define INT_DEI4        124         /* DMACͥ4 ȥ󥹥ե */
#define INT_HEI4        125         /* DMACͥ4 ϡե */
#define INT_DEI5        128         /* DMACͥ5 ȥ󥹥ե */
#define INT_HEI5        129         /* DMACͥ5 ϡե */
#define INT_DEI6        132         /* DMACͥ6 ȥ󥹥ե */
#define INT_HEI6        133         /* DMACͥ6 ϡե */
#define INT_DEI7        136         /* DMACͥ7 ȥ󥹥ե */
#define INT_HEI7        137         /* DMACͥ7 ϡե */
#define INT_USBI        140         /* USBȥ */
#define INT_LCDCI       141         /* LCDȥ */
#define INT_CMI0        142         /* CMTͥ0 ڥޥå */
#define INT_CMI1        143         /* CMTͥ1 ڥޥå */
#define INT_CMI         144         /* BSC եå奿ޥڥޥå */
#define INT_ITI         145         /* WDT 󥿡Х륿޳ */
#define INT_TGI0A       146         /* MTU2 TGRA0 ץåȥץ㡿ڥޥå */
#define INT_TGI0B       147         /* MTU2 TGRB0 ץåȥץ㡿ڥޥå */
#define INT_TGI0C       148         /* MTU2 TGRC0 ץåȥץ㡿ڥޥå */
#define INT_TGI0D       149         /* MTU2 TGRD0 ץåȥץ㡿ڥޥå */
#define INT_TGI0V       150         /* MTU2 TCNT0 Хե */
#define INT_TGI0E       151         /* MTU2 TGRE0 ڥޥå */
#define INT_TGI0F       152         /* MTU2 TGRF0 ڥޥå */
#define INT_TGI1A       153         /* MTU2 TGRA1 ץåȥץ㡿ڥޥå */
#define INT_TGI1B       154         /* MTU2 TGRB1 ץåȥץ㡿ڥޥå */
#define INT_TGI1V       155         /* MTU2 TCNT1 Хե */
#define INT_TGI1U       156         /* MTU2 TCNT1 ե */
#define INT_TGI2A       157         /* MTU2 TGRA2 ץåȥץ㡿ڥޥå */
#define INT_TGI2B       158         /* MTU2 TGRA2 ץåȥץ㡿ڥޥå */
#define INT_TGI2V       159         /* MTU2 TCNT2 Хե */
#define INT_TGI2U       160         /* MTU2 TCNT2 ե */
#define INT_TGI3A       161         /* MTU2 TGRA3 ץåȥץ㡿ڥޥå */
#define INT_TGI3B       162         /* MTU2 TGRB3 ץåȥץ㡿ڥޥå */
#define INT_TGI3C       163         /* MTU2 TGRC3 ץåȥץ㡿ڥޥå */
#define INT_TGI3D       164         /* MTU2 TGRD3 ץåȥץ㡿ڥޥå */
#define INT_TGI3V       165         /* MTU2 TCNT3 Хե */
#define INT_TGI4A       166         /* MTU2 TGRA4 ץåȥץ㡿ڥޥå */
#define INT_TGI4B       167         /* MTU2 TGRB4 ץåȥץ㡿ڥޥå */
#define INT_TGI4C       168         /* MTU2 TGRC4 ץåȥץ㡿ڥޥå */
#define INT_TGI4D       169         /* MTU2 TGRD4 ץåȥץ㡿ڥޥå */
#define INT_TGI4V       170         /* MTU2 TCNT4 Хեե */
#define INT_ADI         171         /* A/DѴ Ѵλ */
#define INT_IIC3STPI0   172         /* IIC3ͥ0 ߾︡ */
#define INT_IIC3NAKI0   173         /* IIC3ͥ0 NACK  */
#define INT_IIC3RXI0    174         /* IIC3ͥ0 ǡե */
#define INT_IIC3TXI0    175         /* IIC3ͥ0 ǡץƥ */
#define INT_IIC3TEI0    176         /* IIC3ͥ0 λ */
#define INT_IIC3STPI1   177         /* IIC3ͥ1 ߾︡ */
#define INT_IIC3NAKI1   178         /* IIC3ͥ1 NACK  */
#define INT_IIC3RXI1    179         /* IIC3ͥ1 ǡե */
#define INT_IIC3TXI1    180         /* IIC3ͥ1 ǡץƥ */
#define INT_IIC3TEI1    181         /* IIC3ͥ1 λ */
#define INT_IIC3STPI2   182         /* IIC3ͥ2 ߾︡ */
#define INT_IIC3NAKI2   183         /* IIC3ͥ2 NACK  */
#define INT_IIC3RXI2    184         /* IIC3ͥ2 ǡե */
#define INT_IIC3TXI2    185         /* IIC3ͥ2 ǡץƥ */
#define INT_IIC3TEI2    186         /* IIC3ͥ2 λ */
#define INT_IIC3STPI3   187         /* IIC3ͥ3 ߾︡ */
#define INT_IIC3NAKI3   188         /* IIC3ͥ3 NACK  */
#define INT_IIC3RXI3    189         /* IIC3ͥ3 ǡե */
#define INT_IIC3TXI3    190         /* IIC3ͥ3 ǡץƥ */
#define INT_IIC3TEI3    191         /* IIC3ͥ3 λ */
#define INT_BRI0        192         /* SCIFͥ0 ֥졼 */
#define INT_ERI0        193         /* SCIFͥ0 顼 */
#define INT_RXI0        194         /* SCIFͥ0 ǡե */
#define INT_TXI0        195         /* SCIFͥ0 FIFOǡץƥ */
#define INT_BRI1        196         /* SCIFͥ1 ֥졼 */
#define INT_ERI1        197         /* SCIFͥ1 顼 */
#define INT_RXI1        198         /* SCIFͥ1 ǡե */
#define INT_TXI1        199         /* SCIFͥ1 FIFOǡץƥ */
#define INT_BRI2        200         /* SCIFͥ2 ֥졼 */
#define INT_ERI2        201         /* SCIFͥ2 顼 */
#define INT_RXI2        202         /* SCIFͥ2 ǡե */
#define INT_TXI2        203         /* SCIFͥ2 FIFOǡץƥ */
#define INT_BRI3        204         /* SCIFͥ3 ֥졼 */
#define INT_ERI3        205         /* SCIFͥ3 顼 */
#define INT_RXI3        206         /* SCIFͥ3 ǡե */
#define INT_TXI3        207         /* SCIFͥ3 FIFOǡץƥ */
#define INT_SSERI0      208         /* SSUͥ0 顼 */
#define INT_SSRXI0      209         /* SSUͥ0 ǡե */
#define INT_SSTXI0      210         /* SSUͥ0 ǡץƥ/λ */
#define INT_SSERI1      211         /* SSUͥ1 顼 */
#define INT_SSRXI1      212         /* SSUͥ1 ǡե */
#define INT_SSTXI1      213         /* SSUͥ1 ǡץƥ/λ */
#define INT_SSI0        214         /* SSIͥ0  */
#define INT_SSI1        215         /* SSIͥ1  */
#define INT_SSI2        216         /* SSIͥ2  */
#define INT_SSI3        217         /* SSIͥ3  */
#define INT_ISY         218         /* CD-ROMǥ Ʊɰ۾勵ߥ */
#define INT_IERR        219         /* CD-ROMǥ ECC顼 */
#define INT_IARG        220         /* CD-ROMǥ ITARG */
#define INT_ISEC        221         /* CD-ROMǥ ڤؤ */
#define INT_IBUF        222         /* CD-ROMǥ Хåեǡž */
#define INT_IREDAY      223         /* CD-ROMǥ Хåեǡž׵ */
#define INT_FLSTEI      224         /* NANDեå女ȥ STEIװ */
#define INT_FLTENDI     225         /* NANDեå女ȥ žλ */
#define INT_FLTREQ0I    226         /* NANDեå女ȥ FIFO0ž׵ */
#define INT_FLTREQ1I    227         /* NANDեå女ȥ FIFO0ž׵ */
#define INT_SDHI3       228         /* SDۥȥ󥿡ե SDHI3 */
#define INT_SDHI0       229         /* SDۥȥ󥿡ե SDHI0 */
#define INT_SDHI1       230         /* SDۥȥ󥿡ե SDHI1 */
#define INT_ARM         231         /* RTC 顼 */
#define INT_PRD         232         /* RTC  */
#define INT_CUP         233         /* RTC 夲 */
#define INT_ERS0        234         /* RCANͥ0 ERSװ */
#define INT_OVR0        235         /* RCANͥ0 OVRװ */
#define INT_RM00        236         /* RCANͥ0 ǡե졼 */
#define INT_RM10        237         /* RCANͥ0 ⡼ȥե졼 */
#define INT_SLE0        238         /* RCANͥ0 å */
#define INT_ERS1        239         /* RCANͥ1 ERSװ */
#define INT_OVR1        240         /* RCANͥ1 OVRװ */
#define INT_RM01        241         /* RCANͥ1 ǡե졼 */
#define INT_RM11        242         /* RCANͥ1 ⡼ȥե졼 */
#define INT_SLE1        243         /* RCANͥ1 å */
#define INT_OVF         244         /* SRC ϥǡFIFOС饤 */
#define INT_ODFI        245         /* SRC ϥǡFIFOե */
#define INT_IDEI        246         /* SRC ϥǡFIFOץƥ */
#define INT_IEBI        247         /* IEBusȥ  */

#ifndef _MACRO_ONLY

/*
 *  ¢⥸塼Υ쥸
 */
/* å */
#define CCR1        ((VW *)0xFFFC1000)  /* å쥸1 */
#define CCR2        ((VW *)0xFFFC1004)  /* å쥸2 */

/* åȯ (CPG) */
#define FRQCR       ((VH *)0xFFFE0010)  /* ȿ쥸 */

/* Хơȥȥ (BSC) */
#define CMNCR       ((VW *)0xFFFC0000)  /* ̥ȥ쥸 */
#define CS0BCR      ((VW *)0xFFFC0004)  /* ꥢ0 Хȥ쥸 */
#define CS1BCR      ((VW *)0xFFFC0008)  /* ꥢ1 Хȥ쥸 */
#define CS2BCR      ((VW *)0xFFFC000C)  /* ꥢ2 Хȥ쥸 */
#define CS3BCR      ((VW *)0xFFFC0010)  /* ꥢ3 Хȥ쥸 */
#define CS4BCR      ((VW *)0xFFFC0014)  /* ꥢ4 Хȥ쥸 */
#define CS5BCR      ((VW *)0xFFFC0018)  /* ꥢ5 Хȥ쥸 */
#define CS6BCR      ((VW *)0xFFFC001C)  /* ꥢ6 Хȥ쥸 */
#define CS7BCR      ((VW *)0xFFFC0020)  /* ꥢ7 Хȥ쥸 */
#define CS0WCR      ((VW *)0xFFFC0028)  /* ꥢ0 ȥȥ쥸 */
#define CS1WCR      ((VW *)0xFFFC002C)  /* ꥢ1 ȥȥ쥸 */
#define CS2WCR      ((VW *)0xFFFC0030)  /* ꥢ2 ȥȥ쥸 */
#define CS3WCR      ((VW *)0xFFFC0034)  /* ꥢ3 ȥȥ쥸 */
#define CS4WCR      ((VW *)0xFFFC0038)  /* ꥢ4 ȥȥ쥸 */
#define CS5WCR      ((VW *)0xFFFC003C)  /* ꥢ5 ȥȥ쥸 */
#define CS6WCR      ((VW *)0xFFFC0040)  /* ꥢ6 ȥȥ쥸 */
#define CS7WCR      ((VW *)0xFFFC0044)  /* ꥢ7 ȥȥ쥸 */
#define SDCR        ((VW *)0xFFFC004C)  /* SDRAMȥ쥸 */
#define RTCSR       ((VW *)0xFFFC0050)  /* եå奿ޥȥ/ơ쥸 */
#define RTCNT       ((VW *)0xFFFC0054)  /* եå奿ޥ */
#define RTCOR       ((VW *)0xFFFC0058)  /* եå奿ॳ󥹥ȥ쥸 */

/* ߥȥ (INTC) */
#define ICR0        ((VH *)0xFFFE0800)  /* ߥȥ쥸0 */
#define ICR1        ((VH *)0xFFFE0802)  /* ߥȥ쥸1 */
#define ICR2        ((VH *)0xFFFE0804)  /* ߥȥ쥸2 */
#define IRQRR       ((VH *)0xFFFE0806)  /* IRQ ׵쥸 */
#define PINTER      ((VH *)0xFFFE0808)  /* PINT ߥ֥͡쥸 */
#define PIRR        ((VH *)0xFFFE080A)  /* PINT ׵쥸 */
#define IBCR        ((VH *)0xFFFE080C)  /* Х󥯥ȥ쥸 */
#define IBNR        ((VH *)0xFFFE080E)  /* Хֹ쥸 */
#define IPR01       ((VH *)0xFFFE0818)  /* ͥ٥쥸01 */
#define IPR02       ((VH *)0xFFFE081A)  /* ͥ٥쥸02 */
#define IPR05       ((VH *)0xFFFE0820)  /* ͥ٥쥸05 */
#define IPR06       ((VH *)0xFFFE0C00)  /* ͥ٥쥸06 */
#define IPR07       ((VH *)0xFFFE0C02)  /* ͥ٥쥸07 */
#define IPR08       ((VH *)0xFFFE0C04)  /* ͥ٥쥸08 */
#define IPR09       ((VH *)0xFFFE0C06)  /* ͥ٥쥸09 */
#define IPR10       ((VH *)0xFFFE0C08)  /* ͥ٥쥸10 */
#define IPR11       ((VH *)0xFFFE0C0A)  /* ͥ٥쥸11 */
#define IPR12       ((VH *)0xFFFE0C0C)  /* ͥ٥쥸12 */
#define IPR13       ((VH *)0xFFFE0C0E)  /* ͥ٥쥸13 */
#define IPR14       ((VH *)0xFFFE0C10)  /* ͥ٥쥸14 */
#define IPR16       ((VH *)0xFFFE0C12)  /* ͥ٥쥸15 */
#define IPR15       ((VH *)0xFFFE0C14)  /* ͥ٥쥸16 */
#define IPR17       ((VH *)0xFFFE0C16)  /* ͥ٥쥸17 */

/* ڥޥå (CMT) */
#define CMSTR       ((VH *)0xFFFEC000)  /* ڥޥåޥȥ쥸 */
#define CMCSR_0     ((VH *)0xFFFEC002)  /* ͥ0 ڥޥå󥿥ȥ/ơ쥸 */
#define CMCNT_0     ((VH *)0xFFFEC004)  /* ͥ0 ڥޥå */
#define CMCOR_0     ((VH *)0xFFFEC006)  /* ͥ0 ڥޥå󥹥ȥ쥸 */
#define CMCSR_1     ((VH *)0xFFFEC008)  /* ͥ1 ڥޥå󥿥ȥ/ơ쥸 */
#define CMCNT_1     ((VH *)0xFFFEC00A)  /* ͥ1 ڥޥå */
#define CMCOR_1     ((VH *)0xFFFEC00C)  /* ͥ1 ڥޥå󥹥ȥ쥸 */

/* ԥե󥯥󥳥ȥ (PFC), I/Oݡ */
#define PADRL       ((VH *)0xFFFE3802)  /* ݡA ǡ쥸L */
#define PBCRL       ((VH *)0xFFFE3882)  /* ݡB ǡ쥸L */
#define PBIORL      ((VH *)0xFFFE3886)  /* ݡB IO쥸L */
#define PBCRL4      ((VH *)0xFFFE3890)  /* ݡB ȥ쥸L4 */
#define PBCRL3      ((VH *)0xFFFE3892)  /* ݡB ȥ쥸L3 */
#define PBCRL2      ((VH *)0xFFFE3894)  /* ݡB ȥ쥸L2 */
#define PBCRL1      ((VH *)0xFFFE3896)  /* ݡB ȥ쥸L1 */
#define PBPRL       ((VH *)0xFFFE389E)  /* ݡB ݡȥ쥸L */
#define IFCR        ((VH *)0xFFFE38A2)  /* IRQOUTǽȥ쥸 */
#define PCCRL       ((VH *)0xFFFE3902)  /* ݡC ǡ쥸L */
#define PCIORL      ((VH *)0xFFFE3906)  /* ݡC IO쥸L */
#define PCCRL4      ((VH *)0xFFFE3910)  /* ݡC ȥ쥸L4 */
#define PCCRL3      ((VH *)0xFFFE3912)  /* ݡC ȥ쥸L3 */
#define PCCRL2      ((VH *)0xFFFE3914)  /* ݡC ȥ쥸L2 */
#define PCCRL1      ((VH *)0xFFFE3916)  /* ݡC ȥ쥸L1 */
#define PCPRL       ((VH *)0xFFFE391E)  /* ݡC ݡȥ쥸L */
#define PDCRL       ((VH *)0xFFFE3982)  /* ݡD ǡ쥸L */
#define PDIORL      ((VH *)0xFFFE3986)  /* ݡD IO쥸L */
#define PDCRL4      ((VH *)0xFFFE3990)  /* ݡD ȥ쥸L4 */
#define PDCRL3      ((VH *)0xFFFE3992)  /* ݡD ȥ쥸L3 */
#define PDCRL2      ((VH *)0xFFFE3994)  /* ݡD ȥ쥸L2 */
#define PDCRL1      ((VH *)0xFFFE3996)  /* ݡD ȥ쥸L1 */
#define PDPRL       ((VH *)0xFFFE399E)  /* ݡD ݡȥ쥸L */
#define PECRL       ((VH *)0xFFFE3A02)  /* ݡE ǡ쥸L */
#define PEIORL      ((VH *)0xFFFE3A06)  /* ݡE IO쥸L */
#define PECRL4      ((VH *)0xFFFE3A10)  /* ݡE ȥ쥸L4 */
#define PECRL3      ((VH *)0xFFFE3A12)  /* ݡE ȥ쥸L3 */
#define PECRL2      ((VH *)0xFFFE3A14)  /* ݡE ȥ쥸L2 */
#define PECRL1      ((VH *)0xFFFE3A16)  /* ݡE ȥ쥸L1 */
#define PEPRL       ((VH *)0xFFFE3A1E)  /* ݡE ݡȥ쥸L */
#define PFCRH       ((VH *)0xFFFE3A80)  /* ݡE ǡ쥸H */
#define PFCRL       ((VH *)0xFFFE3A82)  /* ݡE ǡ쥸L */
#define PFIORH      ((VH *)0xFFFE3A84)  /* ݡF IO쥸H */
#define PFIORL      ((VH *)0xFFFE3A86)  /* ݡF IO쥸L */
#define PFCRH4      ((VH *)0xFFFE3A88)  /* ݡF ȥ쥸H4 */
#define PFCRH3      ((VH *)0xFFFE3A8A)  /* ݡF ȥ쥸H3 */
#define PFCRH2      ((VH *)0xFFFE3A8C)  /* ݡF ȥ쥸H2 */
#define PFCRH1      ((VH *)0xFFFE3A8E)  /* ݡF ȥ쥸H1 */
#define PFCRL4      ((VH *)0xFFFE3A90)  /* ݡF ȥ쥸L4 */
#define PFCRL3      ((VH *)0xFFFE3A92)  /* ݡF ȥ쥸L3 */
#define PFCRL2      ((VH *)0xFFFE3A94)  /* ݡF ȥ쥸L2 */
#define PFCRL1      ((VH *)0xFFFE3A96)  /* ݡF ȥ쥸L1 */
#define PFPRH       ((VH *)0xFFFE3A9C)  /* ݡE ݡȥ쥸H */
#define PFPRL       ((VH *)0xFFFE3A9E)  /* ݡE ݡȥ쥸L */
#define SCSR        ((VH *)0xFFFE3AA2)  /* SSIå쥸 */

/* ϥ⡼ */
#define STBCR       ((VB *)0xFFFE0014)  /* Хȥ쥸 */
#define STBCR2      ((VB *)0xFFFE0018)  /* Хȥ쥸2 */
#define STBCR3      ((VB *)0xFFFE0408)  /* Хȥ쥸3 */
#define STBCR4      ((VB *)0xFFFE040C)  /* Хȥ쥸4 */
#define STBCR5      ((VB *)0xFFFE0410)  /* Хȥ쥸5 */
#define STBCR6      ((VB *)0xFFFE0414)  /* Хȥ쥸6 */
#define SYSCR1      ((VB *)0xFFFE0402)  /* ƥॳȥ쥸1 */
#define SYSCR2      ((VB *)0xFFFE0404)  /* ƥॳȥ쥸2 */
#define SYSCR3      ((VB *)0xFFFE0418)  /* ƥॳȥ쥸3 */
#define DSCTR       ((VB *)0xFFFE2800)  /* ǥץХȥ쥸 */
#define DSCTR2      ((VB *)0xFFFE2802)  /* ǥץХȥ쥸2 */
#define DSSSR       ((VH *)0xFFFE2804)  /* ǥץХװ쥯ȥ쥸 */
#define DSFR        ((VH *)0xFFFE2808)  /* ǥץХå쥯ȥ쥸 */
#define DSRTR       ((VB *)0xFFFE280C)  /* ݻ¢RAMȥߥ󥰥쥸 */

/* FIFOդꥢ륳ߥ˥󥤥󥿡ե (SCIF) */

#define SCIF0_BASE  ((UW)0xFFFE8000)    /* ͥ0 쥸١ɥ쥹 */
#define SCIF1_BASE  ((UW)0xFFFE8800)    /* ͥ1 쥸١ɥ쥹 */
#define SCIF2_BASE  ((UW)0xFFFE9000)    /* ͥ2 쥸١ɥ쥹 */
#define SCIF3_BASE  ((UW)0xFFFE9800)    /* ͥ3 쥸١ɥ쥹 */

/*
 * ߥȥν
 */
Inline void sh2_init_intcontorller(void)
{
	/* Хֹ쥸 */
	sil_wrh_mem(IBNR, 0x0000);		/* BE=00, BOVE=0                         */
									/*  ٤ƤγߤǥХ󥯻Ѷػ     */
									/*  쥸Х󥯥Сե㳰ػ */
	/* ͥ٥쥸 */
	sil_wrh_mem (IPR01, 0x0000);
	sil_wrh_mem (IPR02, 0x0000);
	sil_wrh_mem (IPR05, 0x0000);
	sil_wrh_mem (IPR06, 0x0000);
	sil_wrh_mem (IPR07, 0x0000);
	sil_wrh_mem (IPR08, 0x0000);
	sil_wrh_mem (IPR09, 0x0000);
	sil_wrh_mem (IPR10, 0x0000);
	sil_wrh_mem (IPR11, 0x0000);
	sil_wrh_mem (IPR12, 0x0000);
	sil_wrh_mem (IPR13, 0x0000);
	sil_wrh_mem (IPR14, 0x0000);
	sil_wrh_mem (IPR15, 0x0000);
	sil_wrh_mem (IPR16, 0x0000);
	sil_wrh_mem (IPR17, 0x0000);
}

#endif /* _MACRO_ONLY */

#endif /* _SH7263_H_ */
