/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *                     2003 by Advanced Data Controls, Corp
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_config.c,v 1.3 2003/12/19 11:24:55 honda Exp $
 */

/*
 * åȥƥ¸⥸塼Solution Engineѡ
 */

#include "jsp_kernel.h"
#include <sil.h>
#include <solution_engine.h>
#include <fdc37c935a.h>

/*
 *  åȥƥ¸ 롼
 */
void
sys_initialize()
{
#if defined(MS7709ASE01) || defined(MS7729RSE01)    
    /* Enable IRL Interrupt */
    sil_wrh_mem((VP)ICR1, 0x5000);
#else /* MS7750SE01 */
    sil_wrh_mem((VP)ICR, 0x0000);
#endif /* defined(MS7709ASE01) | defined(MS7729RSE01) */   
    /*
     * Init Super I/O
     */
    smsc_init();

    /*
     * Init SIO
     */
    fdc37c935a_init();
}


/*
 *  åȥƥνλ롼
 *
 *  ƥλ˻Ȥ̾ϥ˥ƤӽФǼ¸롥
 *  
 */
void
sys_exit(void)
{
  kernel_abort();
}

/*
 *   ƥʸλ
 */

#ifdef  MULTI_IO
#include <stdio.h>
#define SYS_PUT_CHAR(c) putchar(c)
#else
#define SYS_PUT_CHAR(c) fdc37c935a_pol_putc(c)
#endif 

void
sys_putc(char c)
{
    if (c == '\n') {
        SYS_PUT_CHAR('\r');
    }
    SYS_PUT_CHAR(c);
}



