/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_timer.h,v 1.8 2003/06/20 11:44:42 honda Exp $
 */

/*
 *  CPU¸ޥ⥸塼SH3/4ѡ
 *  TMU0
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>

/*
 *  ޳ߥϥɥINTEVTֹ
 */
#define	INHNO_TIMER	TMU0_INTEVT

#ifndef _MACRO_ONLY

/*
 *  ͤɽη
 */
typedef UW	CLOCK;

#define TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define TO_USEC(clock)      ((clock) * 1000 / TIMER_CLOCK)

/*
 *  ǤΥ޼ñ̤ɽ
 */
#define MAX_CLOCK	((CLOCK) 0xffffffff)

/*
 *  ޤθͤȯͤȤߤʤȽ
 */
#define GET_TOLERANCE	100
#define BEFORE_IREQ(clock) \
        ((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
hw_timer_initialize()
{
	CLOCK	cyc = TO_CLOCK(TIC_NUME, TIC_DENO);
        
	/*
	 *  ޴Ϣ
	 */
    sil_wrb_mem((VP)TMU_TSTR,
                (sil_reb_mem((VP)TMU_TSTR) & ~TMU_STR0));  /*  */
    assert(cyc <= MAX_CLOCK);		     /* ޾ͤΥå */

    /* ʬꡢߵ */
    sil_wrh_mem((VP)TMU_TCR0,(0x020 | TCR0_TPSC));
    
    sil_wrw_mem((VP)TMU_TCOR0, cyc); /* timer constant쥸򥻥å */
    sil_wrw_mem((VP)TMU_TCNT0, cyc); /* 󥿡򥻥å */
    /* 0 */
    sil_wrb_mem((VP)TMU_TSTR,
                (sil_reb_mem((VP)TMU_TSTR) | TMU_STR0));

    
    /*
	 *  ߴϢ
	 */
    define_int_plevel(TMU0_INTEVT,KTIM_INT_LV); /* ߥ٥(SF) */
    /* ߥ٥(HW) */
    sil_wrh_mem((VP)IPRA,
                ((sil_reh_mem((VP)IPRA) & 0x0fff) | (KTIM_INT_LV<<12)));
    /* ׵򥯥ꥢ */
    sil_wrh_mem((VP)TMU_TCR0,
                (sil_reh_mem((VP)TMU_TCR0) & ~TCR_UNF));
}


/*
 *  ޳׵Υꥢ
 */
Inline void
hw_timer_int_clear()
{
    /* ׵򥯥ꥢ */
    sil_wrh_mem((VP)TMU_TCR0,
                (sil_reh_mem((VP)TMU_TCR0) & ~TCR_UNF));    
}

/*
 *  ޤ߽
 */
Inline void
hw_timer_terminate()
{
    /* ޤ */
    sil_wrb_mem((VP)TMU_TSTR,
                (sil_reb_mem((VP)TMU_TSTR) & ~TMU_STR0));
    /* ׵򥯥ꥢ */
    sil_wrh_mem((VP)TMU_TCR0,0);
}

/*
 *  ޤθͤɤߤ
 *
 *  ߶ػ߶ǸƤӽФȡ
 */
Inline CLOCK
hw_timer_get_current(void)
{
	return(TO_CLOCK(TIC_NUME, TIC_DENO) - sil_rew_mem((VP)TMU_TCNT0));
}

Inline BOOL
hw_timer_fetch_interrupt(void)
{
	return(sil_reh_mem((VP)TMU_TCR0) & TCR_UNF);
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */



