;
;   TOPPERS/JSP Kernel
;       Toyohashi Open Platform for Embedded Real-Time Systems/
;       Just Standard Profile Kernel
;
;   Copyright (C) 2006-2010 by Witz Corporation, JAPAN
;  
;   The above copyright holders grant permission gratis to use,
;   duplicate, modify, or redistribute (hereafter called use) this
;   software (including the one made by modifying this software),
;   provided that the following four conditions (1) through (4) are
;   satisfied.
;  
;   (1) When this software is used in the form of source code, the above
;       copyright notice, this use conditions, and the disclaimer shown
;       below must be retained in the source code without modification.
;  
;   (2) When this software is redistributed in the forms usable for the
;       development of other software, such as in library form, the above
;       copyright notice, this use conditions, and the disclaimer shown
;       below must be shown without modification in the document provided
;       with the redistributed software, such as the user manual.
;  
;   (3) When this software is redistributed in the forms unusable for the
;       development of other software, such as the case when the software
;       is embedded in a piece of equipment, either of the following two
;       conditions must be satisfied:
;  
;     (a) The above copyright notice, this use conditions, and the
;            disclaimer shown below must be shown without modification in
;         the document provided with the redistributed software, such as
;         the user manual.
;  
;     (b) How the software is to be redistributed must be reported to the
;         TOPPERS Project according to the procedure described
;         separately.
;  
;   (4) The above copyright holders and the TOPPERS Project are exempt
;       from responsibility for any type of damage directly or indirectly
;       caused from the use of this software and are indemnified by any
;       users or end users of this software from any and all causes of
;       action whatsoever.
;  
;   THIS SOFTWARE IS PROVIDED "AS IS." THE ABOVE COPYRIGHT HOLDERS AND
;   THE TOPPERS PROJECT DISCLAIM ANY EXPRESS OR IMPLIED WARRANTIES,
;   INCLUDING, BUT NOT LIMITED TO, ITS APPLICABILITY TO A PARTICULAR
;   PURPOSE. IN NO EVENT SHALL THE ABOVE COPYRIGHT HOLDERS AND THE
;   TOPPERS PROJECT BE LIABLE FOR ANY TYPE OF DAMAGE DIRECTLY OR
;   INDIRECTLY CAUSED FROM THE USE OF THIS SOFTWARE.
;
;   嵭Ԥϡʲ (1)(4) ξ˸¤ꡤܥեȥ
;   ܥեȥѤΤޤࡥʲƱˤѡʣѡ
;   ۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
;   (1) ܥեȥ򥽡ɤηѤˤϡ嵭
;       ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
;       ˴ޤޤƤ뤳ȡ
;   (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
;       ǤǺۤˤϡۤȼɥȡѼԥ
;       ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ̵
;       ڵǺܤ뤳ȡ
;   (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
;       ǤʤǺۤˤϡΤ줫ξȡ
;     (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
;         ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
;     (b) ۤη֤̤ˡˤäơTOPPERSץȤ
;         𤹤뤳ȡ
;   (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
;       ⡤嵭ԤTOPPERSץȤդ뤳ȡޤ
;       ܥեȥΥ桼ޤϥɥ桼Τʤͳ˴
;       ᤫ⡤嵭ԤTOPPERSץȤդ뤳ȡ
;  
;   ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
;   TOPPERSץȤϡܥեȥ˴ؤơλŪФ
;   ŬޤơʤݾڤԤʤޤܥեȥ
;   ˤľŪޤϴŪʤ»˴ؤƤ⡤Ǥ
;   ʤ
;  
;   @(#) $Id: start.app,v 1.1 2006/04/10 08:19:25 honda Exp $
;

	$MAXIMUM
	module start_app

;
;	ͥѤΥȥåץ⥸塼TLCS-900ѡ
;
#include "jsp_rename.h"
#include "cpu_rename.h"
#include "sys_rename.h"
#include "tlcs900vec.inc"

; ȥܥ
	extern large	__StackTop
	extern large	__AreaRAM
	extern large	__AreaRAM_size
	extern large	__DataRAM
	extern large	__DataRAM_ini
	extern large	__DataRAM_size
	extern large	hardware_init_hook
	extern large	software_init_hook
	extern large	_kernel_start

f_code section code large align=1,1

	public _start
_start:
; ߶ػ
	di		; ꥻåȻIFF7ꤵ뤿DI֤Ȥʤ
			; ϡɥꥻåȻdi̿
			; եȤˤ jp _start ǽθɤĤ

; å
	ld		xsp, __StackTop

; INTNEST쥸
	ld		hl, 0
	ldc		intnest, hl

; hardware_init_hook ƽФ0 Ǥʤ
; åȥϡɥ˰¸ɬפʽ
; ϡhardware_init_hook ȤؿѰդ롥
	ld		xhl, hardware_init_hook
	cp		xhl, 0
	call	nz, hardware_init_hook

; ̵RAMΰΥꥢ
	ld		xde, __AreaRAM			; ƬϤȥ
	ld		xbc, __AreaRAM_size
	ld		ix, bc					; ǲbitݻ(ǻ)
	srl		1, xbc					; 2byteñ̤ǽ뤿᥵/2
	jr		z, area_clr_byte
	ld		xhl, xde				; Ƭݻ(ǻ)
	ldw		(xde+), 0				; Ƭϥꥢ
	sub		xbc, 1					; ǥ
	jr		z, area_clr_byte
	ldirw	(xde+), (xhl+)			; Ƭ(0)ͤϤ...
									; ΤBC쥸ʬ֥å
	cp		qbc, 0
	jr		eq, area_clr_byte			; 16bit0ʤ齪λ
	ld		wa, qbc
area_clr_loop:						; 16bit(0x10000ñ)Ǥν
	ldirw	(xde+), (xhl+)			; 0x10000ʬ֥å
	djnz	wa, area_clr_loop
area_clr_byte:
	bit		0, ix					; ΰ襵ʤ1byteꥢ
	jr		z, area_clr_end
	ldb		(xde), 0
area_clr_end:

; ͭRAMΰؤΥǡ
	ld		xde, __DataRAM			; ɸϤȥ
	ld		xhl, __DataRAM_ini
	ld		xbc, __DataRAM_size
	or		xbc, xbc				; 0ʤ齪λ
	jr		z, data_ld_end
	ldirb	(xde+), (xhl+)			; BC쥸ʬ֥å
	cp		qbc, 0
	jr		eq, data_ld_end			; 16bit0ʤ齪λ
	ld		wa, qbc
data_ld_loop:						; 16bit(0x10000ñ)Ǥν
	ldirb	(xde+), (xhl+)			; 0x10000ʬ֥å
	djnz	wa, data_ld_loop
data_ld_end:

; software_init_hook ƽФ0 Ǥʤ
; եȥĶä˥饤֥ˤ˰¸ɬפʽ
; ϡsoftware_init_hook ȤؿѰդ롥
	ld		xhl, software_init_hook
	cp		xhl, 0
	call	nz, software_init_hook

; ͥ뵯ư
	jp		_kernel_start

; EXIT롼
exit:
	jr		exit

	end
