/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: itron.h,v 1.16 2004/12/22 03:38:00 hiro Exp $
 */

/*
 *	ITRONͶ̵Υǡޥ
 *
 *  Υեˤϡɥץեˤɬפʤޤ
 *  롥ǡϡɥץե礦ɤ
 *  ĹˤϤƤʤ
 *
 *  ֥Υե䥷ƥॳե졼ե
 *  뤫餳Υե򥤥󥯥롼ɤϡ_MACRO_ONLY 
 *  ȤǡޥʳεҤȤǤ롥
 *
 *  Υ󥯥롼ɥեϡkernel.h  sil.h ǥ󥯥롼ɤ롥
 *  ޤITRONͶ̵˽򤹤륽եȥʤΥ󥯥롼ɥե
 *  ϡΥեľܥ󥯥롼ɤƤ褤㳰ơ
 *  ¾Υե뤫ľܥ󥯥롼ɤ뤳ȤϤʤ
 *
 *  Υե򥤥󥯥롼ɤˡt_stddef.h 򥤥󥯥롼ɤ
 *  ȤɬפǤ롥
 */

#ifndef _ITRON_H_
#define _ITRON_H_

#ifdef __cplusplus
extern "C" {
#endif

/*
 *  ȯĶ˰¸
 */
#include <tool_defs.h>

/*
 *  ȯĶɸ।󥯥롼ɥեNULL  size_t ɬס
 *
 *  C++/EC++ Ǥϡɸ; stddef.h ݡȤƤȤϸ¤
 *  ۤȤɤνϤǥݡȤƤ롥
 */
#ifndef _MACRO_ONLY
#include <stddef.h>
#endif /* _MACRO_ONLY */

/*
 *  ѥ¸ΥǡΥǥե
 */
#ifndef _bool_
#define	_bool_		int		/* ֡뷿 */
#endif /* _bool_ */

/*
 *  ITRONͶ̥ǡ
 */
#ifndef _MACRO_ONLY

#ifdef _int8_
typedef	signed _int8_		B;	/* դ8ӥå */
typedef	unsigned _int8_		UB;	/* ̵8ӥå */
typedef	_int8_			VB;	/* ޤʤ8ӥåȤ */
#endif /* _int8_ */

#ifdef _int16_
typedef	signed _int16_		H;	/* դ16ӥå */
typedef	unsigned _int16_ 	UH;	/* ̵16ӥå */
typedef	_int16_			VH;	/* ޤʤ16ӥåȤ */
#endif /* _int16_ */

typedef	signed _int32_		W;	/* դ32ӥå */
typedef	unsigned _int32_	UW;	/* ̵32ӥå */
typedef	_int32_			VW;	/* ޤʤ32ӥåȤ */

#ifdef _int64_
typedef	signed _int64_		D;	/* դ64ӥå */
typedef	unsigned _int64_	UD;	/* ̵64ӥå */
typedef	_int64_			VD;	/* ޤʤ64ӥåȤ */
#endif /* _int64_ */

typedef	void		*VP;		/* ޤʤΤؤΥݥ */
typedef	void		(*FP)();	/* ץεưϡʥݥ󥿡 */

typedef signed int	INT;		/* ʥդ */
typedef unsigned int	UINT;		/* ʥ̵ */

typedef _bool_		BOOL;		/*  */

typedef INT		FN;		/* ǽ */
typedef	INT		ER;		/* 顼 */
typedef	INT		ID;		/* ֥ȤIDֹ */
typedef	UINT		ATR;		/* ֥Ȥ° */
typedef	UINT		STAT;		/* ֥Ȥξ */
typedef	UINT		MODE;		/* ӥư⡼ */
typedef	INT		PRI;		/* ͥ */
typedef	size_t		SIZE;		/* ΰΥ */

typedef	INT		TMO;		/* ॢȻ */
typedef	UINT		RELTIM;		/* л */
typedef	UW		SYSTIM;		/* ƥ */

#ifdef _vp_int_
typedef	_vp_int_	VP_INT;		/* VP ޤ INT */
#else /* _vp_int_ */
typedef	VP		VP_INT;		/* VP ޤ INT */
#endif /* _vp_int_ */

typedef	INT		ER_BOOL;	/* ER ޤ BOOL */
typedef	INT		ER_ID;		/* ER ޤ ID */
typedef	INT		ER_UINT;	/* ER ޤ UINT */

#endif /* _MACRO_ONLY */

/*
 *  ITRONͶ
 */

/*
 *  
 *
 *  _MACRO_ONLY λˤϡNULL ʤϡ_MACRO_ONLY λ
 *  stddef.h 򥤥󥯥롼ɤʤᡤǤʤ NULL 
 *  㤦ǽ뤿Ǥ롥ޤƥॳե졼
 *  եˤ NULL ƤϤʤʤᡤ
 *  ʤԹ礬褤
 */
#ifndef _MACRO_ONLY
#ifndef NULL				/* stddef.h ˴ޤޤƤϤ */
#define	NULL		0		/* ̵ݥ */
#endif /* NULL */
#endif /* _MACRO_ONLY */

#define	TRUE		1		/*  */
#define	FALSE		0		/*  */
#define	E_OK		0		/* ｪλ */

/*
 *  顼
 */
#define	E_SYS		(-5)		/* ƥ२顼 */
#define	E_NOSPT		(-9)		/* ̤ݡȵǽ */
#define	E_RSFN		(-10)		/* ͽǽ */
#define	E_RSATR		(-11)		/* ͽ° */
#define	E_PAR		(-17)		/* ѥ᡼顼 */
#define	E_ID		(-18)		/* IDֹ */
#define	E_CTX		(-25)		/* ƥȥ顼 */
#define	E_MACV		(-26)		/* ꥢȿ */
#define	E_OACV		(-27)		/* ֥ȥȿ */
#define	E_ILUSE		(-28)		/* ӥ */
#define	E_NOMEM		(-33)		/* ­ */
#define	E_NOID		(-34)		/* IDֹ­ */
#define	E_OBJ		(-41)		/* ֥Ⱦ֥顼 */
#define	E_NOEXS		(-42)		/* ֥̤ */
#define	E_QOVR		(-43)		/* 塼󥰥Сե */
#define	E_RLWAI		(-49)		/* Ԥ֤ζ */
#define	E_TMOUT		(-50)		/* ݡ󥰼Ԥޤϥॢ */
#define	E_DLT		(-51)		/* Ԥ֥Ȥκ */
#define	E_CLS		(-52)		/* Ԥ֥ȤξѲ */
#define	E_WBLK		(-57)		/* Υ֥å󥰼դ */
#define	E_BOVR		(-58)		/* ХåեСե */

/*
 *  ֥°
 */
#define	TA_NULL		0u		/* ֥°ꤷʤ */

/*
 *  ॢȻ
 */
#define TMO_POL		0		/* ݡ */
#define TMO_FEVR	(-1)		/* ʵԤ */
#define TMO_NBLK	(-2)		/* Υ֥å */

/*
 *  ITRONͶ̥ޥ
 */

/*
 *  顼ʬޥ
 *
 *  ANSI CεʤǤϡեȱ黻ҡ>>ˤĥ뤳Ȥ
 *  ڤƤʤᡤSERCDޥñ ((ercd) >> 8) Ȥȡ
 *  եȱ黻ҤĥʤѥǤϡSERCD ͤ
 *  ˤʤäƤޤ
 */
#define	ERCD(mercd,sercd)	(((sercd) << 8) | ((mercd) & 0xff))

#ifdef _int8_
#define	MERCD(ercd)		((ER)((B)(ercd)))
#define	SERCD(ercd)		((ER)((B)((ercd) >> 8)))
#else /* _int8_ */
#define	MERCD(ercd)		(((ercd) & 0x80) == 0 ? ((ercd) & 0xff) \
							: ((ercd) | ~0xff))
#define	SERCD(ercd)		((~((~0) >> 8)) | ((ercd) >> 8))
#endif /* _int8_ */

#ifdef __cplusplus
}
#endif

#endif /* _ITRON_H_ */
