/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: device.cpp,v 1.6 2003/12/24 07:40:42 takayuki Exp $
 */

#include "stdafx.h"
#include "devicemanager.h"
#include "device.h"

/////////////////////////////////////////////////////////////////////////////
// CDevice


CDevice::CDevice()
{
	DevID = _Module.AddDevice(this);
}

CDevice::~CDevice()
{
	if(DevID != 0)
		_Module.DeleteDevice(this);
}

STDMETHODIMP CDevice::IsValid(BOOL * valid)
{
	*valid = DevID != 0 ? TRUE : FALSE;
	return S_OK;
}

STDMETHODIMP CDevice::SetDeviceName(BSTR devname)
{
	DeviceName = devname;
	return S_OK;
}

STDMETHODIMP CDevice::Map(unsigned long address, unsigned long size)
{
	if( DevID == 0 )
		return E_HANDLE;
	if(_Module.Map(this,Range(address,size)) == false)
		return E_INVALIDARG;
	return S_OK;
}

STDMETHODIMP CDevice::Unmap(unsigned long address)
{
	if( DevID == 0 )
		return E_HANDLE;
	if(_Module.Unmap(this, address) == false)
		return E_INVALIDARG;
	return S_OK;
}

STDMETHODIMP CDevice::RaiseInterrupt(unsigned long inhno)
{
	if(DevID == 0)
		return E_HANDLE;
	if(_Module.Kernel == 0)
		return E_ACCESSDENIED;
	if(_Module.RaiseInterrupt(inhno) == false)
		return E_INVALIDARG;
	return S_OK;
}
