/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003      by Advanced Data Controls, Corp
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *                2009 by Suikan
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 */

/*
 *    åȥƥ¸⥸塼CQ-FRK-NXP-ARM
 */

#include "jsp_kernel.h"
#include <lpc2388.h>

/*
 *  ѤΥơ֥
 */
#define VICVectAddress ((volatile FP **)0xFFFFF100)




/*
 *  ߴϢν(LPC2388)
 */
void
init_IRQ()
{
	int i;

	for( i=0; i<32; i++ )
		VICVectAddress[i] = (volatile FP *)undef_interrupt;
}

extern unsigned int __data_start;

/*
 * LPC2388SRAMΰFLASHΥ٥ȥ򥳥ԡ
 * ޥåפ롣LPC2388̤ɬס
 */
void
init_vector()
{
	unsigned char *flash, *sram;
	int i;

		/* ROMɤSRAMưɤǤϡ㳰٥ȥΰ㤦
		 * ROMϡSRAM REMAPFlash ROM㳰٥ȥͤ
		 * SRAMΥޥåΰ˰ܤʤФʤʤSRAMư
		 * ϡޥåΰؤϥǥХåͤ񤭹ࡣ
		 * Τᡢޥåΰν礬ɬפݤȽ̤ԤȽ̤
		 * __data_startͤȤͤlpc2388_sram.ld0˽
		 * 롣lpc2388.ldǤ󥼥Υɥ쥹롣äơ
		 * ޥåΰν__data_start󥼥ΤȤԤ */
	if ( __data_start != 0 )
	{
		flash =(unsigned char*) 0;				/* FLASHƬɥ쥹 */
		sram = (unsigned char*) 0x40000000;	/* SRAMƬɥ쥹 */

			/* FLASHƬ64ХȤSRAM˥ԡ */
		for (i=0; i<64; i++)
		{
			*sram = *flash;
			sram++;
			flash++;
		}
	}
		/* SRAM ٥ȥ륨ꥢ˥ޥåפ */
	MEMMAP = 0x02;
}

/*
 * LPC2388¸UART롼sys_putc()Ѥuart0롣
 */
#define	DLAB 0x80
void
init_uart0()
{
    /*
     *  ʬ
     */
    /* Divisor Enable */
	U0LCR |= DLAB;
    U0DLL = UART0_DIVISOR & 0xFF ;
    U0DLM = UART0_DIVISOR >> 8;
    /* Divisor Disable */
    U0LCR &= ~DLAB;

    /* ⡼, ѥƥ̵ 8bit data, 1 stop bit */
    U0LCR = 0x03;

    /* ߶ػ */
    U0IER = 0;
}

/*
 *  ƥཪλեåե०˥ƥཪλAPIʤ
 *  Ƥ֤Ȥ褤
 */
void
sys_exit()
{
	while(1)
		;
}



/*
 *  åȥƥʸϡsyslogư˥ץȤԤ
 *  롼ǤꡢǤϥݡ󥰤ԤäƤ롣LF椬Ƥ顢
 *  CR LFѴƥץȤ롣sys_putcϥǥХʤ
 *  kernel_start()ǽäƤȲꤷƤ롣
 */

void
sys_putc(char c)
{
	if ( c== 0x0A )			/* ⤷ LF ʤ */
		sys_putc( 0x0D );	/* CRʸ */

	while( !( U0LSR & (1<<5)) )
		;		/* UART0 LSRTHRE1ˤʤޤԤġ1ʤ쥸*/

	U0THR = c;	/* ʸ */
}


/*
 *  ߥϥɥ
 *
 *  ֹ inhno γߥϥɥεưϤ inthdr ꤹ롥
 *  VICVectAddress[]Ʊ̾Υ쥸˥ޥåפƤ롣äơ
 *  define_inhƤ֤ȡVICVectAddressX쥸롣
 */
void
define_inh(INHNO inhno, FP inthdr)
{
    assert(inhno <= MAX_INT_NUM);
    VICVectAddress[inhno] = (volatile FP*)inthdr;

}

/*
 *  ̤γߤäν
 */
void
undef_interrupt(){
    syslog(LOG_EMERG, "Unregistered Interrupt occurs.");
    while(1);
}


/*
 * ߤΥ֥͡롢ǥ֥
 */
/*
 * intnoǤ蘆ߤǥ֥ˤʤ롣
 */
ER dis_int(INTNO intno)
{
	if ( intno > MAX_INT_NUM )
		return E_PAR;
	VICIntEnClr = 1<<intno;
	return 0;
}

/*
 * intnoǤ蘆ߤ֥͡ˤʤ롣
 */
ER ena_int(INTNO intno)
{
	if ( intno > MAX_INT_NUM )
		return E_PAR;
	VICIntEnable = 1<<intno;
	return 0;
}

/*
 * ߥ֥͡ޥꤹ롣ޥVICIntEnable
 */
ER chg_ims(unsigned int enableMask)
{
	VICIntEnClr = 0xFFFFFFFF;
	VICIntEnable = enableMask;
	return 0;
}

/*
 * ߥ֥͡ޥ
 */
ER get_ims(unsigned int *p_enableMask)
{
	*p_enableMask = VICIntEnable;
	return 0;
}


