/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2006 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2006 by Logic Research Co., Ltd.
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 */

/*
 * FRK_ADuC ǽѥɥ饤
 */

#include <s_services.h>
#include "frk_aduc.h"


/*
 * ꥢI/OݡȽ֥å
 */
const SIOPINIB siopinib_table[TNUM_SIOP] = {
	{(VP)COMRX, (VP)COMDIV0, (VP)COMDIV1,
	 (VP)COMIEN0, (VP)COMIID0, (VP)COMCON0,
	 (VP)COMSTA0, IRQ_UART}
};


/*
 *  ꥢI/Oݡȴ֥åΥꥢ
 */
SIOPCB  siopcb_table[TNUM_SIOP];



/*
 *  ꥢI/OݡID֥åФΥޥ
 */
#define INDEX_SIOP(siopid)  ((UINT)((siopid) - 1))
#define get_siopcb(siopid)  (&(siopcb_table[INDEX_SIOP(siopid)]))



/*
 * ʸ?
 */ 
Inline BOOL
uart_getready(SIOPCB *siopcb)
{
	return(((sil_rew_mem((VP)(siopcb->siopinib->line_status)) & COMSTA0_DR)!=0));
}


/*
 * ʸǤ뤫?
 */
Inline BOOL
uart_putready(SIOPCB *siopcb)
{
	return((sil_rew_mem((VP)(siopcb->siopinib->line_status)) & COMSTA0_TEMT)!=0);
}


/*
 *  ʸμФ
 */
Inline UB
uart_getchar(SIOPCB *siopcb)
{
	return(sil_rew_mem((VP)(siopcb->siopinib->uart_data)));
}


/*
 *  ʸν񤭹
 */
Inline void
uart_putchar(SIOPCB *siopcb, UB c)
{
    sil_wrw_mem((VP)(siopcb->siopinib->uart_data), c);
}


/*
 *  ߵ
 */
Inline void
uart_enable_send(SIOPCB *siopcb)
{
    sil_wrw_mem((VP)(siopcb->siopinib->int_enable),
            (sil_rew_mem((VP)(siopcb->siopinib->int_enable)) | COMIEN0_ETBEI));
}


/*
 *  ߶ػ
 */
Inline void
uart_disable_send(SIOPCB *siopcb)
{
    sil_wrw_mem((VP)(siopcb->siopinib->int_enable),
        (sil_rew_mem((VP)(siopcb->siopinib->int_enable)) & ~COMIEN0_ETBEI));
}


/*
 *  ߵ
 */
Inline void
uart_enable_rcv(SIOPCB *siopcb)
{
    sil_wrw_mem((VP)(siopcb->siopinib->int_enable),
        (sil_rew_mem((VP)(siopcb->siopinib->int_enable)) | COMIEN0_ERBFI));
}

/*
 *  ߶ػ
 */
Inline void
uart_disable_rcv(SIOPCB *siopcb)
{
    sil_wrw_mem((VP)(siopcb->siopinib->int_enable),
        (sil_rew_mem((VP)(siopcb->siopinib->int_enable)) & ~COMIEN0_ERBFI));
}



/*
 * ͥ뵯ưΥѤν
 */
void
init_uart(void){
    /* Disable Interrupt */
    sil_wrw_mem((VP)COMIEN0, 0);
    /* 9600bps */
    sil_wrw_mem((VP)COMCON0, COMCON0_DLAB);
    sil_wrw_mem((VP)COMDIV0, COMDIV0_BR9600); 
    sil_wrw_mem((VP)COMDIV1, COMDIV1_BR9600);
    /* 8Data, 1Stop, No Parity */
    sil_wrw_mem((VP)COMCON0, (COMCON0_STOP|COMCON0_WLS_8b));
    /* Enabel Receive Interrupt */
    sil_wrw_mem((VP)COMIEN0, (COMIEN0_ERBFI|COMIEN0_ETBEI));      
}


/*
 *  åפUARTΥݡ󥰽
 */
void
uart_putc(char c)
{
    int i;

    while((sil_rew_mem((VP)COMSTA0) & COMSTA0_TEMT)!=COMSTA0_TEMT);
  
    sil_wrw_mem((VP)COMTX, (VW)c);
}


/*
 *  SIOɥ饤Фν롼
 *  1ݡȤʤᡤޤ̣Ϥʤ
 */
void
uart_initialize()
{
    SIOPCB  *siopcb;
    UINT    i;

    /*
     *  ꥢI/Oݡȴ֥åν
     */
    for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
        siopcb->siopinib = &(siopinib_table[i]);
        siopcb->openflag = FALSE;
        siopcb->sendflag = FALSE;
    }
}


/*
 * ץ󤷤ƤݡȤ뤫
 */
BOOL
uart_openflag(void)
{
    return(siopcb_table[0].openflag);
}


/*
 * ꥢI/OݡȤΥץ
 */
SIOPCB *
uart_opn_por(ID siopid, VP_INT exinf)
{
    int i;
    
    SIOPCB      *siopcb;
    const SIOPINIB  *siopinib;

    siopcb = get_siopcb(siopid);
    siopinib = siopcb->siopinib;

    /* Disable Interrupt */
    sil_wrw_mem((VP)siopinib->int_enable, 0);
    /* 9600bps */
    sil_wrw_mem((VP)siopinib->line_control, COMCON0_DLAB);
    sil_wrw_mem((VP)siopinib->divisor_lo, COMDIV0_BR9600); 
    sil_wrw_mem((VP)siopinib->divisor_hi, COMDIV1_BR9600);
    
    /* 8Data, 1Stop, No Parity */
    sil_wrw_mem((VP)siopinib->line_control, (COMCON0_STOP|COMCON0_WLS_8b));

    /*
     * ߴϢ
     */
    sil_wrw_mem((VP)siopinib->int_enable, (COMIEN0_ERBFI|COMIEN0_ETBEI));	/* Enable Interrupt */
    sil_wrw_mem((VP)IRQEN, siopinib->irq_bit);	/*Enable interrupt register*/
    
    siopcb->exinf = exinf;
    siopcb->getready = siopcb->putready = FALSE;
    siopcb->openflag = TRUE;

    return(siopcb);    
}


/*
 *  ꥢI/OݡȤΥ
 */
void
uart_cls_por(SIOPCB *siopcb)
{
    sil_wrw_mem((VP)(siopcb->siopinib->line_control),
        (sil_rew_mem((VP)(siopcb->siopinib->line_control))|COMCON0_BRK)); /* Disable Interrupt */
    
    siopcb->openflag = FALSE;
}


/*
 *  ꥢI/OݡȤؤʸ
 */
BOOL
uart_snd_chr(SIOPCB *siopcb, char c)
{
    if (uart_putready(siopcb)){
        uart_putchar(siopcb, c);
        return(TRUE);
    }
    return(FALSE);
}


/*
 *  ꥢI/OݡȤʸ
 */
INT
uart_rcv_chr(SIOPCB *siopcb)
{
    if (uart_getready(siopcb)) {
        return((INT)(UB) uart_getchar(siopcb));
    }
    return(-1);
}

/*
 *  ꥢI/OݡȤΥХåε
 */
void
uart_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
    switch (cbrtn) {
        case SIO_ERDY_SND:
            uart_enable_send(siopcb);
            break;
        case SIO_ERDY_RCV:
            uart_enable_rcv(siopcb);
            break;
    }
}


/*
 *  ꥢI/OݡȤΥХåζػ
 */
void
uart_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
    switch (cbrtn) {
        case SIO_ERDY_SND:
            uart_disable_send(siopcb);
            break;
        case SIO_ERDY_RCV:
            uart_disable_rcv(siopcb);
            break;
    }
}


/*
 *  ꥢI/OݡȤФ߽
 */
static void
uart_isr_siop(SIOPCB *siopcb)
{
	volatile UW	iid;

    if (uart_getready(siopcb)) {
        /*
         *  ΥХå롼ƤӽФ
         */
        uart_ierdy_rcv(siopcb->exinf);
    }
    if (uart_putready(siopcb)) {
		iid = sil_rew_mem((VP)COMIID0);
        /*
         *  ǽХå롼ƤӽФ
         */
        uart_ierdy_snd(siopcb->exinf);
    }
}


/*
 *  SIOγߥӥ롼
 */
void
uart_isr()
{
    uart_isr_siop(&(siopcb_table[0]));
}

