/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
#   Copyright (C) 2007 by KURUSUGAWA Electronics Industry Inc, JAPAN
 *  Copyright (C) 2008 by Takahisa Yokota
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: m52235evb.h,v 1.2 2003/06/04 01:52:23 hiro Exp $
 */

/*
 *  ե꡼롦ߥ M52235EVB
 *  ܡɸͭ
 */

#ifndef _M52235EVB_H_
#define _M52235EVB_H_
#include "m52235.h"
/*
 *  ߥ٥Τ
 */
#define	TIRQ_NMI	0x7u		/* Υޥ֥ */
#define	TIRQ_LEVEL6	0x6u		/* ߥ٥6 */
#define	TIRQ_LEVEL5	0x5u		/* ߥ٥5 */
#define	TIRQ_LEVEL4	0x4u		/* ߥ٥4 */
#define	TIRQ_LEVEL3	0x3u		/* ߥ٥3 */
#define	TIRQ_LEVEL2	0x2u		/* ߥ٥2 */
#define	TIRQ_LEVEL1	0x1u		/* ߥ٥1 */

#ifndef _MACRO_ONLY
/*
 *  GDB STUBƽФ롼
 */

extern void mcfuart_putc_pol(ID portid, char c);	/*  mcfuart.c  */

#ifdef GDB_STUB

#define cfv2_exit	gdb_stub_exit
#define cfv2_putc	gdb_stub_putc

Inline void
gdb_stub_exit (void)
{
	/* ƥȤƤʤ */
	Asm("trap #3"::);
}

Inline int
gdb_stub_putc (ID portid, int c)
{
	mcfuart_putc_pol (portid, c);
	return(c);
}

#else /* GDB_STUB */

Inline void
cfv2_exit ()
{
	while (1);
}

Inline void
cfv2_putc (ID portid, char c)
{
	mcfuart_putc_pol (portid, c);
}

#endif /* GDB_STUB */
#endif /* _MACRO_ONLY */
#endif /* _M52235EVB_H_ */
