/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 *  Copyright (C) 2007 by KURUSUGAWA Electronics Industry Inc, JAPAN
 *  Copyright (C) 2008 by Takahisa Yokota
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sh7615frt.h,v 1.5 2005/07/06 00:45:07 honda Exp $
 */

/*
 *	ޥɥ饤
 *  FRT
 */

#ifndef _MCFPIT_H_
#define _MCFPIT_H_

/*
 *   ޤؤϥåʬ
 *   	f/8ǥ
 */
#define TCR_CKS         0x0

/*
 *   ޤ˶뤵륯åȿ[kHz]
 *      60MHz/2 = 30MHz
 */
#define	TIMER_CLOCK		(25000)

/*
 *  ͤɽη
 */
typedef UH CLOCK;

/*
 *  ͤɽȥߥáñ̤ȤѴ
 *
 */
#define	TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define	TO_USEC(clock)		((clock) * 1000 / TIMER_CLOCK)
#define CLOCK_PER_TICK	((CLOCK) TO_CLOCK(TIC_NUME, TIC_DENO))

/*
 *  ǤΥ޼ñ̤ɽ
 */
#define	MAX_CLOCK	((CLOCK) 0xffff)

/*
 *  ޤθͤȯͤȤߤʤȽ
 */
#define	GET_TOLERANCE	100		/* ٤θѤ͡ñ̤ɽ */
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  쥸
 */
#define MCF_PIT_PCSR_EN   (0x0001u)
#define MCF_PIT_PCSR_RLD  (0x0002u)
#define MCF_PIT_PCSR_PIF  (0x0004u)
#define MCF_PIT_PCSR_PIE  (0x0008u)
#define MCF_PIT_PCSR_OVW  (0x0010u)
#define MCF_PIT_PCSR_DBG  (0x0020u)
#define MCF_PIT_PCSR_DOZE (0x0040u)

/*
 *  ȥ쥸Υɥ쥹
 */
#define MCF_PIT0_PCSR   (VH*)(IPSBAR + 0x00150000)
#define MCF_PIT0_PMR    (VH*)(IPSBAR + 0x00150002)
#define MCF_PIT0_PCNTR  (VH*)(IPSBAR + 0x00150004)


#ifndef _MACRO_ONLY

/*
 *  ޥ
 */
Inline void
mcf_timer_start ()
{
     sil_wrh_mem (MCF_PIT0_PCSR, sil_reh_mem (MCF_PIT0_PCSR) | MCF_PIT_PCSR_EN);
}

/*
 *  ް
 */
Inline void
mcf_timer_stop ()
{
    	/* ޤ 	  */
	sil_wrh_mem (MCF_PIT0_PCSR, sil_reh_mem (MCF_PIT0_PCSR) & ~MCF_PIT_PCSR_EN);
}
/*
 *  ޳׵Υꥢ
 *	TCR쥸IMFAӥåȤ1ɤ߽Фˣ񤭹
 */
Inline void
mcf_timer_int_clear ()
{
	/* ׵򥯥ꥢ     */
	sil_wrh_mem (MCF_PIT0_PCSR, sil_reh_mem (MCF_PIT0_PCSR));
}


/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
mcf_timer_initialize ()
{
	CLOCK cyc = TO_CLOCK (TIC_NUME, TIC_DENO);

	/*
	 *  ޴Ϣ
	 */
	mcf_timer_stop ();			/*  */
	/* ޾ͤΥå */
	assert (cyc <= MAX_CLOCK);
       /*
         *  ޳ߤγߥ٥ꤷ׵򥯥ꥢ塤
         *  ޥ롥
         */
        sil_wrh_mem (MCF_PIT0_PCSR, (VH)(MCF_PIT_PCSR_OVW | MCF_PIT_PCSR_PIF | MCF_PIT_PCSR_RLD));
        sil_wrh_mem (MCF_PIT0_PMR, (VH)CLOCK_PER_TICK);
        sil_wrh_mem (MCF_PIT0_PCNTR,0x0000);
        sil_wrh_mem (MCF_PIT0_PCSR, sil_reh_mem(MCF_PIT0_PCSR) | MCF_PIT_PCSR_PIE);	//ߵ
}

/*
 *  ޤ߽
 *
 *  ޤưߤ롥
 */
Inline void
mcf_timer_terminate ()
{
	/*
	 *  ޤưߤ롥
	 */
	mcf_timer_stop();
        mcf_timer_int_clear ();
	/*
	 *  ޳ߤޥ׵򥯥ꥢ롥
	 */
	sil_wrh_mem (MCF_PIT0_PCSR, sil_reh_mem(MCF_PIT0_PCSR) & ~MCF_PIT_PCSR_PIE);	//Ե
	sil_wrh_mem (MCF_PIT0_PCNTR,0x0000);
	sil_wrh_mem (MCF_PIT0_PMR,0x0000); 
        sil_wrw_mem (MCF_INTC_IMRH(MCF_INTC0), sil_rew_mem(MCF_INTC_IMRH(MCF_INTC0)) | (1 << (TBIT_TT0)));
}

/*
 *  ޤθͤɽФ
 */
Inline CLOCK
mcf_timer_get_current ()
{
	CLOCK	clk;
        
	clk = TO_CLOCK(TIC_NUME, TIC_DENO) - sil_reh_mem(MCF_PIT0_PCNTR);
	return (clk);
}

/*
 *  ޳׵Υå
 */
Inline BOOL
mcf_timer_fetch_interrupt ()
{
        return (sil_reh_mem (MCF_PIT0_PCSR) & MCF_PIT_PCSR_PIF);
}

#endif /* _MACRO_ONLY */
#endif /* _MCFPIT_H_ */
