/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 *  @(#) $Id: cpu_config.h,v 1.8 2007/03/23 07:58:33 honda Exp $
 */

/*
 *      ץå¸⥸塼H8ѡ
 *ͥǻѤ
 *ǡޥؿΥץȥ
 *
 *  Υ󥯥롼ɥեϡt_config.h Τߤ饤󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤƤϤʤʤ
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

#include <h8.h>

/*
 *  ͥ̾Υ͡
 */

#include <cpu_rename.h>

/*
 *  ץåü̿Υ饤ؿ
 */

#ifndef _MACRO_ONLY
#include <cpu_insn.h>
#endif /* _MACRO_ONLY */

/*
 *  TCB ΥեɤΥӥå
 *
 *  cpu_context.h 쥬ȤȤΰ¸δطǡ
 *  cpu_context.h ˤʤ
 */
#define TBIT_TCB_TSTAT          8       /* tstat եɤΥӥå */
#define TBIT_TCB_PRIORITY       8       /* priority եɤΥӥå */


#ifndef _MACRO_ONLY

/*
 *  ƥȥ֥å
 */

typedef struct task_context_block {
        VP      sp;             /* åݥ */
        FP      pc;             /* ץ५ */
} CTXB;

/*
 *  ߥޥ饤֥
 */

/*
 *  ߤγߥޥɽФ
 */
Inline UB
current_intmask(void)
{
        UB ccr = current_ccr();
        
        ccr &= (UB)CCR_DISINT_ALL;
        return(ccr);
}

/*
 *  ߥޥ
 */
Inline void
set_intmask(UB intmask)
{
        UB ccr = current_ccr();
        
        /*
         *and_ccr(),or_ccr()Ѥ˥ѿccr˰١
         *ͳ
         *
         *unloc_cou()ƤФΤǡintmaskͤȿǤޤ
         *ߵĤˤʤäƤϤʤ
         *  ѥηٹ뤿ᡢ㥹ȤƤ롣 
         */
        ccr = (UB)((ccr & CCR_ENAINT_ALL) | intmask);
        set_ccr(ccr);
}

/*
 *  ߥͥȥ
 */

extern volatile UB       intnest;

/*
 *  ƥȻ
 *
 *  ߥͥȥ󥿤ɤ߽Фľ˳ߤȯƤ⡢ä
 *  ˤϥƥȤ⸵äƤ
 */
Inline BOOL
sense_context(void)
{
	BOOL ret;
	
	ret = (intnest != 0) ? TRUE : FALSE;
	return(ret);
}

/*
 *  CPUå֤λ
 */

/*
 *  CPUå֤ɽե饰
 */
extern volatile BOOL     iscpulocked;

#define sense_lock()    iscpulocked
#define t_sense_lock    sense_lock
#define i_sense_lock    sense_lock

/*
 *  CPUåȤβʥƥѡ
 *
 *  task_intmask ϡchg_ipm 򥵥ݡȤ뤿ѿchg_ipm 򥵥ݡ
 *  ʤˤϡt_unlock_cpu  task_intmask  0 ֤Ƥ褤
 */

#ifdef SUPPORT_CHG_IPM
extern volatile UB       task_intmask;   /* ƥȤǤγߥޥ */
#endif /* SUPPORT_CHG_IPM */

Inline void
t_lock_cpu(void)
{
        disint();
        iscpulocked = TRUE;
}

Inline void
t_unlock_cpu(void)
{
        iscpulocked = FALSE;
#ifdef SUPPORT_CHG_IPM
        /*
         *  t_unlock_cpu ƤӽФΤ CPUå֤ΤߤǤ뤿ᡣ
         *   task_intmask 񤭴뤳ȤϤʤ
         */
        set_intmask(task_intmask);
#else /* SUPPORT_CHG_IPM */
        enaint();               /* cpu_insn.h */
#endif /* SUPPORT_CHG_IPM */
}

/*
 *  CPUåȤβ󥿥ƥѡ
 */

extern volatile UB       int_intmask;    /* 󥿥ƥȤǤγߥޥ */

Inline void
i_lock_cpu(void)
{
        UB      intmask = current_intmask();
        /*
         *  ѿ intmask ȤäƤΤϡcurrent_intmask()Ƥ
         *  ľ˳ߤȯư줿ߥϥɥ
         *  int_intmask ѹǽ뤿Ǥ롥
         */

        disint();
        int_intmask = intmask;
        iscpulocked = TRUE;
}

Inline void
i_unlock_cpu(void)
{
        iscpulocked = FALSE;
        set_intmask(int_intmask);
}

/*
 *  ǥѥå
 */

/*
 *  ǹ̥ͥؤΥǥѥåcpu_support.S
 *
 *  dispatch ϡƥȤƤӽФ줿ӥ
 *  ǡCPUå֤ǸƤӽФʤФʤʤ
 */

extern void     dispatch(void);

/*
 *  ߤΥƥȤΤƤƥǥѥåcpu_support.S
 *
 *  exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 */

extern void     exit_and_dispatch(void);

/*
 *
 *  ߥϥɥ
 *
 *  ٥ȥֹ inhno γߥϥɥεưϤ inthdr ꤹ롥
 *
 *H8ǤǤϲ򤷤ʤ
 *ʥ٥ơ֥ޥ˥奢Խ
 */
Inline void
define_inh(INHNO inhno, FP inthdr)
{
}

/*
 *  CPU㳰ϥɥ
 *H8ǤǤϻѤʤ
 */

Inline void
define_exc(EXCNO excno, FP exchdr)
{
}

/*
 *  ߥϥɥν
 *H8CH8¸Ǥϳߤν򥢥֥饽
 *뤿ᡢCɬפʤ
 *Ǥ϶ȤΥ󥿡ե碌뤿ᡢ
 *ɬפʥޥΤߤƤ롣
 */

/*
 *  C롼δؿ̾Υ٥
 *H8CH8¸Ǥvector.srcΥ롦ܥ
 *ǤΤǡХ˸ɬפʤ
 *Ǥ϶ȤΥ󥿡ե碌뤿ᡢ
 *ߡΥ٥ͿƤ롣
 */
#define INT_ENTRY(inthdr) _kernel_common_interrupt_process
#define EXC_ENTRY(exchdr) _kernel_common_interrupt_process

/*
 *  ߥϥɥνޥ
 *CǤϤޤǤʤᡢ֥饽
 *Ѱդ롣
 */
#define INTHDR_ENTRY(inthdr) extern void INT_ENTRY(inthdr)(void) throw()

/*
 *  CPU㳰ϥɥνޥ
 */
#define EXCHDR_ENTRY(exchdr) extern void EXC_ENTRY(exchdr)(void) throw()

/*
 *  CPU㳰ȯΥƥ֤λ
 */

/*
 *  CPU㳰ȯΥƥȽ
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
        /* H8ǤǤϸƤФʤ */
        return(TRUE);
}

/*
 *  CPU㳰ȯCPUå֤λ
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
        /* H8ǤǤϸƤФʤ */
        return(TRUE);
}

/*
 *  ץå¸ν
 */

extern void     cpu_initialize(void);

/*
 *  ץå¸νλ
 */

extern void     cpu_terminate(void);

/*
 *  ̤ȯΥ顼ϻΥå¤
 */

typedef struct exc_stack {
	UW	er0;
	UW	er1;
	UW	er2;
	UW	er3;
	UW	er4;
	UW	er5;
	UW	er6;
	UW	pc;	/*  ץࡦ  	*/
} EXCSTACK;

/*
 * ̤ȯΥ顼 (cpu_config.c, cpu_support.S)
 */

extern void     cpu_experr(EXCSTACK *sp);

/*
 *  åȥƥʸ
 *
 *  ƥ٥ʸϥ롼
 */
extern void cpu_putc(char c);

#endif /* _MACRO_ONLY_ */

#endif /* _CPU_CONFIG_H_ */
