/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: h8.h,v 1.11 2007/03/23 07:22:15 honda Exp $
 */

#ifndef _H8_H_
#define _H8_H_

/*
 *  H8 
 */

/*
 *  ͥǡʸѥޥ
 */

#define TO_STRING(arg)	#arg
#define _TO_STRING(arg)	TO_STRING(arg)

/* Condition Code Register (CCR) */

#define H8CCR_I_BIT		7
#define H8CCR_UI_BIT		6
#define H8CCR_H_BIT		5
#define H8CCR_U_BIT		4
#define H8CCR_N_BIT		3
#define H8CCR_Z_BIT		2
#define H8CCR_V_BIT		1
#define H8CCR_C_BIT		0

#define H8CCR_I			(1<<H8CCR_I_BIT)
#define H8CCR_UI		(1<<H8CCR_UI_BIT)
#define H8CCR_H			(1<<H8CCR_H_BIT)
#define H8CCR_U			(1<<H8CCR_U_BIT)
#define H8CCR_N			(1<<H8CCR_N_BIT)
#define H8CCR_Z			(1<<H8CCR_Z_BIT)
#define H8CCR_V			(1<<H8CCR_V_BIT)
#define H8CCR_C			(1<<H8CCR_C_BIT)

/* CCR  IӥåȤUIӥåȤߥޥӥåȤȤƻѤ롣*/

#define H8INT_MASK_ALL		(H8CCR_I | H8CCR_UI)

#define H8INT_DIS_ALL		H8INT_MASK_ALL
#define H8INT_ENA_ALL		(0xff & ~(H8INT_MASK_ALL))

#define str_H8INT_DIS_ALL	_TO_STRING(H8INT_DIS_ALL)
#define str_H8INT_ENA_ALL	_TO_STRING(H8INT_ENA_ALL)

/*
 *  ٥룰٤Ƥγߤդ
 */
#define IPM_LEVEL0      0

/*
 *  ٥룱NMIӥץ饤ƥ٥룱γߤΤߤդ
 */
#define IPM_LEVEL1      H8CCR_I

/*
 *  ٥룲NMIʳγߤդʤ
 */
#define IPM_LEVEL2      (H8CCR_I | H8CCR_UI)


#endif /* _H8_H_ */
