/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Kunihiko Ohnaka
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_config.h,v 1.3 2007/03/23 07:22:15 honda Exp $
 */

#ifndef _SYS_CONFIG_H_
#define _SYS_CONFIG_H_

/*
 *  ͥ̾Υ͡
 */

#include <sys_rename.h>

/*
 *  åȥƥΥϡɥ񸻤
 */

#include <h8_3069f.h>

/*
 *  ưåΥå̾
 */

#define	TARGET_NAME	"NKEV-010H8"

/*
 *  chg_ipm򥵥ݡȤ뤫ɤ
 */
#define SUPPORT_CHG_IPM

/*
 *  vxget_tim 򥵥ݡȤ뤫ɤ
 */

#define	SUPPORT_VXGET_TIM

/*
 *   åΰ
 */

#define STACKTOP    	(H8IN_RAM_BASE + H8IN_RAM_SIZE)	/* Ωѥåν */
#define str_STACKTOP	_TO_STRING(STACKTOP)

#ifndef _MACRO_ONLY

/*
 *  åȥƥ¸ν
 */

extern void	sys_initialize(void);

/*
 *  åȥƥνλ
 *
 *  ƥλ˻ȤROM˥ƽФǼ¸뤳Ȥꤷ
 *  Ƥ롥
 */

extern void	sys_exit(void);

/*
 *  åȥƥʸ
 *
 *  ƥ٥ʸϥ롼ROM˥ƽФǼ¸뤳
 *  ȤꤷƤ롥
 */

extern void cpu_putc(char c);

Inline void
sys_putc(char c)
{
#ifndef GDB_STUB

	cpu_putc(c);

#else	/* of #ifndef GDB_STUB */

/* GDB STUBȤ٥ϤGDBΥ󥽡ؽ */
	asm ("	push.l	er1			\n"\
		"	mov.l	er0, er1	\n"\
		"	sub.l	er0, er0	\n"\
		"	trapa	#1			\n"\
		"	pop.l	er1			\n"\
	);

#endif	/* of #ifndef GDB_STUB */

	};

#endif /* _MACRO_ONLY */


/*
 *  (1) ꥢݡȤ
 *  (2) ޡ
 *  (3) ɥ쥹
 */

/*
 *  ݡȤ륷ꥢǥХοϺ 3
 *  ߤ 2 ޤƤ롣
 *  
 *  ץץư
 *  sys_defs.hˤTASK_PORTIDˤ
 */

#ifdef GDB_STUB

/* GDB stubѤȤ϶ŪTNUM_POTR = 1ˤ */
#define TNUM_PORT	1

#else	/* of #ifdef GDB_STUB */

#define TNUM_PORT	2

#endif	/* of #ifdef GDB_STUB */

#define	CONSOLE_PORTID		SYSTEM_PORTID	/* 󥽡Ѥ륷ꥢݡֹ     */
#define	LOGTASK_PORTID		SYSTEM_PORTID	/* ƥϤ륷ꥢݡֹ */

#define H8_MIN_BAUD_RATE	9600		/* SCI 򥯥Ԥ֤η׻˻Ѥ롣*/

/* 顼ߤϳߤ̤ϥȤϤ*/
/*#define H8_CFG_SCI_ERR_HANDLER*/

/*
 *  SYSTEM  SCI 
 */

#ifdef GDB_STUB

/* GDB stubѤSYSTEM_SCISCI0Ѥ */
#define SYSTEM_SCI			H8SCI0
#define SYSTEM_SCI_IPR		H8IPRB
#define SYSTEM_SCI_IP_BIT	H8IPR_SCI0_BIT

#else	/* of #ifdef GDB_STUB */

#define SYSTEM_SCI			H8SCI1
#define SYSTEM_SCI_IPR		H8IPRB
#define SYSTEM_SCI_IP_BIT	H8IPR_SCI1_BIT

#endif	/* of #ifdef GDB_STUB */

#define SYSTEM_SCI_SMR		0
			/* եޥå			*/
	     		/* ĴƱ				*/
	     		/* 饯󥰥8ӥå		*/
	     		/* ѥƥʤ				*/
	     		/* ȥåץӥåȥ󥰥1		*/
	     		/* å쥯ȡʬ:1		*/

#define SYSTEM_BAUD_RATE	38400			/* bps	*/

#if TNUM_PORT == 1

#define	SYSTEM_PORTID		1

#ifdef GDB_STUB

#define INHNO_SERIAL_IN		IRQ_RXI0
#define INHNO_SERIAL_OUT	IRQ_TXI0
#define INHNO_SERIAL_ERR	IRQ_ERI0

#else	/*	#ifdef GDB_STUB */

#define INHNO_SERIAL_IN		IRQ_RXI1
#define INHNO_SERIAL_OUT	IRQ_TXI1
#define INHNO_SERIAL_ERR	IRQ_ERI1

#endif	/*	#ifdef GDB_STUB */

#elif TNUM_PORT == 2	/* of #if TNUM_PORT == 1 */

#define USER_SCI		H8SCI0

#define USER_SCI_IPR		H8IPRB
#define USER_SCI_IP_BIT		H8IPR_SCI0_BIT

#define USER_SCI_SMR		0
			/* եޥå			*/
	     		/* ĴƱ				*/
	     		/* 饯󥰥8ӥå		*/
	     		/* ѥƥʤ				*/
	     		/* ȥåץӥåȥ󥰥1		*/
	     		/* å쥯ȡʬ:1		*/

#define USER_BAUD_RATE		38400			/* bps	*/

#define	USER_PORTID		1
#define	SYSTEM_PORTID		2

#define INHNO_SERIAL_IN		IRQ_RXI0
#define INHNO_SERIAL_OUT	IRQ_TXI0
#define INHNO_SERIAL_ERR	IRQ_ERI0

#define INHNO_SERIAL2_IN	IRQ_RXI1
#define INHNO_SERIAL2_OUT	IRQ_TXI1
#define INHNO_SERIAL2_ERR	IRQ_ERI1

#else	/* of #if TNUM_PORT == 1 */

#error TNUM_PORT <= 2

#endif	/* of #if TNUM_PORT == 1 */

/*  ץ饤ƥ٥ѤΥǡ  */

/*  ׵Υ٥  */
#define SYSTEM_SCI_IPM			IPM_LEVEL0
#define USER_SCI_IPM			IPM_LEVEL0

/*  
 * ߥϥɥ¹γߥޥ
 * ¾γߤޥ뤿  
 * ʬƱ٥γ׵֥å뤿ᡢ
 * 嵭γ׵٥꣱Ĺ⤤٥ꤹ롣
 */
#if TNUM_PORT == 1	/*  ݡȣƥࡦݡ  */

/*  ƥࡦݡ  */
#if SYSTEM_SCI_IPM == IPM_LEVEL0
#define sio_in_handler_intmask		IPM_LEVEL1
#elif SYSTEM_SCI_IPM == IPM_LEVEL1
#define sio_in_handler_intmask		IPM_LEVEL2
#endif 	/* SYSTEM_SCI_IPM == IPM_LEVEL0 */


#elif TNUM_PORT == 2	/* of #if TNUM_PORT == 1 */
			/*  ݡȣ桼ݡ  */
			/*  ݡȣƥࡦݡ  */
/*  桼ݡ  */
#if USER_SCI_IPM == IPM_LEVEL0
#define sio_in_handler_intmask		IPM_LEVEL1
#elif USER_SCI_IPM == IPM_LEVEL1
#define sio_in_handler_intmask		IPM_LEVEL2
#endif 	/* USER_SCI_IPM == IPM_LEVEL0 */

/*  ƥࡦݡ  */
#if SYSTEM_SCI_IPM == IPM_LEVEL0
#define sio_in2_handler_intmask		IPM_LEVEL1
#elif SYSTEM_SCI_IPM == IPM_LEVEL1
#define sio_in2_handler_intmask		IPM_LEVEL2
#endif 	/* SYSTEM_SCI_IPM == IPM_LEVEL0 */

#endif	/* of #if TNUM_PORT == 1 */

#define sio_out_handler_intmask		sio_in_handler_intmask
#define sio_err_handler_intmask		sio_in_handler_intmask

#ifndef GDB_STUB

#define sio_out2_handler_intmask	sio_in2_handler_intmask
#define sio_err2_handler_intmask	sio_in2_handler_intmask

#endif
/*
 *  ޤ
 */

#define SYSTEM_TIMER		H816TU0

#define SYSTEM_TIMER_CNT	(SYSTEM_TIMER + H8TCNT)
#define SYSTEM_TIMER_TCR	(SYSTEM_TIMER + H8TCR)
#define SYSTEM_TIMER_TIOR	(SYSTEM_TIMER + H8TIOR)
#define SYSTEM_TIMER_IER	H816TU_TISRA
#define SYSTEM_TIMER_IFR	H816TU_TISRA
#define SYSTEM_TIMER_TSTR	H816TU_TSTR
#define SYSTEM_TIMER_GR		(SYSTEM_TIMER + H8GRA)

#define SYSTEM_TIMER_STR	H8TSTR_STR0
#define SYSTEM_TIMER_STR_BIT	H8TSTR_STR0_BIT
#define SYSTEM_TIMER_IE		H8TISRA_IMIEA0		/* interrupt mask */
#define SYSTEM_TIMER_IE_BIT	H8TISRA_IMIEA0_BIT
#define SYSTEM_TIMER_IF		H8TISRA_IMFA0		/* match flag */
#define SYSTEM_TIMER_IF_BIT	H8TISRA_IMFA0_BIT

#define INHNO_TIMER		IRQ_IMIA0

#define SYSTEM_TIMER_TCR_BIT	(H8TCR_CCLR0 | H8TCR_TPSC1 | H8TCR_TPSC0)
#define SYSTEM_TIMER_TIOR_BIT	(0)

#define TIMER_CLOCK		((CPU_CLOCK)/8000)	/* 20MHz / 8 = 2.5MHz = 2500KHz */

/*  ץ饤ƥ٥ѤΥǡ  */

/*  ׵Υ٥  */
#define SYSTEM_TIMER_IPR                H8IPRA
#define SYSTEM_TIMER_IP_BIT             H8IPR_ITU0_BIT
#define SYSTEM_TIMER_IPM                IPM_LEVEL1

/*  
 * ߥϥɥ¹γߥޥ
 * ¾γߤޥ뤿  
 * ʬƱ٥γ׵֥å뤿ᡢ
 * 嵭γ׵٥꣱Ĺ⤤٥ꤹ롣
 */
#if SYSTEM_TIMER_IPM == IPM_LEVEL0
#define timer_handler_intmask		IPM_LEVEL1
#elif SYSTEM_TIMER_IPM == IPM_LEVEL1
#define timer_handler_intmask		IPM_LEVEL2
#endif 	/* SYSTEM_TIMER_IPM == IPM_LEVEL0 */

/*
 *  ɥ쥹
 */

#define	ENABLE_P8_CS		(H8P8DDR_CS0|H8P8DDR_CS1|H8P8DDR_CS2|H8P8DDR_CS3)

#if 0

#define	ENABLE_LOWER_DATA
#define	ENABLE_PB_CS		(H8PADDR_CS4|H8PADDR_CS5|H8PADDR_CS6|H8PBDDR_CS7)

#endif	/* of #if 0 */

#define	HEAP_TOP		0x600000UL

/*
 *  ԤΤ
 */

#if defined(ROM)

/*  ROM̿᤬¢եåROM֤Ƥ  */
#define	SIL_DLY_TIM1	 4540
#define	SIL_DLY_TIM2	  529

#elif defined(INMEM_ONLY)

/*  ROM¢Τ߻ */
#define	SIL_DLY_TIM1	 2800
#define	SIL_DLY_TIM2	  521

#else	/* of #if defined(ROM) */

/*  ̿᤬RAM֤Ƥ  */
#define	SIL_DLY_TIM1	 8290
#define	SIL_DLY_TIM2	 1693

#endif	/* of #if defined(ROM) */


/*
 *  DDRνͤ
 */

#define	H8P1DDR0        0xff				/*  ݡ1  */
#define	H8P2DDR0        0xff				/*  ݡ2  */
#define	H8P3DDR0        DUMMY				/*  ݡ3  */
#define	H8P4DDR0        DUMMY				/*  ݡ4  */
#define	H8P5DDR0        0xff				/*  ݡ5  */
#define	H8P6DDR0        DUMMY				/*  ݡ6  */

/*  ݡ7ѤDDR쥸ʤᡢάƤ롣  */

#define	H8P8DDR0        (H8P8DDR_CS1 | H8P8DDR_CS2 | H8P8DDR_CS3)
							/*  ݡ8  */
#define	H8P9DDR0        DUMMY				/*  ݡ9  */
#define	H8PADDR0        DUMMY				/*  ݡA  */
#define	H8PBDDR0        DUMMY				/*  ݡB  */

#endif /* _SYS_CONFIG_H_ */
