/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _H8S_SCI_H_
#define _H8S_SCI_H_

#include <s_services.h>		/* ǥХɥ饤ɸ।󥯥롼ɥե */
#include <h8s_sil.h>

/*
 *  H8S ¢ꥢ륳ߥ˥󥤥󥿥ե(SCI)Ϣ
 */

/* SCI쥸Υɥ쥹 */
/* ١ɥ쥹 */
#define SCI0_BASE_ADDR	0xff78	/* ͥ룰 */
#define SCI1_BASE_ADDR	0xff80	/* ͥ룱 */
/* 쥸եå */
#define SMR		0	/* ꥢ⡼ɥ쥸 */
#define BRR		1	/* ӥåȥ졼ȥ쥸 */
#define SCR		2	/* ꥢ륳ȥ쥸 */
#define TDR		3	/* ȥ󥹥ߥåȥǡ쥸 */
#define SSR		4	/* ꥢ륹ơ쥸 */
#define RDR		5	/* 쥷֥ǡ쥸 */
#define SCMR		6	/* ޡȥɥ⡼ɥ쥸 */

/* ƥ쥸Υӥåȥѥ */

/* RSR, RDR, TSR, TDR */
/* ٤Τϡä̵ */

/* SMR */
#define CA	BIT7
#define	CHR	BIT6	/* 8bit = 0 / 7bit = 1 */
#define	PE	BIT5	/* Parity OFF = 0 / Parity ON = 1 */
#define	OE	BIT4	/* EVEN Parity = 0 / ODD Parity = 1 */
#define	STOP	BIT3	/* 1 STOP BIT = 0 / 2 STOP BIT = 1 */
#define MP	BIT2
#define	CSK1	BIT1
#define	CSK0	BIT0

/* SCR */
#define TIE	BIT7
#define	RIE	BIT6
#define	TE	BIT5
#define	RE	BIT4
#define	MPIE	BIT3
#define TEIE	BIT2
#define	CKE1	BIT1
#define	CKE0	BIT0

/* SSR */
#define TDRE	BIT7
#define	RDRF	BIT6
#define	ORER	BIT5
#define	FER	BIT4
#define	PER	BIT3
#define TEND	BIT2
#define	MPB	BIT1
#define	MPBT	BIT0

/*
 *  ܡ졼ȴط
 *    ưȿ20 [MHz] ʤΤǡޥ˥奢p567ޤ롣
 */
#if BAUD_RATE == 9600		/* ӥåȥ졼ȡ 9600 [bit/s] */
	#define BRR_RATE	64	/* N = 64 */
#elif BAUD_RATE == 38400	/* ӥåȥ졼ȡ38400 [bit/s] */
	#define BRR_RATE	15	/* N = 15 */
#elif BAUD_RATE == 57600	/* ӥåȥ졼ȡ57600 [bit/s] */
	#define BRR_RATE	10	/* N = 10 */
#endif

#ifndef _MACRO_ONLY

/*
 *  ꥢI/OݡȽ֥å
 */
typedef struct sio_port_control_block	SIOPCB;

#endif /* _MACRO_ONLY */

/*
 *  SCIѥƥ।󥿥ե쥤䡼
 */
/* x : ݡȤΥ١ɥ쥹(UW )
   y : 쥸եå(UW )
   z : 쥸 */
#define h8s_sci_wrb( x, y, z )	h8s_wrb_mem( (VP)(x + y), z )
#define h8s_sci_reb( x, y )	h8s_reb_mem( (VP)(x + y) )

/*
 *  Хå롼μֹ
 */
#define SIO_ERDY_SND	1u		/* ǽХå */
#define SIO_ERDY_RCV	2u		/* ΥХå */

#ifndef _MACRO_ONLY

/*
 *  SIOɥ饤Фν롼
 */
extern void	h8s_sci_initialize(void);

/*
 *  ץ󤷤ƤݡȤ뤫
 */
extern BOOL	h8s_sci_openflag(void);

/*
 *  ꥢI/OݡȤΥץ
 */
extern SIOPCB	*h8s_sci_opn_por(ID siopid, VP_INT exinf);

/*
 *  ꥢI/OݡȤΥ
 */
extern void	h8s_sci_cls_por(SIOPCB *siopcb);

/*
 *  ꥢI/OݡȤؤʸ
 */
extern BOOL	h8s_sci_snd_chr(SIOPCB *siopcb, char c);

/*
 *  ꥢI/OݡȤʸ
 */
extern INT	h8s_sci_rcv_chr(SIOPCB *siopcb);

/*
 *  ꥢI/OݡȤΥХåε
 */
extern void	h8s_sci_ena_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  ꥢI/OݡȤΥХåζػ
 */
extern void	h8s_sci_dis_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  SIOγߥӥ롼
 */
extern void	h8s_sci_isr_in(void);
extern void	h8s_sci_isr_out(void);

/*
 *  SIOμ顼ߥӥ롼
 */
extern void	h8s_sci_isr_error(void);

/*
 *  ꥢI/OݡȤǽХå
 */
extern void	h8s_sci_ierdy_snd(VP_INT exinf);

/*
 *  ꥢI/OݡȤμΥХå
 */
extern void	h8s_sci_ierdy_rcv(VP_INT exinf);

/*
 *  ͥ뵯ưѤν (sys_putc)
 */
extern void	h8s_sci_init(void);

/*
 *  ꥢI/OݡȤؤʸʥݡ󥰡
 */
extern void	h8s_sci_putchar_pol(char c);

#endif /* _MACRO_ONLY */

#endif /* _H8S_sci_H_ */
