/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000,2001 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2002 by Monami software, Limited Partners.
 *  Copyright (C) 2008-     by Monami Software Limited Partnership, JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id: cpu_context.h,v 1.1 2004/07/21 02:49:36 monaka Exp $
 */

/*
 *	ƥ롼
 *
 *  Υե cpu_config.h ʬΥƤΤϡΥե TCB
 *  줿ɤɬפΤФơcpu_config.h ˤ TCB 
 *  ɤɬפޤǤ뤿Ǥ롥
 */

#ifndef _CPU_CONTEXT_H_
#define _CPU_CONTEXT_H_

#include "task.h"

/*
 *  ƥȥ֥åν
 *
 *  ٻ߾֤˰ܹԤʥνλˤ˸
 *  Ф롥Ūˤϡƥȥ֥å򥿥ưǤ
 *  ֤ꤹcreate_context  activate_context ǹԤ
 *  褤¿νϤɤδؿǹԤäƤ褤
 */
Inline void
create_context(TCB *tcb)
{
}

/*
 *  εư
 *
 *  ٻ߾֤¹ԤǤ֤˰ܹԤ˸ƤФ롥
 */
extern void	activate_r(void);

Inline void
activate_context(TCB *tcb)
{
	VW	*esp;

	esp = (VW *)((SIZE)(tcb->tinib->stk) + tcb->tinib->stksz);
	*--esp = (VW)(tcb->tinib->exinf);
	*--esp = (VW) ext_tsk;
	*--esp = (VW)(tcb->tinib->task);
	tcb->tskctxb.esp = esp;
	tcb->tskctxb.eip = activate_r;
}

/*
 *  ext_tsk å˳ݤߡΰΥ
 */
#define	ACTIVATED_STACK_SIZE	(sizeof(VW) * 3)

#if 0
/*
 *  calltex ϻѤʤ
 */
#define OMIT_CALLTEX
#endif

#endif /* _CPU_CONTEXT_H_ */
