/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000,2001 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2002 by Monami software, Limited Partners.
 *  Copyright (C) 2002 by MURANAKA Masaki
 *  Copyright (C) 2008-     by Monami Software Limited Partnership, JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id: hw_serial.h,v 1.1 2004/07/21 02:49:36 monaka Exp $
 */

/*
 *	åȰ¸ꥢI/O⥸塼PC/ATѡ
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>
#include <irc.h>
#include <pcat_com.h>

/*
 *  ꥢI/OγߥϥɥΥ٥ֹ
 */
#define INHNO_SIO1	 PCAT_COM1_INHNO
#if TNUM_PORT >= 2
#define INHNO_SIO2	 PCAT_COM2_INHNO
#endif

#ifndef _MACRO_ONLY

/*
 *  ꥢI/OݡȤν
 */
#define sio_initialize pcat_com_initialize

#define sio1_handler pcat_com1_handler
#if TNUM_PORT >= 2
#define sio2_handler pcat_com2_handler
#endif

Inline SIOPCB *
sio_opn_por(ID portid, VP_INT spcb)
{
  SIOPCB *p;

  p = pcat_com_opn_por(portid, spcb);

  irc_ena_irq(p->siopinib->com_irq);

  return p;
}

/*
 *  ꥢI/OݡȤνλ
 */
Inline void
sio_cls_por(SIOPCB *p)
{
	pcat_com_cls_por(p);
  irc_dis_irq(p->siopinib->com_irq);
}

#define sio_ierdy_rcv pcat_com_ierdy_rcv

#define sio_ierdy_snd pcat_com_ierdy_snd

/*
 *  ʸμФ
 */
#define sio_rcv_chr pcat_com_rcv_chr

/*
 *  ʸν񤭹
 */
#define sio_snd_chr pcat_com_snd_chr

#define sio_ena_cbr pcat_com_ena_cbr

#define sio_dis_cbr pcat_com_dis_cbr

#endif /* _MACRO_ONLY */

#endif /* _HW_SERIAL_H_ */
