/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000,2001 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2002 by Monami software, Limited Partners.
 *  Copyright (C) 2002 by MURANAKA Masaki
 *  Copyright (C) 2008-     by Monami Software Limited Partnership, JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id: sys_support.S,v 1.1 2004/07/21 02:49:37 monaka Exp $
 */

/*
 *	åȥƥ¸⥸塼 ֥PC/ATѡ
 */

#define	_MACRO_ONLY
#include "jsp_kernel.h"
#include "offset.h"

/*
 *  ٥Υåȥƥ¸ν
 *
 *  ȥåץ⥸塼ǡν˸ƤӽФ롥
 */
		.text
	.globl hardware_init_hook
hardware_init_hook:	
	movl %cr0, %eax
	andl $~0x60000000, %eax
	movl %eax, %cr0 /* CD = 0, NW = 0 */
	ret; 

#define CALL_HANDLER(x) incl nest; sti; call x; cli; decl nest

/*
 *   ߥϥɥν
 *
 *   ֹ%ecxƸƤӽФ롣
 */
	.text
interrupt:
	cld
	cmpl	$0, nest
	jne	interrupt_2		/* ¦Υϥɥ */
	/* ¦Υϥɥ */
	movl %esp, %eax
	movl	STACKTOP, %esp
	pushl %eax
interrupt_2:				
	pushl %ecx /* intno */
	movl int_table(,%ecx,4), %eax
	testl %eax, %eax
	jz 0f
	CALL_HANDLER(*%eax)
0:
	popl %eax /* intno */
	testb $8, %al
	jz 1f
	movb $0x20, %al
	outb %al, $0xa0 /* slave non-specific EOI */
1:
	movb $0x20, %al
	outb %al, $0x20 /* master non-specific EOI */
	cmpl	$0, nest
	jne	interrupt_3
	popl %eax
	movl %eax, %esp
	cmpl $0, reqflg
	je interrupt_3
ret_int:
	movl	$0, reqflg
	cmpl	$0, enadsp
	je	ret_int_r
	movl	runtsk, %ebx
	cmpl	%ebx, schedtsk
	je	ret_int_r
	movl %esp, TCB_esp(%ebx)
	movl	$ret_int_r, %eax
	movl	%eax, TCB_eip(%ebx)
	jmp	dispatch_loop
ret_int_r:
	call	calltex
interrupt_3:	
	popa
	iret

#define interrupt(intno) \
	.global interrupt##intno ; \
interrupt##intno: ; \
	pusha ; \
	movl $intno, %ecx ; \
	jmp interrupt

	interrupt(0)
	interrupt(1)
	interrupt(2)
	interrupt(3)
	interrupt(4)
	interrupt(5)
	interrupt(6)
	interrupt(7)
	interrupt(8)
	interrupt(9)
	interrupt(10)
	interrupt(11)
	interrupt(12)
	interrupt(13)
	interrupt(14)
	interrupt(15)
