/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.h,v 1.14 2007/07/27 11:28:44 honda Exp $
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

#include "cpu_defs.h"

#ifndef _MACRO_ONLY
#include <cpu_insn.h>
#endif

#ifndef _MACRO_ONLY

extern UW exception_count;
extern UW exception_registers[40];

typedef struct task_context_block {
        VP	sp;             
        FP	pc;             
} CTXB;


Inline BOOL
sense_context()
{
    return(exception_count > 0);
}

Inline BOOL
sense_lock()
{
    return((current_sr() & 0x1) == 0);
}

#define t_sense_lock     sense_lock
#define i_sense_lock     sense_lock

Inline void
lock_cpu()
{
    disint();
}

Inline void
unlock_cpu()
{
    enaint();
}

#define EXC_ENTRY(exchdr)     exchdr
#define EXCHDR_ENTRY(exchdr)  extern void exchdr(VP sp)

Inline BOOL
exc_sense_context(VP p_excinf)
{
    return(exception_count > 1);
}

Inline BOOL
exc_sense_lock(VP p_excinf)
{
	return((current_sr() & 0x2) == 0);
}


#define t_lock_cpu      lock_cpu
#define i_lock_cpu      lock_cpu
#define t_unlock_cpu    unlock_cpu
#define i_unlock_cpu    unlock_cpu

extern void dispatch(void);
extern void exit_and_dispatch(void);

extern FP int_table[TMAX_ALL_INTNO];
extern FP exc_table[TMAX_CORE_EXCNO];

Inline void define_inh(INTNO intno, FP inthdr)
{
    int_table[intno] = inthdr;
}

Inline void define_exc(EXCNO excno, FP exchdr)
{
    exc_table[excno] = exchdr;
}

extern void _start();
extern void Breakpoint_exception();
extern void InstructionBusError_exception();
extern void Watchpoint_exception();
extern void DataBusError_exception();
extern void DivideByZero_exception();
extern void Interrupt_exception();
extern void SystemCall_exception();

extern void cpu_initialize(void);
extern void cpu_terminate(void);

#endif /* _MACRO_ONLY */

#endif /* _CPU_CONFIG_H_ */

