/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: m32relf.ld,v 1.2 2007/05/28 02:03:55 honda Exp $
 */

OUTPUT_FORMAT("elf32-m32r","elf32-m32r","elf32-m32r")
OUTPUT_ARCH(m32r)

PROVIDE(__stack = 0x04100000);
PROVIDE(hardware_init_hook = 0);
PROVIDE(software_init_hook = 0);
PROVIDE(software_term_hook = 0);

MEMORY
{
	iram(waxi)	: org = 0x00f00000, len = 32k		/* ¡RAMΰ 32kB	*/
	eram(waxi)	: org = 0x04000000, len = 64m		/* RAMΰ 64MB	*/
}

SECTIONS
{
	/* ߥ٥ưϼΥȤȤäơ
	   .textƬˤ*(.vector)򥳥ȥȤФ褤 */
/*
	.vector : 
	{	*(.vector)		} > iram
*/

	. = ALIGN(4);
    .text :	
    {
        *(.vector)
       	__stext = . ;
       	*(.text)
		__etext = . ;
   
	 } > iram

	. = ALIGN(4);
    .rodata : 
	{
		__srodata = .;
		 *(.rodata)
		__erodata = .;
	} > iram

	. = ALIGN(4);
	__sidata = . ;

    .data   :  AT(__sidata) 
    {
		. = ALIGN(4);
		__sdata = .;
        	*(.data)
		. = ALIGN(4);
		__edata = .;
    } > eram

	__eidata = __edata - __sdata + __sidata;

    .bss :
    {
		. = ALIGN(4);
		__sbss = .;
		*(.bss)
		*(COMMON) 
		. = ALIGN(4);
		__ebss = .;
    } > eram

    .comment 0 : { *(.comment) }	
    .debug          0 : { *(.debug) }
    .line           0 : { *(.line) }
    .debug_srcinfo  0 : { *(.debug_srcinfo) }
    .debug_sfnames  0 : { *(.debug_sfnames) }
    .debug_aranges  0 : { *(.debug_aranges) }
    .debug_pubnames 0 : { *(.debug_pubnames) }	
}
