/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

/*
 *  ץå˰¸MIPS3ѡ
 *
 *  Υ󥯥롼ɥեϡkernel.h  sil.h ǥ󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤ뤳ȤϤʤΥե򥤥
 *  롼ɤˡt_stddef.h  itron.h 󥯥롼ɤΤǡ
 *  ˰¸Ƥ褤
 */

#define MIPS3

/* ͥ뵯ưΥå */
#define COPYRIGHT_CPU \
"Copyright (C) 2001-2003 by Industrial Technology Institute,\n" \
"                            Miyagi Prefectural Government, JAPAN\n"

#ifndef _MACRO_ONLY

/*
 *  ߡCPU㳰ϥɥֹη
 */
typedef	UINT	INHNO;			/* ߥϥɥֹ */
typedef	UINT	EXCNO;			/* CPU㳰ϥɥֹ */

/*
 *  ߥޥηȳߥޥѹ
 */

/* MIPS3γߥޥη (ͤϥƥ¸˵) */
typedef	UW	CORE_IPM;

/* ߥޥη */
typedef	struct {
	CORE_IPM	core;	/*  MIPS3γߥޥ  */
	ICU_IPM		icu;	/*  ߥȥγߥޥ  */
} IPM;

/* ߥޥѤδؿ */
extern ER	chg_ipm(IPM p_ipm) throw();	/* ߥޥѹ */
extern ER	get_ipm(IPM *p_ipm) throw();	/* ߥޥμ */

#endif /* _MACRO_ONLY */

/*
 *  ߥå֤
 *    MIPS3ǤϡƤγߤͥʤΤǡ
 *      ߥå = CPUå
 *    ȤʤꡢΥޥƤϡɸ󶡤ƤΤȤ
 *    (⤷̤򤷤褦ȤʤСΤ褦ˤʤ롣)
 */
/*
#define	SIL_PRE_LOC
#define	SIL_LOC_INT()	t_lock_cpu()
#define	SIL_UNL_INT()	t_unlock_cpu()
*/
/*============================================================================*/
/*  ̥ɥȤ̵  */

/*  Τγߤܿ  */
#define TMAX_ALL_INTNO	(TMAX_CORE_INTNO + TMAX_ICU_INTNO)

#ifndef _MACRO_ONLY

/*  ߥϥɥ顿ߥޥơ֥Ѥη  */
typedef struct {
	FP		inthdr;		/*  ߥϥɥƬɥ쥹  */
	CORE_IPM	intmask;	/*  MIPS3γߥޥ  */
} INT_TABLE;

#endif /* _MACRO_ONLY */

#endif /* _CPU_DEFS_H_ */
