/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#define _MACRO_ONLY

#include "jsp_kernel.h"
#include "offset.h"		/* INT_TABLE_intmaskΤɬ */

	.set noreorder
	.align 2

/*
 *  åȥϡɥ¸
 */
#ifndef GDB_STUB

	.section .reset
	.global	hardware_init_hook

hardware_init_hook:

	/*
	 * åν
	 */
	mtc0	zero, TagLo
	mtc0	zero, TagHi

	li	t0, 0x80003fe0
	li	t1, 0x80000000
loop_I_cache_clear:
	cache	Index_Store_Tag_I, +0(t0)
	cache	Index_Store_Tag_I, +1(t0)
	bne	t0, t1, loop_I_cache_clear
	addiu	t0, t0, -I_CACHE_LINE_SIZE

	li	t0, 0x80003fe0
	li	t1, 0x80000000
loop_D_cache_clear:
	cache	Index_Store_Tag_D, +0(t0)
	cache	Index_Store_Tag_D, +1(t0)
	bne	t0, t1, loop_D_cache_clear
	addiu	t0, t0, -D_CACHE_LINE_SIZE

	/*
	 * TLBν
	 */
	mtc0	zero, PageMask
	mtc0	zero, EntryLo0
	mtc0	zero, EntryLo1

	li	t0, TMAX_TLB
	li	t1, 0xA8000000		/* kseg1 DRAMν */
loop_TLB_clear:
	mtc0	t0, Index
	mtc0	t1, EntryHi
	addiu	t0, t0, -1
	addiu	t1, t1, TLB_VPN2	/* 1ڡ4kХȤǡ2ڡʬ
					   ޥåԥ󥰤뤿 */
	tlbwi
	bgez	t0, loop_TLB_clear
	nop

	/*
	 * ܡɤν
	 */

	/* SDRAM ȥν */
	li	t0, 0x00
	sb	t0, 0xb8006000		/* SRAMC_SWAIT */

	li	t0, 0x02
	sb	t0, 0xb8005000		/* DRAMC_RCD */
	li	t0, 0x02
	sb	t0, 0xb8005010		/* DRAMC_RP */
	li	t0, 0x05
	sb	t0, 0xb8005020		/* DRAMC_RC */
	li	t0, 0x06
	sb	t0, 0xb8005030		/* DRAMC_RRC */
	li	t0, 0x04
	sb	t0, 0xb8005040		/* DRAMC_RAS */
	li	t0, 0x02
	sb	t0, 0xb8005050		/* DRAMC_LAT */
	li	t0, 0x02
	sb	t0, 0xb8005060		/* DRAMC_RSC */
	li	t0, 0x01
	sb	t0, 0xb8005070		/* DRAMC_AP */

	li	t0, 0x00
	sb	t0, 0xb8004000		/* DRAM_INIT */

	/* DRAMեåѥޤν */
	li	t0, 0xb4
	sb	t0, 0xb9005030		/* PCNTL */
	li	t0, 0x1f
	sb	t0, 0xb9005020		/* PCNT2 */
	li	t0, 0x00
	sb	t0, 0xb9005020		/* PCNT2 */

	/* SRAMν */

	/* SRAMΰФơٽ񤭹ߤԤɬ */
	la	t0, 0xa0000000
	li	t1, 0x00100000-4
loop_sram_clear:
	add	t2, t1, t0
	sw	zero, (t2)
	bgez	t1, loop_sram_clear
	addiu	t1, t1, -4

	/* ߥȥ */
	sb	zero, 0xb9000000	/* PIC_INT0MߤΥޥ */
	sb	zero, 0xb9000010	/* PIC_INT1MߤΥޥ */
	sb	zero, 0xb9000020	/* PIC_INTR ׵Υꥢ */
	li	t0, 0x01		/* Τ߻Ȥ */
	sb	t0, 0xb9000030		/* PIC_INTEN */

	/*----------*/

	j	ra		/*  ƤӽФإ꥿  */
	nop

#endif /* GDB_STUB */

/*============================================================================*/

/* ߽˴ؤ롢װȽʬΥƥ¸ */

	.align 2
	.section .text
	.global proc_interrupt_sys
	.global int_table	/* ߥϥɥε٥ơ֥
				   cpu_config.h, cpu_config.c */

	/*  ƤӽФ줿Ȥ       */
	/*    a1˥ơ쥸 */
	/*    a2˸쥸       */
	/*  ͤäƤ         */

proc_interrupt_sys:
	and     t2, a2, a1          /*  ׵ӥåȤ˥ޥ򤫤  */
	andi    t3, t2, Cause_IP0   /*  IP0ӥåȼФ  */
	bne     t3, zero, proc_IP0
	andi    t4, t2, Cause_IP1   /*  IP1ӥåȼФ  */
	bne     t4, zero, proc_IP1
	andi    t5, t2, Cause_IP2   /*  IP2ӥåȼФ  */
	bne     t5, zero, proc_IP2
	andi    t6, t2, Cause_IP3   /*  IP3ӥåȼФ  */
	bne     t6, zero, proc_IP3
	andi    t7, t2, Cause_IP4   /*  IP4ӥåȼФ  */
	bne     t7, zero, proc_IP4
	andi    t8, t2, Cause_IP5   /*  IP5ӥåȼФ  */
	bne     t8, zero, proc_IP5
	andi    t9, t2, Cause_IP6   /*  IP6ӥåȼФ  */
	bne     t9, zero, proc_IP6
	nop

	/* ʤ餫θʬǤʤ */
	j       join_interrupt_and_exception
	nop

/*  MIPS3٥ʬ٥Ǥν	*/
/*    װֹt0		*/
/*    ׵᥯ꥢΤt1	*/
/*    set_ICU_IPM				*/
proc_IP7:   /*  װIP7ʥޡˤξ  */
	xori    t1, zero, Cause_IP7
	j       set_ICU_IPM
	ori     t0, zero, INTNO_IP7

proc_IP0:   /*  װIP0ʥեȥ0ˤξ  */
	xori    t1, zero, Cause_IP0
	j       set_ICU_IPM
	ori     t0, zero, INTNO_IP0

proc_IP1:   /*  װIP1ʥեȥ1ˤξ  */
	xori    t1, zero, Cause_IP1
	j       set_ICU_IPM
	ori     t0, zero, INTNO_IP1

proc_IP2:   /*  װIP2ξ  */ 
            /*    ߥȥ¸С¹Ԥ  */
#ifdef PROC_INT0
	PROC_INT0		/* ƥ¸ޥ */
	xori    t1, zero, Cause_IP2
	j       set_ICU_IPM
	nop
#else /* PROC_INT0 */
	xori    t1, zero, Cause_IP2
	j       set_ICU_IPM
	ori     t0, zero, INTNO_IP2
#endif /* PROC_INT0 */

proc_IP3:   /*  װIP3ξ  */ 
            /*    ߥȥ¸С¹Ԥ  */
#ifdef PROC_INT1
	PROC_INT1		/* ƥ¸ޥ */
	xori    t1, zero, Cause_IP3
	j       set_ICU_IPM
	nop
#else /* PROC_INT1 */
	xori    t1, zero, Cause_IP3
	j       set_ICU_IPM
	ori     t0, zero, INTNO_IP3
#endif /* PROC_INT1 */

proc_IP4:   /*  װIP4ξ  */ 
            /*    ߥȥ¸С¹Ԥ  */
#ifdef PROC_INT2
	PROC_INT2		/* ƥ¸ޥ */
	xori    t1, zero, Cause_IP4
	j       set_ICU_IPM
	nop
#else /* PROC_INT2 */
	xori    t1, zero, Cause_IP4
	j       set_ICU_IPM
	ori     t0, zero, INTNO_IP4
#endif /* PROC_INT2 */

proc_IP5:   /*  װIP5ξ  */ 
            /*    ߥȥ¸С¹Ԥ  */
#ifdef PROC_INT3
	PROC_INT3		/* ƥ¸ޥ */
	xori    t1, zero, Cause_IP5
	j       set_ICU_IPM
	nop
#else /* PROC_INT3 */
	xori    t1, zero, Cause_IP5
	j       set_ICU_IPM
	ori     t0, zero, INTNO_IP5
#endif /* PROC_INT3 */

proc_IP6:   /*  װIP6ξ  */ 
            /*    ߥȥ¸С¹Ԥ  */
#ifdef PROC_INT4
	PROC_INT4		/* ƥ¸ޥ */
	xori    t1, zero, Cause_IP6
#else /* PROC_INT4 */
	xori    t1, zero, Cause_IP6
	ori     t0, zero, INTNO_IP6
#endif /* PROC_INT4 */

/*  ߥȥ¸Υޥ  */
set_ICU_IPM:

#ifdef SET_ICU_IPM
	SET_ICU_IPM	/* ߥޥꤹޥ			    */
			/*   ԤȤˤϡˤt0t1Ѥ */
			/*   ˲ʤ褦ˡդʤФʤʤ   */
#endif /* SET_ICU_IPM */

/*
 *  쥸IPӥåȤݻƤƼߤγ׵򥯥ꥢ롣
 *  t1ˤϡ׵ӥåȤȿžΤäƤ롣
 */
	mfc0    t8, Cause
	and     t8, t8, t1
	mtc0    t8, Cause

/*  ơ쥸ΥޥC롼ƤӽФ  */
/*    t0˳װֹ椬ꤵ줿֤Ǥ  */
	la      t3, int_table   /*  ٥ɥ쥹  */
	sll     t4, t0, 3       /*  װֹ8
				      TNT_TABLEϡ
					ϥɥΥɥ쥹(4Х)
					MIPS3γߥޥ(4Х)
				      Ρ8Хȡ */
	add     t5, t3, t4      /*  ٥ɥ쥹򻻽  */
	lw      t6, INT_TABLE_intmask(t5)
           		    	/*  IPM(ߵĥӥå)ɤ߽Ф
				    ߥޥʳͤϡ
					IEӥåȤϥå
					EXLӥåȤϥꥻå
				    ֤ˤʤäƤ롣*/
	lw      t7, (t5)        /*  C롼Ƭɥ쥹ɤ߽Ф  */

	jalr    ra, t7          /*  C롼ƤӽФ  */
	mtc0    t6, Status      /*  ߵġơ쥸Υޥ*/

	mfc0    t0, Status
	ori     t0, t0, SR_EXL  /*  ߶ػߡIEӥåȤͤݻʤФʤ
						ʤΤEXLӥåȤѤ롣*/
	mtc0    t0, Status

	/*  CP0ϥɤΤλֲԤ  */
#ifdef NOP_FOR_CP0_HAZARD
	NOP_FOR_CP0_HAZARD
#endif /* NOP_FOR_CP0_HAZARD */

	j	join_interrupt_and_exception
	nop

