/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN  
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_defs.h,v 1.3 2007/01/15 06:05:22 honda Exp $
 */

/*
 *  ץå˰¸Nios2ѡ
 *
 *  Υ󥯥롼ɥեϡkernel.h  sil.h ǥ󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤ뤳ȤϤʤΥե򥤥
 *  롼ɤˡt_stddef.h  itron.h 󥯥롼ɤΤǡ
 *  ˰¸Ƥ褤
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

#define OMIT_SIL_ACCESS

/*
 *  ǥȿž
 *  sil.hǤƤ뤬OMIT_SIL_ACCESSˤꤳΥե
 *  ؿƤ뤿ᡤ 
 */
#ifndef SIL_REV_ENDIAN_H
#define	SIL_REV_ENDIAN_H(data) \
	((VH)((((UH)(data) & 0xff) << 8) | (((UH)(data) >> 8) & 0xff)))
#endif /* SIL_REV_ENDIAN_H */

#ifndef SIL_REV_ENDIAN_W
#define	SIL_REV_ENDIAN_W(data) \
	((VW)((((UW)(data) & 0xff) << 24) | (((UW)(data) & 0xff00) << 8) \
		| (((UW)(data)>> 8) & 0xff00) | (((UW)(data) >> 24) & 0xff)))
#endif /* SIL_REV_ENDIAN_H */


#ifndef NIOS2
#define NIOS2   /* ץåά */
#endif 
/*
 *  ץå˰¸
 */
#ifndef _MACRO_ONLY

typedef	UINT		INHNO;		/* ߥϥɥֹ */
typedef	UINT		IPM;		/* ߥޥ */
typedef	UINT		EXCNO;		/* CPU㳰ϥɥֹ */


/*
 *  INTNOȳߤζػ/
 */

typedef	UINT		INTNO;		/* ֹ */

extern ER	dis_int(INTNO intno) throw(); 
extern ER	ena_int(INTNO intno) throw();


/*
 *  åȥƥ¸Υӥ
 */
typedef	UD  SYSUTIM;	/* ǽɾѥƥ */
extern  ER  vxget_tim(SYSUTIM *pk_sysutim) throw();


/*
 *  ߵĥӥå
 */
#define STATUS_PIE 0x01

/*
 *  ٤Ƥγߤػ
 */
Inline void
_disint_()
{
    UW status;
    
    Asm("rdctl %0, status" : "=r" (status));
    status &= ~STATUS_PIE;
    Asm("wrctl status, %0" :: "r" (status));
}


/*
 *  ߤ
 */
Inline void
_enaint_()
{
    UW status;

    Asm("rdctl %0, status" : "=r" (status));
    status |= STATUS_PIE;
    Asm("wrctl status, %0" :: "r" (status));
}


/*
 *  ߥå֤
 */
#define SIL_PRE_LOC 
#define SIL_LOC_INT()   _disint_()
#define SIL_UNL_INT()   _enaint_()

/*
 * ƥǽ
 */
Inline void
kernel_abort()
{

}


#endif /* _MACRO_ONLY */

/*
 *  ץåΥǥ
 */
#define SIL_ENDIAN  SIL_ENDIAN_LITTLE 

#ifndef _MACRO_ONLY

/*
 * ꥢؿ
 */

/*
 *  8ӥåñ̤ɽФ
 */
Inline VB
sil_reb_mem(VP mem)
{
  return(__builtin_ldbuio(mem));
}

Inline void
sil_wrb_mem(VP mem, VB data)
{
    __builtin_stbio(mem, data);
}


/*
 *  16ӥåñ̤ɽФ
 */
Inline VH
sil_reh_mem(VP mem)
{
	return(__builtin_ldhuio(mem));
}

Inline void
sil_wrh_mem(VP mem, VH data)
{
    __builtin_sthio(mem, data);
}


#define	sil_reh_lem(mem)	sil_reh_mem(mem)
#define	sil_wrh_lem(mem, data)	sil_wrh_mem(mem, data)

Inline VH
sil_reh_bem(VP mem)
{
	VH	data;

	data = __builtin_ldhuio(mem);
	return(SIL_REV_ENDIAN_H(data));
}

Inline void
sil_wrh_bem(VP mem, VH data)
{
    __builtin_sthio(mem, SIL_REV_ENDIAN_H(data));
}


/*
 *  32ӥåñ̤ɽФ
 */
Inline VW
sil_rew_mem(VP mem)
{
    return(__builtin_ldwio(mem));
}

Inline void
sil_wrw_mem(VP mem, VW data)
{
    __builtin_stwio(mem, data);
}


#define	sil_rew_lem(mem)	sil_rew_mem(mem)
#define	sil_wrw_lem(mem, data)	sil_wrw_mem(mem, data)

Inline VW
sil_rew_bem(VP mem)
{
	VW	data;

	data = __builtin_ldwio(mem);
	return(SIL_REV_ENDIAN_W(data));
}

Inline void
sil_wrw_bem(VP mem, VW data)
{
    __builtin_stwio(mem, SIL_REV_ENDIAN_W(data));
}

/*
 *  Ԥ
 */
Inline void
sil_dly_nse(UINT dlytim)
{
    
}

#endif /* _MACRO_ONLY */


#endif /* _CPU_DEFS_H_ */
