/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_support.S,v 1.2 2004/10/07 17:10:56 honda Exp $
 */

/*
 *  ץå¸⥸塼 ֥PowerPCѡ
 *ͥǻѤ
 */

#define	_MACRO_ONLY
#include "jsp_kernel.h"
#include "offset.h"

/*
 *  TCB¤ΤΥեåȤΥå
 *15ӥåȤ˼ޤäƤʤĥꡢ
 *Ԥưˤʤʤ
 */
#define CHECK_OFFSET(offset)	(((offset)&~0x8fff) != 0)
#if CHECK_OFFSET(TCB_pc) || CHECK_OFFSET(TCB_sp) 		\
    || CHECK_OFFSET(TCB_enatex) || CHECK_OFFSET(TCB_texptn) 	\
    || CHECK_OFFSET(TCB_tinib) || CHECK_OFFSET(TINIB_task) 	\
    || CHECK_OFFSET(TINIB_exinf) 
	ǥѥ륨顼
#endif


/*
 *㳰Ⱦ򤹤쥸
 *ѥ쥸gpr0-1,3-12
 *ü쥸LR,CTR,XER,SRR0,SRR1
 */
#define NUM_REG			17

/*  쥸򤹤ΤɬפʥХȿ  */
#define GPR0_12_SPRG_AREA_SIZE  (NUM_REG*4 + 4)  
		/*  +4㳰װֹ¸륹ڡ  */
		/*  ա4ХȶˤʤäƤ  */

#define GPR13_31_AREA_SIZE      (19*4)  /*  gpr13-31  */

    /*
     *
     *MPC860ư쥸ʤᡢʬ
     *ƥȤƤʤ
     */
#ifdef SUPPORT_FLOATING_POINT_REG
/*  ϡɥư쥸Ƥ  */
#define FPR_AREA_SIZE       (32*8+8)    /*  fpr0-31,FPSCR  */
#define FPR0_13_AREA_SIZE   (14*8+8)    /*  fpr0-14,FPSCR  */
#define FPR14_31_AREA_SIZE  (18*8)      /*  fpr15-31  */

#else   /*  SUPPORT_FLOATING_POINT_REG  */
/*  ϡɥư쥸Ƥʤ  */
#define FPR_AREA_SIZE       0           /*  fpr0-31,FPSCR  */
#define FPR0_13_AREA_SIZE   0           /*  fpr0-14,FPSCR  */
#define FPR14_31_AREA_SIZE  0           /*  fpr15-31  */
#endif  /* SUPPORT_FLOATING_POINT_REG */    

/*
 *  ߡCPU㳰ջΥ쥸
 *
 *ư쥸ϥǥѥåƤӽФȤ
 *ʥåβǽȤˤΤ߹Ԥ
 *ߥϥɥCPU㳰ϥɥư쥸
 *Ѥϡƥϥɥư쥸
 *Ԥȡ
 *
 *r4SRR1CPU㳰ȯCPUåȽ̤ˤѤ롣
 *
 */
#define SAVE_GPR0_12_SPRG                   \
    subi    sp, sp, GPR0_12_SPRG_AREA_SIZE; \
    stw     r0, 0*4(sp);                    \
    stw     r3, 1*4(sp);                    \
    stw     r4, 2*4(sp);                    \
    stw     r5, 3*4(sp);                    \
    stw     r6, 4*4(sp);                    \
    stw     r7, 5*4(sp);                    \
    stw     r8, 6*4(sp);                    \
    stw     r9, 7*4(sp);                    \
    stw     r10, 8*4(sp);                   \
    stw     r11, 9*4(sp);                   \
    stw     r12,10*4(sp);                   \
    mfspr   r3, SRR0;                       \
    stw     r3, 11*4(sp);                   \
    mfspr   r4, SRR1;                       \
    stw     r4, 12*4(sp);                   \
    mfspr   r5, LR;                         \
    stw     r5, 13*4(sp);                   \
    mfspr   r6, CTR;                        \
    stw     r6, 14*4(sp);                   \
    mfcr    r7;             /*  CR  */      \
    stw     r7, 15*4(sp);                   \
    mfspr   r8, XER;                        \
    stw     r8, 16*4(sp)


/*  
 *  ߡCPU㳰ջΥ쥸
 *  gpr0-1,3-12, ü쥸
 *  
 *  ǥѥåƤӽФʤ
 */
#define LOAD_R0_12_SPRG                         \
    /*  ü쥸  */                  \
    lwz     r3, 11*4(sp);                       \
    mtspr   SRR0, r3;                           \
    lwz     r4, 12*4(sp);                       \
    mtspr   SRR1, r4;                           \
    lwz     r5, 13*4(sp);                       \
    mtspr   LR, r5;                             \
    lwz     r6, 14*4(sp);                       \
    mtspr   CTR, r6;                            \
    lwz     r7, 15*4(sp);                       \
    mtcr    r7;             /*  CR  */          \
    lwz     r8, 16*4(sp);                       \
    mtspr   XER, r8;                            \
    /*  ѥ쥸gpr0-1,3-12  */       \
    lwz     r0, 0*4(sp);                        \
    lwz     r3, 1*4(sp);                        \
    lwz     r4, 2*4(sp);                        \
    lwz     r5, 3*4(sp);                        \
    lwz     r6, 4*4(sp);                        \
    lwz     r7, 5*4(sp);                        \
    lwz     r8, 6*4(sp);                        \
    lwz     r9, 7*4(sp);                        \
    lwz     r10, 8*4(sp);                       \
    lwz     r11, 9*4(sp);                       \
    lwz     r12, 10*4(sp)
    /*  ޥޤ  */


/*
 *  CPU㳰⡢㳰٥֤Ⱦʬ
 *  
 *  ޥ
 *  exc_no㳰ֹ
 *  
 *  쥸
 *  SPRG2exc_tableCPU㳰٥ơ֥Ƭɥ쥹
 *  CTRC롼Ƭɥ쥹
 *  r3CPU㳰ϥɥΰ
 *  r4SRR1Υԡ
 */
#define MAKE_EXCEPTION_ENTRY(exe_no)                            \
    SAVE_GPR0_12_SPRG;  /*  å쥸  */        \
                        /*  r4SRR1ԡ  */      \
    mr  r3, sp;         /*  CPU㳰ϥɥΰ  */       \
    /*  C롼Ƭɥ쥹  */                     \
    mfspr   r5, SPRG2;  /*  r5SPRG2exc_table  */            \
                        /*  ٥ơ֥ɤ߽Ф  */      \
    lwz     r6, (exe_no<<2)(r5);                                \
    li      r7, exe_no; /*  㳰װֹ¸  */              \
    stw     r7, NUM_REG*4(sp)    /*  (cpu_experr()ǻ)  */

/*
 *  CPU㳰⡢㳰٥֤ʤ
 *  Ⱦʬؤʬ
 *  
 *  㳰٥֤ˤäƤb̿ˤʬ0x07ff,ffffˤ
 *  Ϥʤ礬롣ξϤꤷʬ롣
 */
#ifdef ABSOLUTE_JUMP_EXC_ENTRY
#define JUMP_EXC_ENTRY(label)			\
		LI32(r8, label);		\
		mtctr r8;			\
		bctr

#else	/*  ABSOLUTE_JUMP_EXE_ENTRY  */
#define JUMP_EXC_ENTRY(label)	b label
#endif	/*  ABSOLUTE_JUMP_EXE_ENTRY  */

/*  
 *   㳰٥
 */   

#ifndef IBM_PPC_EMB_ENV
/*  
 *   ꥸʥPowerPCƥξ
 *   ȥMPC꡼IPM PowerPC6xx/7xx꡼
 *   ˳롣
 */   

/*
 *  㳰٥ơ֥Ƭɥ쥹
 *  ޥ󥹥ơ쥸MSRIPӥåȤ
 *  0ΤȤ0x0000,0000
 *  1ΤȤ0xfff0,0000
 * ΥեåȤˤʤ
 */
#define EXCEPTION_VECTOR_BASE   0x100

/*
 *  ƥꥻå㳰
 */
    .section ".exception_vector","rxai"
    .align 2
    .org 0x100 - EXCEPTION_VECTOR_BASE

System_reset_exception:
    JUMP_EXC_ENTRY(start)               /*  ȥåץ롼  */

/*
 *  ޥ󡦥å㳰
 */
    .org 0x200 - EXCEPTION_VECTOR_BASE

Machine_check_exception:
    MAKE_EXCEPTION_ENTRY(EXC_NO_MACHINE_CHECK)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  DSI㳰
 *  ǡꡦ
 *  ǡTLB顼ߥ
 */
    .org 0x300 - EXCEPTION_VECTOR_BASE

DSI_exception:
    MAKE_EXCEPTION_ENTRY(EXC_NO_DSI)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  ISI㳰
 *  ̿եå
 *  ̿TLB顼ߥ
 */
    .org 0x400 - EXCEPTION_VECTOR_BASE

ISI_exception:
    MAKE_EXCEPTION_ENTRY(EXC_NO_ISI)
    JUMP_EXC_ENTRY(Exception_Entry)


/*
 *  
 *  ٤ƤγߤƱϤʬ
 */
    .org 0x500 - EXCEPTION_VECTOR_BASE

External_interrupt:
    SAVE_GPR0_12_SPRG           /*  쥸  */
    /*
     *  Ϥ³νԤ0x100Хȡ64̿˸
     *  饤㳰ν뤿ᡢ³External_interrupt_1:ǹ
     *  
     */
    JUMP_EXC_ENTRY(External_interrupt_1)

/*
 *  饤㳰
 */
    .org 0x600 - EXCEPTION_VECTOR_BASE

Alignment_exception:
    MAKE_EXCEPTION_ENTRY(EXC_NO_ALIGNMENT)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  ץ㳰
 *  Floating point enabled
 *  Illegal instruction
 *  Privileged instruction
 *  Trap instruction
 */
    .org 0x700 - EXCEPTION_VECTOR_BASE

Program_exception:
    MAKE_EXCEPTION_ENTRY(EXC_NO_PROGRAM)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  ưԲ
 */
    .org 0x800 - EXCEPTION_VECTOR_BASE

Floating_point_unavailable:
    MAKE_EXCEPTION_ENTRY(EXC_NO_FLOATING_POINT_UNAVAILABLE)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  ǥ㳰
 */
    .org 0x900 - EXCEPTION_VECTOR_BASE

Decrementer_exception:
    MAKE_EXCEPTION_ENTRY(EXC_NO_DECREMENTER)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  ץơͭ㳰0x00a00
 */
#ifdef IMPLEMENT_EXCEPTION_00A00
    .org 0xa00 - EXCEPTION_VECTOR_BASE

Implementation_exception_00a00:
    MAKE_EXCEPTION_ENTRY(EXC_NO_IMPLEMENT_EXCEPTION_00A00)
    JUMP_EXC_ENTRY(Exception_Entry)

#endif /* IMPLEMENT_EXCEPTION_00A00 */


/*
 *  ƥॳ
 */
    .org 0xc00 - EXCEPTION_VECTOR_BASE

System_call:
    MAKE_EXCEPTION_ENTRY(EXC_NO_SYSTEM_CALL)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  ȥ졼ʥץ
 */
    .org 0xd00 - EXCEPTION_VECTOR_BASE

Trace_exception:
    MAKE_EXCEPTION_ENTRY(EXC_NO_TRACE)
    JUMP_EXC_ENTRY(Exception_Entry)


/*
 *  ư
 */
    .org 0xe00 - EXCEPTION_VECTOR_BASE

Floating_point_assist:
    MAKE_EXCEPTION_ENTRY(EXC_NO_FLOATING_POINT_ASSIST)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  ץơѤν 0x01000-0x2ffff
 *    ץơͭ㳰٥ʣĤȤϸ¤ʤˤ
 *    ¾Ӥ˻Ѥ
 */
#ifdef IMPLEMENT_EXCEPTION_01000_PROC
    .org 0x1000 - EXCEPTION_VECTOR_BASE

    IMPLEMENT_EXCEPTION_01000_PROC
    
#endif /* IMPLEMENT_EXCEPTION_01000_PROC */

#else	/*  IBM_PPC_EMB_ENV  */

/*  
 *   The IBM PowerPC Embedded Environmentξ
 *   IBMPowerPC40x꡼б
 */   

/*
 *  㳰٥ơ֥Ƭɥ쥹
 *    The IBM PowerPC Embedded Environmentξ
 *  㳰٥Ƭɥ쥹EVPR쥸ꤹ
 *  ޥ󥹥ơ쥸MSRIPӥåȤʤ
 */
#define EXCEPTION_VECTOR_BASE   0x100

/*
 *  Critical Interrupt
 *  եåȡ0x100
 *  Critical Interruptϥץơ¸ʤΤ
 *  ƤϥޥƤ
 *  ޥ̾CRITICAL_INTERRUPT_EXCEPTION_PROC
 *  νƤ0x100ХȤĶƤϤʤ
 *  ĶϻĤʬ̤ξ֤ơ
 *  ʬ뤳ȡ
 *
 *  Critical Interruptϥͥ㳰Ȥ롣
 *  ʤν롼ǥӥѤʤ
 *
 *㳰饹Critical
 *  ꥿̿rfci(Return From Critical Interrupt)
 *  Ѥ롣
 */
    .section ".exception_vector","rxai"
    .align 2
    .org 0x100 - EXCEPTION_VECTOR_BASE

Critical_Interrupt_exception:
    CRITICAL_INTERRUPT_EXCEPTION_PROC
    /*  ա꥿̿rfci(Return From Critical Interrupt)  */

/*
 *  ޥ󡦥å㳰
 *  νƤ0x100ХȤĶƤϤʤ
 *  ĶϻĤʬ̤ξ֤ơ
 *  ʬ뤳ȡ
 *
 *  ͥ㳰Ȥ롣
 *  ʤν롼ǥӥѤʤ
 *
 *㳰饹Critical
 *  ꥿̿rfci(Return From Critical Interrupt)
 *  Ѥ롣
 */
    .org 0x200 - EXCEPTION_VECTOR_BASE

Machine_check_exception:
    MACHINE_CHECK_PROC

/*
 *  Data storage㳰
 *  ǡꡦ
 */
    .org 0x300 - EXCEPTION_VECTOR_BASE

DSI_exception:
    MAKE_EXCEPTION_ENTRY(EXC_NO_DATA_STORAGE)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  Instruction storage㳰
 *  ̿եå
 */
    .org 0x400 - EXCEPTION_VECTOR_BASE

ISI_exception:
    MAKE_EXCEPTION_ENTRY(EXC_NO_INSTRUCTION_STORAGE)
    JUMP_EXC_ENTRY(Exception_Entry)


/*
 *  
 *  ٤ƤγߤƱϤʬ
 */
    .org 0x500 - EXCEPTION_VECTOR_BASE

External_interrupt:
    SAVE_GPR0_12_SPRG           /*  쥸  */
    /*
     *  Ϥ³νԤ0x100Хȡ64̿˸
     *  饤㳰ν뤿ᡢ³External_interrupt_1:ǹ
     *  
     */
    JUMP_EXC_ENTRY(External_interrupt_1)

/*
 *  饤㳰
 */
    .org 0x600 - EXCEPTION_VECTOR_BASE

Alignment_exception:
    MAKE_EXCEPTION_ENTRY(EXC_NO_ALIGNMENT)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  ץ㳰
 *  Illegal instruction
 *  Privileged instruction
 *  Trap instruction
 *  Floating point enabled
 *  Floating point unimplemented
 *  Auxiliary processor unavailable
 *  Auxiliary processor enabled
 */
    .org 0x700 - EXCEPTION_VECTOR_BASE

Program_exception:
    MAKE_EXCEPTION_ENTRY(EXC_NO_PROGRAM)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  ưԲ
 */
#ifdef SUPPORT_IBM_PPC_EMB_APU	/*  APUĵѲǽ  */
    .org 0x800 - EXCEPTION_VECTOR_BASE

Floating_point_unavailable:
    MAKE_EXCEPTION_ENTRY(EXC_NO_FLOATING_POINT_UNAVAILABLE)
    JUMP_EXC_ENTRY(Exception_Entry)

#endif /* SUPPORT_IBM_PPC_EMB_APU */


/*
 *  ƥॳ
 */
    .org 0xc00 - EXCEPTION_VECTOR_BASE

System_call:
    MAKE_EXCEPTION_ENTRY(EXC_NO_SYSTEM_CALL)
    JUMP_EXC_ENTRY(Exception_Entry)

/*
 *  ץơѤνʥեå 0xd00-0xff0
 *    ץơͭ㳰٥
 *    
 *  եåȤλˡդ뤳ȡ
 *  Ūˤ
 *     .org եå - EXCEPTION_VECTOR_BASE
 *  Τ褦˻ꤹ롣ܤ¾㳰װγĽ򻲾ȡ
 *    㤨СPowerPC405Ǥϥեå0xf20
 *    APU Unavailable㳰ν֤
 */
#ifdef IMPLEMENT_EXCEPTION_D00_PROC

    IMPLEMENT_EXCEPTION_D00_PROC
    
#endif /* IMPLEMENT_EXCEPTION_D00_PROC */

/*
 *  Programmable Interval timer
 *  0x10ХȤΰ褬ƤƤʤΤ
 */
    .org 0x1000 - EXCEPTION_VECTOR_BASE

Programmable_Interval_timer:
	PROGRAMMABLE_INTERVAL_TIMER_PROC

/*
 *  Fixed Interval timer
 *  0x10ХȤΰ褬ƤƤʤΤ
 */
    .org 0x1010 - EXCEPTION_VECTOR_BASE

Fixed_Interval_timer:
	FIXED_INTERVAL_TIMER_PROC

/*
 *  Watchdog timer
 *  եåȡ0x1020
 *
 *㳰饹Critical
 *  ꥿̿rfci(Return From Critical Interrupt)
 *  Ѥ롣
 *
 *  0x10ХȤΰ褬ƤƤʤΤ
 *  ͥ㳰Ȥ롣
 *  ʤν롼ǥӥѤʤ
 */
    .org 0x1020 - EXCEPTION_VECTOR_BASE

Watchdog_timer:
	WATCHDOG_TIMER_PROC

/*
 *  Data TLB miss
 *  0x10ХȤΰ褬ƤƤʤΤ
 */
    .org 0x1100 - EXCEPTION_VECTOR_BASE

Data_TLB_miss:
	DATA_TLB_MISS_PROC

/*
 *  Instruction TLB miss
 *  0x10ХȤΰ褬ƤƤʤΤ
 */
    .org 0x1200 - EXCEPTION_VECTOR_BASE

Instruction_TLB_miss:
	INSTRUCTION_TLB_MISS_PROC

/*
 *  Debug㳰
 *  եåȡ0x2000
 *
 *㳰饹Critical
 *  ꥿̿rfci(Return From Critical Interrupt)
 *  Ѥ롣
 *  
 *  װϰʲ7
 *  Trap
 *  Instruction address compare
 *  Data address compare
 *  Instruction complete
 *  Branch taken
 *  Exception
 *  Unconditional debug event
 *  
 *  ͥ㳰Ȥ롣
 *  ʤν롼ǥӥѤʤ
 *  
 *  0x10ХȤΰ褬ƤƤʤΤ
 */
    .org 0x2000 - EXCEPTION_VECTOR_BASE

Debug_exception:
	DEBUG_PROC


/*
 *  ץơѤνʥեå 0x2010-0x2ff0
 *    ץơͭ㳰٥ʣĤȤϸ¤ʤˤ
 *    ¾Ӥ˻Ѥ
 *    
 *  եåȤλˡդ뤳ȡ
 *  Ūˤ
 *     .org եå - EXCEPTION_VECTOR_BASE
 *  Τ褦˻ꤹ롣ܤ¾㳰װγĽ򻲾ȡ
 */
#ifdef IMPLEMENT_EXCEPTION_02010_PROC

    IMPLEMENT_EXCEPTION_02010_PROC
    
#endif /* IMPLEMENT_EXCEPTION_01000 */


/*
 *  System reset
 *    ꥻåȥ٥0xffff,fffcϤ˸ꤵƤ
 */
    .section ".system_reset_vector","rxai"
    .align 2
    
/*  ιԤ(0xffff,fffc - 4Хȡ4̿)Ϥ֤롣  */
jump_to_start:    
    LI32(r8, start)
    mtctr	r8
    bctrl

/*  ιԤ0xffff,fffcϤ֤롣  */
reset_vector:
    b		jump_to_start
    /*  ˤ1̿ᤷʤΤʬ֤̿  */
    /*  start롼ؤʬϾ嵭jump_to_startǹԤ  */


#endif	/*  IBM_PPC_EMB_ENV  */




/*
 *  CPU㳰롼³
 *㳰װˤ餺̤ν
 *㳰٥ήơĤν򤳤ǹԤ
 *ץåѥ쥸ü쥸
 *C롼
 *      Ƭɥ쥹
 *      
 *Ѥ֤Ǥ
 *
 *  쥸ơʤ٤Ѥߤξ֤Ǥ
 *  SPRG0ߡ㳰Υͥȥ
 *  SPRG2exc_tableCPU㳰٥ơ֥Ƭɥ쥹
 *  r3CPU㳰ϥɥΰ
 *  r4SRR1Υԡ
 *  r6C롼Ƭɥ쥹
 *
 *  regflg å˳ߤػߤʤȡreqflg å
 *  ˵ư줿ߥϥɥǥǥѥå׵ᤵ줿ˡ
 *  ǥѥåʤ
 *  
 *  㳰٥textPCʬϤʤʤäȤΤᡢ
 *  Exception_Entry򥰥ХƤ롣
 *
 */

    .text
    .align 2
#ifdef ABSOLUTE_JUMP_EXC_ENTRY
    .global Exception_Entry
#endif	/*  ABSOLUTE_JUMP_EXC_ENTRY  */
    
Exception_Entry:
    mtctr   r6;         /*  CTRC롼Ƭɥ쥹 */
    /*  ߥͥȥ󥿤Υ󥯥  */
    mfspr   r8, SPRG0   /*  SPRG0:ߡ㳰ͥȥ  */
    addi    r8, r8, 1
    mtspr   SPRG0, r8

    /*  CPU㳰ȯΥƥȤȽ  */
    cmpwi   crf0, r8, 1
    bne     exception_from_int

    /*  ʤCPU㳰ξ  */
exception_from_task:
    /*
     *  󥰡٥󥷥˹碌ơåݥ󥿤
     *8ХȤ餷Ƥ
     *
     *         -8  ----------------------
     *            |      task sp         |
     *         -4  ----------------------
     *            |                      |C롼θƤӽФˤ
     * STACKTOP  ----------------------   񤭹ޤ
     *  
     */
    LI32(r9, STACKTOP-STACK_MARGIN)
    stw     sp, 0(r9)     /*  åݥ󥿤¸  */
    mr      sp, r9        /*  åڤؤ  */


/*
 *  ޥCPU㳰ϥɥθƽФ
 *  ʤ㳰¿㳰ζ̽
 *  
 *  
 *  C롼ƤӽФ
 *  
 *  
 *    label٥뼱ʸ
 *    ʣսǤΥޥѤǤ褦ˤ뤿
 *  
 *  
 *   r3=C롼ΰ
 *   r4=SRR1
 *   CTR=C롼Ƭɥ쥹
 *  ξ֤ǻѤ
 *  
 *  
 *  CPU㳰ϥɥεưˤꡢCPUå֤ѹƤϤʤ
 *  ĤޤꡢCPU㳰ȯCPUå֤ǤСCPUå֤
 *  ޤޡCPU㳰ϥɥư롣
 *  CPU㳰ȯCPUå֤ǤСCPUå֤
 *  ޤޡCPU㳰ϥɥư롣
 *  
 */
#define _CALL_EXCEPTION_ROUTINE(label)                                  \
    andi.   r6, r4, MSR_EE;   /*  r4SSR1Υԡ  */                  \
    /* ̤ʤСCPUå֤äʤ */                   \
    /*  EQե饰åȤCPUå֤ʤʬ  */         \
    bne     exception_from_cpu_unlock_##label;                          \
                                                                        \
    /*  CPU㳰ȯCPUå֤ä  */                      \
    /*  CPUå֤ΤޤޡCPU㳰ϥɥƤӽФ  */              \
    /*  C롼󤫤Ϥ  */                         \
    LI32(r7, exit_CALL_EXCEPTION_ROUTINE_##label);                      \
    mtspr   LR, r7;                                                     \
    bctr;               /*  C롼ƤӽФ  */                   \
    /* exit_CALL_EXCEPTION_ROUTINE_##labelϤäƤ   */         \
                                                                        \
    /*  CPU㳰ȯCPUå֤ä  */                  \
exception_from_cpu_unlock_##label:;                                     \
    mfmsr   r10;                                                        \
    ori     r11, r10, MSR_EE;   /*  EEӥåȤ򥻥å  */                \
    mtmsr   r11;                /*  ߵ  */                      \
    bctrl;                      /*  C롼ƤӽФ  */           \
    mfmsr   r10;                                                        \
    xori    r11, r10, MSR_EE;   /*  EEӥåȤ򥯥ꥢ  */                \
    mtmsr   r11;                /*  ߶ػ (a)  */                  \
exit_CALL_EXCEPTION_ROUTINE_##label:     /*  ޥνи٥  */  
    

/* ޥlabelμ¤˥ޥŸ뤿ᡢޥ2ŤˤƤ */
#define CALL_EXCEPTION_ROUTINE(label)   _CALL_EXCEPTION_ROUTINE(label)
    
    /*  C롼ƤӽФ  */
    CALL_EXCEPTION_ROUTINE(exception_from_task)
    /*
     *  ߶ػߤäƤ
     *㳰ȯCPUåƤ
     *嵭(a)Ԥǳ߶ػߤˤƤ
     */
    li      r0, 0
    mtspr   SPRG0, r0           /*  ߥͥȥ󥿤򥯥ꥢ  */
    lwz     sp, 0(sp)           /*  å  */
    lis     r3, reqflg@ha
    lwz     r4, reqflg@l(r3)    /*  r4=reqflg  */
    cmpwi   crf0, r4, 0         /*  reqflgΥå  */
    beq     ret_to_task_exc /*  ǥѥå׵᤬ʤʬ  */        
    stw     r0, reqflg@l(r3)    /*  reqflgΥꥢ  */
    b       ret_exc             /*  иإ  */
    
/*  ¿㳰ξ  */
exception_from_int: 
    /*
     *  󥰡٥󥷥˹碌ơåݥ󥿤
     *8ХȤ餷Ƥ
     *
     *         -8  ----------------------
     *            |                      |
     *         -4  ----------------------
     *            |                      |C롼θƤӽФˤ
     *       sp  ----------------------   񤭹ޤ
     *  
     */
    subi    sp, sp, STACK_MARGIN

    /*  C롼ƤӽФ  */
    CALL_EXCEPTION_ROUTINE(exception_from_int)
    /*
     *  ߶ػߤäƤ
     *㳰ȯCPUåƤ
     *嵭(a)Ԥǳ߶ػߤˤƤ
     *  
     *  ʬret_to_task_excǤCPU㳰Υ꥿̿rfiˤ
     *  MSRSRR1
     *  ȤʤΤǡΥƥȤȤˤCPU㳰ȯ
     *  ľCPUåå֤
     */
    			/*  åݥ󥿤򸵤᤹ʾ嵭ȡ */
    addi    sp, sp, STACK_MARGIN
    mfspr   r3, SPRG0   /*  SPRG0:ߡ㳰ͥȥ  */
    subi    r3, r3, 1   /*  ߥͥȥ󥿤Υǥ  */
    mtspr   SPRG0, r3
    b       ret_to_task_exc



/*
 *  ߽롼³
 *ߥ٥0x100Хȡ64̿ʬˤʤΤǡ
 *Ĥν򤳤ǹԤ
 *ߥȥ¸ñǤ64̿˼ޤ
 *Τʤθơ˵Ҥ
 *ץåѥ쥸ü쥸
 *Ѥ֤Ǥ
 *
 *  ٤ƤγߤƱϤʬ
 *
 *  SPRG0쥸ߡ㳰Υͥȥ󥿤ȤƻѤ롣
 *
 *  regflg å˳ߤػߤʤȡreqflg å
 *  ˵ư줿ߥϥɥǥǥѥå׵ᤵ줿ˡ
 *  ǥѥåʤ
 *  
 *  㳰٥textPCʬϤʤʤäȤΤᡢ
 *  External_interrupt_1򥰥ХƤ롣
 *
 */

    .text
    .align 2
#ifdef ABSOLUTE_JUMP_EXC_ENTRY
    .global External_interrupt_1
#endif	/*  ABSOLUTE_JUMP_EXC_ENTRY  */

External_interrupt_1:
    /*  ץåΥ쥸ϺѤǤ  */
    
    PUSH_ICU_IPM    /*  ߥȥICUIPM  */
    			/*  IPMΥǡǡˤ餺 */
    			/*  åݥ󥿤4Хȶ  */
    			/*  뤳  */

    /*  ߥͥȥ󥿤Υ󥯥  */
    mfspr   r3, SPRG0   /*  SPRG0:ߡ㳰ͥȥ  */
    addi    r3, r3, 1
    mtspr   SPRG0, r3

    /*  ߸ΥƥȤȽ  */
    cmpwi   crf0, r3, 1
    bne     interrupt_from_int

    /*  ʤγߤξ  */
interrupt_from_task:
    /*
     *  󥰡٥󥷥˹碌ơåݥ󥿤
     *8ХȤ餷Ƥ
     *
     *         -8  ----------------------
     *            |      task sp         |
     *         -4  ----------------------
     *            |                      |C롼θƤӽФˤ
     * STACKTOP  ----------------------   񤭹ޤ
     *  
     */
    LI32(r4, STACKTOP-STACK_MARGIN)  /*  r4=STACKTOP  */
    stw     sp, 0(r4)     /*  åݥ󥿤¸  */
    mr      sp, r4        /*  åڤؤ  */

    /*
     *  ICU¸γ߽ 
     *  
     *  װȽ
     *  ߥޥ
     *  ߵ
     *  C롼ƤӽФ
     *  ߶ػ
     *  ׵ե饰ΥꥢɬפǤС
     */
    PROC_ICU(FROM_TASK)
    /*  ߶ػߤäƤ  */
    
    li      r0, 0
    mtspr   SPRG0, r0           /*  ߥͥȥ󥿤򥯥ꥢ  */
    lwz     sp, 0(sp)           /*  å  */
    POP_ICU_IPM                 /*  ߥȥICUIPM  */
    			        /*  IPMΥǡǡˤ餺 */
    			        /*  åݥ󥿤4Хȶ  */
    			        /*  뤳  */
    lis     r3, reqflg@ha   
    lwz     r4, reqflg@l(r3)    /*  r4=reqflg  */
    cmpwi   crf0, r4, 0         /*  reqflgΥå  */
    beq     ret_to_task_int /*  ǥѥå׵᤬ʤʬ  */        
    stw     r0, reqflg@l(r3)    /*  reqflgΥꥢ  */
    b       ret_int             /*  иإ  */

            
    /*  ¿ųߤξ  */
interrupt_from_int:
    /*
     *  󥰡٥󥷥˹碌ơåݥ󥿤
     *8ХȤ餷Ƥ
     *
     *         -8  ----------------------
     *            |                      |
     *         -4  ----------------------
     *            |                      |C롼θƤӽФˤ
     *       sp  ----------------------   񤭹ޤ
     *  
     */
    subi    sp, sp, STACK_MARGIN

    PROC_ICU(FROM_INT)  /*  ICU¸γ߽  */
    /*  ߶ػߤäƤ  */
    
    			/*  åݥ󥿤򸵤᤹ʾ嵭ȡ */
    addi    sp, sp, STACK_MARGIN
    mfspr   r3, SPRG0   /*  SPRG0:ߡ㳰ͥȥ  */
    subi    r3, r3, 1   /*  ߥͥȥ󥿤Υǥ  */
    mtspr   SPRG0, r3
    POP_ICU_IPM     /*  ߥȥICUIPM  */
    			/*  IPMΥǡǡˤ餺 */
    			/*  åݥ󥿤4Хȶ  */
    			/*  뤳  */
    
    /*  
     *  ǥѥåƤФñ˳߸㳰ȯˤ
     *
     *  rfi̿Ʊ̿ʤΤǡ嵭Υ쥸spβûλ
     *  鸵ΥƥȤ롣
     *  spβû˺ѤǳߵĤˤʤ뿴ۤϤʤ
     *
     *    CPU㳰
     *  CPU㳰Υ꥿̿rfiˤ
     *  MSRSRR1
     *  ȤʤΤǡΥƥȤȤˤCPU㳰ȯ
     *  ľCPUåå֤
     */
ret_to_task_int:
ret_to_task_exc:
    LOAD_R0_12_SPRG     /*  gpr0-1,3-12, ü쥸  */
    addi    sp, sp, GPR0_12_SPRG_AREA_SIZE
    rfi     		/*  ߸  */
    


/*  쥸򤹤ΤɬפʥХȿ  */
                                    /*  gpr13-31,LR  */
#define GPR13_31_LR_AREA_SIZE   (GPR13_31_AREA_SIZE +4)

/*  
 *  ޥѥ쥸gpr13-31
 */

#ifdef USE_MULTIPLE_WORD_LOAD_STORE
    /*  
     *  ɡȥޥץ̿
     *ץơˤäƤϤä٤ʤä
     *ޤΤդɬ
     */

#if SIL_ENDIAN == SIL_ENDIAN_LITTLE
ǥѥ롦顼
ȥ롦ǥ󡦥⡼ɤˤȤˤϵǽʤ
ʥϡɥˤ»
#endif


#define STORE_R13_31                                \
    stmw    r13, 0(sp)    /*  gpr13-31  */

#else   /*  USE_MULTIPLE_WORD_LOAD_STORE  */
#define STORE_R13_31                                \
    stw     r13,  0*4(sp);                          \
    stw     r14,  1*4(sp);                          \
    stw     r15,  2*4(sp);                          \
    stw     r16,  3*4(sp);                          \
    stw     r17,  4*4(sp);                          \
    stw     r18,  5*4(sp);                          \
    stw     r19,  6*4(sp);                          \
    stw     r20,  7*4(sp);                          \
    stw     r21,  8*4(sp);                          \
    stw     r22,  9*4(sp);                          \
    stw     r23, 10*4(sp);                          \
    stw     r24, 11*4(sp);                          \
    stw     r25, 12*4(sp);                          \
    stw     r26, 13*4(sp);                          \
    stw     r27, 14*4(sp);                          \
    stw     r28, 15*4(sp);                          \
    stw     r29, 16*4(sp);                          \
    stw     r30, 17*4(sp);                          \
    stw     r31, 18*4(sp)                           
#endif  /*  USE_MULTIPLE_WORD_LOAD_STORE  */

    /*  ޥޤ  */


/*  
 *  ޥѥ쥸gpr13-31
 */

#ifdef USE_MULTIPLE_WORD_LOAD_STORE
    /*  
     *  ɡȥޥץ̿
     *ץơˤäƤϤä٤ʤä
     *ޤΤդɬ
     */
#define LOAD_R13_31                                 \
    lmw     r13, 0(sp)    /*  gpr13-31  */
    
#else   /*  USE_MULTIPLE_WORD_LOAD_STORE  */
#define LOAD_R13_31                                 \
    lwz     r13,  0*4(sp);                          \
    lwz     r14,  1*4(sp);                          \
    lwz     r15,  2*4(sp);                          \
    lwz     r16,  3*4(sp);                          \
    lwz     r17,  4*4(sp);                          \
    lwz     r18,  5*4(sp);                          \
    lwz     r19,  6*4(sp);                          \
    lwz     r20,  7*4(sp);                          \
    lwz     r21,  8*4(sp);                          \
    lwz     r22,  9*4(sp);                          \
    lwz     r23, 10*4(sp);                          \
    lwz     r24, 11*4(sp);                          \
    lwz     r25, 12*4(sp);                          \
    lwz     r26, 13*4(sp);                          \
    lwz     r27, 14*4(sp);                          \
    lwz     r28, 15*4(sp);                          \
    lwz     r29, 16*4(sp);                          \
    lwz     r30, 17*4(sp);                          \
    lwz     r31, 18*4(sp)
#endif  /*  USE_MULTIPLE_WORD_LOAD_STORE  */

    /*  ޥޤ  */




/*
 *  ǥѥå
 *
 *  dispatch ϡSPRG0 = 0,߶ػ߾֤ǸƤӽФʤФʤʤ
 *  exit_and_dispatch ⡤SPRG0 = 0߶ػ߾֤ǸƤӽФΤ§
 *  Ǥ뤬ͥ뵯ưб뤿ᡤSPRG0 = 1ǸƤӽФ
 *  ˤбƤ롥
 */

    .global dispatch
dispatch:
    /*  å쥸  */
    subi    sp, sp, GPR13_31_LR_AREA_SIZE + FPR14_31_AREA_SIZE
    STORE_R13_31                /*  gpr13-31  */

    mfspr   r7, LR
    stw     r7, GPR13_31_LR_AREA_SIZE - 4(sp)   /*  LR  */

    /*  ư쥸  */
#ifdef SUPPORT_FLOATING_POINT_REG
    /*  ϡɥư쥸Ƥ  */
    /*  ̤ʤ8ХȤ˥饤Ȥ  */    
    stfd    f14,  0*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f15,  1*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f16,  2*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f17,  3*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f18,  4*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f19,  5*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f20,  6*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f21,  7*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f22,  8*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f23,  9*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f24, 10*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f25, 11*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f26, 12*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f27, 13*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f28, 14*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f29, 15*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f30, 16*8+GPR13_31_LR_AREA_SIZE(sp)
    stfd    f31, 17*8+GPR13_31_LR_AREA_SIZE(sp)
#endif  /* SUPPORT_FLOATING_POINT_REG */    

    lis     r3, runtsk@ha
    LI32(r4, dispatch_r)
    lwz     r5, runtsk@l(r3)    /*  r5 = runtsk  */
    stw     sp, TCB_sp(r5)      /*  runtsk->sp =  sp */
    stw     r4, TCB_pc(r5)      /*  runtsk->pc =  dispatch_r */
    b       dispatcher


    /*  ǥѥåνи  */
    /*      åݥ󥿤ϺѤǤ  */
    /*  r10runtskäƸƤФ  */
dispatch_r: 
    /*  å쥸  */

    /*  ư쥸  */
#ifdef SUPPORT_FLOATING_POINT_REG    
    /*  ϡɥư쥸Ƥ  */
    /*  ̤ʤ8ХȤ˥饤Ȥ  */    
    lfd     f14,  0*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f15,  1*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f16,  2*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f17,  3*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f18,  4*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f19,  5*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f20,  6*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f21,  7*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f22,  8*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f23,  9*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f24, 10*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f25, 11*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f26, 12*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f27, 13*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f28, 14*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f29, 15*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f30, 16*8+GPR13_31_LR_AREA_SIZE(sp)
    lfd     f31, 17*8+GPR13_31_LR_AREA_SIZE(sp)
#endif  /* SUPPORT_FLOATING_POINT_REG */    

    /*  ѥ쥸  */
    LOAD_R13_31

    /*  LR  */
    lwz     r7, GPR13_31_LR_AREA_SIZE - 4(sp)
    mtspr   LR, r7

    addi    sp, sp, GPR13_31_LR_AREA_SIZE + FPR14_31_AREA_SIZE

    /*
     *  㳰׵Υå
     *  dispatch_rdispatcherƤӽФ뤿ᡤ
     *  runtskr10äƤ롥
     */                           
    lbz     r4, TCB_enatex(r10)         /*  r10=runtsk  */
    /*
     *  ޥǡΥӥåȥǥmakeoffset.c
     *  BIT_BBBIT_LBǻꤷƤ
     */                                 
    andi.   r5, r4, TCB_enatex_mask     /*  r5 = runtsk->enatex  */
                    /* ̤ʤСEQե饰åȤ */

          /*  㳰ػߤʤdispatch()θƤӽФ  */
    beqlr               /*  LRϤǼƤ  */
    lwz     r6, TCB_texptn(r10)          /*  r6 = runtsk->texptn  */
    cmpwi   crf0, r6, 0
                        /*  㳰׵᤬ʤ */
                        /*  dispatch()θƤӽФ  */
    beqlr               /*  LRϤǼƤ  */

    b       call_texrtn /*  㳰롼ƤӽФ  */
    /*
     *  call_texrtn()餳ˤäƤʤǡdispatch()
     *ƤӽФ=LR쥸ؤϡˤľ롣
     *
     *call_texrtn()θƤӽФˤ(sp+3)(ps+7)ϤƤ
     *˲뤬spΰ֤dispatch()ƤӽФȤƱ
     *ʤΤʤ
     *
     *  sp  ----------------------  
     *       |                      |
     *    +4  ----------------------
     *       |                      |call_texrtn()θƤӽФˤ
     *    +8  ----------------------   񤭹ޤ
     *  
     *  
     *
 *㳰롼ư쥸Ѥ
 *ϡ㳰롼¦ư쥸
 *Ԥȡ
     */


    .global exit_and_dispatch
exit_and_dispatch:
    li      r0, 0
    mtspr   SPRG0, r0           /*  ͥȥ󥿤򥯥ꥢ  */
    
dispatcher:
    /*
     * ˤϳ߶ػߤ뤳
     */
    LOAD_VAL32(r10, schedtsk)   /*  r10 = schedtsk  */
    lis     r5, runtsk@ha
	/*
	 * runtskschedtskΤϣĤΰ̣롣
	 * (1) schedtsk != NULLξ
	 * ̾ΥڤؤԤ
	 * (2) schedtsk == NULLξ
	 * runtskNULLƤ
	 * dispatcher_1ʹߤγԤǳߤꡢ
	 * iget_tid()뤵줿ȤTSK_NONE֤
	 * ˤϡ¹Ծ֤ΥʤˡruntskNULLˤ
	 * ɬפ롣
	 */
    stw     r10, runtsk@l(r5)       /*  runtsk=schedtsk(=r10)  */

    cmpwi   crf0, r10, 0
    beq     dispatcher_1            /*  schedtsk̵гԤ  */

    lwz     r6, TCB_pc(r10)         /*  ¹ԺƳϤФ  */
    mtctr   r6                      /*  CTR<-¹ԺƳ  */
    lwz     sp, TCB_sp(r10)         /*  åݥ󥿤  */
    bctr                            /*  סʲȡ  */

    /*  
     *  ¹ԺƳϤϰʲ3̤
     *  ξr10=runtskǸƤӽФ
     *  ǥѥåνиdispatch_r
     *  ߡ㳰νиret_int_r
     *  ưľ塡activate_r
     */


    /*  
     *¹Ԥ٤ޤԤĽ
     *
     *  󥿥ƥȤڤ괹Τϡȯ
     *  ˤɤΥåȤȤβȡߥϥɥ
     *  ΥǥѥåɻߤȤĤΰ̣롥
     */ 
dispatcher_1:
    LI32(sp, STACKTOP)          /*  åڤؤ  */
    li      r3, 1
    mtspr   SPRG0, r3           /*  ͥȥ󥿡1  */
    
    /*  롼ǻȤѰդƤ  */
    LI32(r4, reqflg)            /*  reqflgΥɥ쥹  */
    li      r0, 0

dispatcher_2:
#ifdef SUPPORT_POWER_MANAGEMENT
                                /*  ϥ⡼ɤ  */    
    /*  
     *  ߵĤȾϥ⡼ɤؤΰܹ
     *  ߤäƤ˳߶ػߤԤ
     *  r0r4Ƥ˲ƤϤʤʤ
     *
     *  
     *      ֳߵġפȡ־ϥ⡼ɤؤΰܹԡפ򥢥ȥߥå˹Ԥ
     *      ʤץåǤϡߤΥߥ󥰤ˤäƤϡֳߵ
     *      ġפȡ־ϥ⡼ɤؤΰܹԡפδ֤ǳߤդƤ
     *      տޤʤǾϥ⡼ɤ˰ܹԤƤޤΤա
     *      ߤˤäƼ¹ԲǽʥƤץå꡼
     *      פޤޤǼ¹Ԥʤʤ롣ʼºݤˤϥ޳ߤˤ
     *      ϥ⡼ɤΤǡԤ֤Ϻ
     *      Ǥ⥿޳߼ǲ롣
     */ 
    SAVE_POWPER
#else   /* SUPPORT_POWER_MANAGEMENT */    
                                /*  ϥ⡼ɤʤ  */    
    mfmsr   r5
    ori     r6, r5, MSR_EE
    mtmsr   r6                  /*  ߵ  */
    /*  ǳߤäơäƤ  */
    mtmsr   r5                  /*  ߶ػ  */
#endif  /* SUPPORT_POWER_MANAGEMENT */    
    lwz     r6, 0(r4)           /*  r6 = reqflg  */
    cmpwi   crf0, r6, 0
               /*  ǥѥå׵᤬ʤХ롼פƬ  */
    beq     dispatcher_2
    stw     r0, 0(r4)           /*  reqflg򥯥ꥢ  */
    mtspr   SPRG0, r0           /*  ͥȥ󥿤򥯥ꥢ  */
    b       dispatcher          /*  ¹ԺƳϤФإ  */

	/*
	 *Ԥľ˹ԤäåؤᤷԤäƤʤ
	 *ǥѥåνиTCBФͤ򥹥åݥ
	 *ꤹΤʤ
	 */



/* 
 *  ߥϥɥ/CPU㳰ϥɥи
 *
 * 褬reqflgåȤƤΤߤˤ롣
 * SPRG0 = 0,߶ػ߾,å쥸¸
 * ֤ǸƤӽФȡ 
 *  
 *  ޤr10runtskͤƤret_int_1˥פ뤳
 */

ret_int:
ret_exc:
    LOAD_VAL32(r5, enadsp)  	/*  r5 = enadsp  */
    LOAD_VAL32(r10, runtsk) 	/*  r10 = runtsk  */
    cmpwi   crf0, r5, 0
    beq     ret_int_1           /*  ǥѥåػߤʤ饸  */
    
    LOAD_VAL32(r5, schedtsk)  	/*  r5 = schedtsk  */
    cmpw    crf0, r5, r10
    beq     ret_int_1           /*  runtsk=schedtskʤ饸  */
    
    
    /*  ĤΥ쥸¸  */

    subi    sp, sp, GPR13_31_AREA_SIZE + FPR_AREA_SIZE
    /*  ѥ쥸  */
    STORE_R13_31                /*  gpr13-31  */

    /*  ư쥸  */
#ifdef SUPPORT_FLOATING_POINT_REG    
    /*  ϡɥư쥸Ƥ  */
    /*  ̤ʤ8ХȤ˥饤Ȥ  */    
    stfd    f0,   0*8+GPR13_31_AREA_SIZE(sp)
    stfd    f1,   1*8+GPR13_31_AREA_SIZE(sp)
    stfd    f2,   2*8+GPR13_31_AREA_SIZE(sp)
    stfd    f3,   3*8+GPR13_31_AREA_SIZE(sp)
    stfd    f4,   4*8+GPR13_31_AREA_SIZE(sp)
    stfd    f5,   5*8+GPR13_31_AREA_SIZE(sp)
    stfd    f6,   6*8+GPR13_31_AREA_SIZE(sp)
    stfd    f7,   7*8+GPR13_31_AREA_SIZE(sp)
    stfd    f8,   8*8+GPR13_31_AREA_SIZE(sp)
    stfd    f9,   9*8+GPR13_31_AREA_SIZE(sp)
    stfd    f10, 10*8+GPR13_31_AREA_SIZE(sp)
    stfd    f11, 11*8+GPR13_31_AREA_SIZE(sp)
    stfd    f12, 12*8+GPR13_31_AREA_SIZE(sp)
    stfd    f13, 13*8+GPR13_31_AREA_SIZE(sp)
    stfd    f14, 14*8+GPR13_31_AREA_SIZE(sp)
    stfd    f15, 15*8+GPR13_31_AREA_SIZE(sp)
    stfd    f16, 16*8+GPR13_31_AREA_SIZE(sp)
    stfd    f17, 17*8+GPR13_31_AREA_SIZE(sp)
    stfd    f18, 18*8+GPR13_31_AREA_SIZE(sp)
    stfd    f19, 19*8+GPR13_31_AREA_SIZE(sp)
    stfd    f20, 20*8+GPR13_31_AREA_SIZE(sp)
    stfd    f21, 21*8+GPR13_31_AREA_SIZE(sp)
    stfd    f22, 22*8+GPR13_31_AREA_SIZE(sp)
    stfd    f23, 23*8+GPR13_31_AREA_SIZE(sp)
    stfd    f24, 24*8+GPR13_31_AREA_SIZE(sp)
    stfd    f25, 25*8+GPR13_31_AREA_SIZE(sp)
    stfd    f26, 26*8+GPR13_31_AREA_SIZE(sp)
    stfd    f27, 27*8+GPR13_31_AREA_SIZE(sp)
    stfd    f28, 28*8+GPR13_31_AREA_SIZE(sp)
    stfd    f29, 29*8+GPR13_31_AREA_SIZE(sp)
    stfd    f30, 30*8+GPR13_31_AREA_SIZE(sp)
    stfd    f31, 31*8+GPR13_31_AREA_SIZE(sp)
    /*  
     * FPSCR  
     *
     *å8ХȻѤΤ̵̤Ǥ뤬
     *stfiwx̿ϥץʤΤ򤷤ʤä
     *ʤޤб̿᤬ʤΤ
     *
     */
    mffs    f0              /*  f0β2ХȢFPSCR  */
                            /*  @(sp+եå)f0  */
    stfd    f0, GPR13_31_AREA_SIZE+FPR0_13_AREA_SIZE-8(sp)
#endif  /* SUPPORT_FLOATING_POINT_REG */    

    LI32(r5, ret_int_r)
                                /*  r10 = runtskǤ  */
    stw     sp, TCB_sp(r10)      /*  runtsk->sp = sp  */
                                /*  åݥ󥿤¸  */
    stw     r5, TCB_pc(r10)     /*  runtsk->pc = ret_int_r  */
                                /*  ʼ¹ԺƳϤ¸  */

    b       dispatcher          /*  ǥѥåƤӽФ  */


 /*  ߡ㳰νиθȾʬ
  *     ret_int
  *     ľܡret_int_1˹ή
  *     ǥѥåͳƤä
  *     2̤ꤢ
  *     ξr10runtskäƤ
  */
ret_int_r:

#ifdef SUPPORT_FLOATING_POINT_REG    
    /*  ϡɥư쥸Ƥ  */

    /*  FPSCR  */
    lfd     f0, GPR13_31_AREA_SIZE+FPR0_13_AREA_SIZE-8(sp)
    mtfsf   0xf,f0          /*  FPSCRf0β2Х  */

    /*  ư쥸  */
    lfd     f0,   0*8+GPR13_31_AREA_SIZE(sp)
    lfd     f1,   1*8+GPR13_31_AREA_SIZE(sp)
    lfd     f2,   2*8+GPR13_31_AREA_SIZE(sp)
    lfd     f3,   3*8+GPR13_31_AREA_SIZE(sp)
    lfd     f4,   4*8+GPR13_31_AREA_SIZE(sp)
    lfd     f5,   5*8+GPR13_31_AREA_SIZE(sp)
    lfd     f6,   6*8+GPR13_31_AREA_SIZE(sp)
    lfd     f7,   7*8+GPR13_31_AREA_SIZE(sp)
    lfd     f8,   8*8+GPR13_31_AREA_SIZE(sp)
    lfd     f9,   9*8+GPR13_31_AREA_SIZE(sp)
    lfd     f10, 10*8+GPR13_31_AREA_SIZE(sp)
    lfd     f11, 11*8+GPR13_31_AREA_SIZE(sp)
    lfd     f12, 12*8+GPR13_31_AREA_SIZE(sp)
    lfd     f13, 13*8+GPR13_31_AREA_SIZE(sp)
    lfd     f14, 14*8+GPR13_31_AREA_SIZE(sp)
    lfd     f15, 15*8+GPR13_31_AREA_SIZE(sp)
    lfd     f16, 16*8+GPR13_31_AREA_SIZE(sp)
    lfd     f17, 17*8+GPR13_31_AREA_SIZE(sp)
    lfd     f18, 18*8+GPR13_31_AREA_SIZE(sp)
    lfd     f19, 19*8+GPR13_31_AREA_SIZE(sp)
    lfd     f20, 20*8+GPR13_31_AREA_SIZE(sp)
    lfd     f21, 21*8+GPR13_31_AREA_SIZE(sp)
    lfd     f22, 22*8+GPR13_31_AREA_SIZE(sp)
    lfd     f23, 23*8+GPR13_31_AREA_SIZE(sp)
    lfd     f24, 24*8+GPR13_31_AREA_SIZE(sp)
    lfd     f25, 25*8+GPR13_31_AREA_SIZE(sp)
    lfd     f26, 26*8+GPR13_31_AREA_SIZE(sp)
    lfd     f27, 27*8+GPR13_31_AREA_SIZE(sp)
    lfd     f28, 28*8+GPR13_31_AREA_SIZE(sp)
    lfd     f29, 29*8+GPR13_31_AREA_SIZE(sp)
    lfd     f30, 30*8+GPR13_31_AREA_SIZE(sp)
    lfd     f31, 31*8+GPR13_31_AREA_SIZE(sp)
#endif  /* SUPPORT_FLOATING_POINT_REG */    

    /*  ѥ쥸  */
    LOAD_R13_31     /*  gpr13-31  */
    addi    sp, sp, GPR13_31_AREA_SIZE + FPR_AREA_SIZE

    /*  ǥѥåͳʤϤή  */
    /*  r10runtskä֤Ǥ  */
ret_int_1:
    /*  㳰׵Υå  */
                                    /*  r10 = runtsk  */
    lbz     r4, TCB_enatex(r10)
    /*
     *  ޥǡΥӥåȥǥmakeoffset.c
     *  BIT_BBBIT_LBǻꤷƤ
     */                                 
    andi.   r5, r4, TCB_enatex_mask /*  r5 = runtsk->enatex  */
                            /* ̤ʤСEQե饰åȤ */
    beq     ret_int_2               /*  㳰ػߤʤ饸  */
    lwz     r6, TCB_texptn(r10)      /*  r6 = runtsk->texptn  */
        /*  㳰׵᤬ʤФʤ饸  */
    cmpwi   crf0, r6, 0
    beq     ret_int_2
    
    /*
     *  󥰡٥󥷥˹碌ơåݥ󥿤
     *8ХȤ餷Ƥ
     *
     *    -8  ----------------------
     *       |                      |
     *    -4  ----------------------
     *       |                      |call_texrtn()θƤӽФˤ
     *  sp  ----------------------   񤭹ޤ
     *  
     */
    subi    sp, sp, STACK_MARGIN

    bl      call_texrtn             /*  㳰롼ƤӽФ  */
		    	     /*  åݥ󥿤򸵤᤹ʾ嵭ȡ */
    addi    sp, sp, STACK_MARGIN
    /*  
     *
 *㳰롼ư쥸Ѥ
 *ϡ㳰롼¦ư쥸
 *Ԥȡ
     */

ret_int_2:
    /*  
     *call_texrtn()餳ä롣(嵭addi̿ͳ
     *call_texrtn()ƤФʤľܤ
     *
 *Ūret_to_task_intƱˤʤä
 *̵ˤޤȤȲʤΤ
 *̡ΤޤޤˤƤ롣
     */
    LOAD_R0_12_SPRG     /*  gpr0-1,3-12, ü쥸  */
    addi    sp, sp, GPR0_12_SPRG_AREA_SIZE
    /*  
     *  rfi̿Ʊ̿ʤΤǡ嵭Υ쥸spβûλ
     *  鸵ΥƥȤ롣
     *  spβû˺ѤǳߵĤˤʤ뿴ۤϤʤ
     */
    rfi     /*  ߸  */




/*
 *  ư
 *  ǥѥå㤫ƤӽФΤǡr10ˤruntskäƤ
 *  åݥ󥿤Ѥ
 */ 

    .globl activate_r
activate_r:
                                    /*  r10 = runtsk (ǥѥå) */
    lwz     r4, TCB_tinib(r10)      /*  r4 = runtsk->tinib  */

                                    /*  ưϤ  */
    lwz     r5, TINIB_task(r4)      
    mtctr   r5                      /*  CTR = runtsk->tinib->task  */

                                    /*  ؤΰʳĥ  */
    lwz     r3, TINIB_exinf(r4)     /*  r3 = runtsk->tinib->TINIB_exinf  */

    /*
     *  LR쥸ext_tskꤹ뤳Ȥˤꡢext_tsk
     *  ƤФʤǥδؿȴext_tskʬ롣
     */                                 
    LI32(r6, ext_tsk)
    mtspr   LR, r6                  /*  Ϥ  */

    mfmsr   r8
    ori     r9, r8, MSR_EE
    mtmsr   r9                      /*  ߵ  */

    bctr                            /*  C롼ƤӽФ  */


/*
 *  Ԥ 
 *r3Ԥ֤nsecñ̤ǻꤹ
 */
    .globl sil_dly_nse
sil_dly_nse:
    LI32(r4, SIL_DLY_TIM1)
    sub.    r3, r3, r4          /* r3 SIL_DLY_TIM1 */
    blelr                       /* ̤0ʲʤ꥿ */

    LI32(r5, SIL_DLY_TIM2)
sil_dly_nse_1:
    sub.    r3, r3, r5          /* r3 SIL_DLY_TIM2 */
    bgt     sil_dly_nse_1       /* ̤ 0 礭Х롼 */
    blr

/*  end of file  */
