/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.h,v 1.4 2015/07/19 11:23:27 ssuzuki Exp $
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  ͥ̾Υ͡
 */
#include <cpu_rename.h>

/*
 *  ץåü̿Υ饤ؿ
 */
#ifndef _MACRO_ONLY
#include <cpu_insn.h>
#endif /* _MACRO_ONLY */

/*
 *  chg_ipm/get_ipm 򥵥ݡȤ뤫ɤ
 */
#define	SUPPORT_CHG_IPM

#ifndef _MACRO_ONLY
/*
 *  ƥȥ֥å
 */
typedef struct task_context_block {
	VP	usp;		/* åݥ */
	FP	pc;		/* ץ५ */
} CTXB;

/*
 *  ߥޥ饤֥
 *
 *  ߥޥintmaskˤϡIPMInterrupt Priority Maskˤ8ӥå
 *  ˥եȤΤǤ롥
 */

/*
 *  ߤγߥޥɽФ
 */
Inline UH
current_intmask()
{
	return(current_psw() & 0x0f000000);
}

/*
 *  ߥޥ
 */
Inline void
set_intmask(UW intmask)
{
	set_psw((current_psw() & ~0x0f000000) | intmask);
}

/*
 *  ƥֻ
 */

Inline BOOL
sense_context()
{
	return((current_psw() & 0x00020000) == 0);
}

Inline BOOL
sense_lock()
{
	return((current_psw() & 0x00010000) == 0x00000000);
}

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

/*
 *  CPUåȤβ
 *
 *  task_intmask ϡchg_ipm 򥵥ݡȤ뤿ѿchg_ipm 򥵥ݡ
 *  Ȥʤˤϡtask_intmask  0 ˤʤäƤȹͤФ褤
 */

#ifdef SUPPORT_CHG_IPM
extern UW	task_intmask;	/* ƥȤǤγߥޥ */
#endif /* SUPPORT_CHG_IPM */

Inline void
lock_cpu()
{
	disint();
}

Inline void
unlock_cpu()
{
	enaint();
}

#define t_lock_cpu	lock_cpu
#define i_lock_cpu	lock_cpu
#define t_unlock_cpu	unlock_cpu
#define i_unlock_cpu	unlock_cpu

/*
 *  ǥѥå
 */

/*
 *  ǹ̥ͥؤΥǥѥåcpu_support.S
 *
 *  dispatch ϡƥȤƤӽФ줿ӥ
 *  ǡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	dispatch(void);

/*
 *  ߤΥƥȤΤƤƥǥѥåcpu_support.S
 *
 *  exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	exit_and_dispatch(void);

/*
 *  ߥϥɥ顿CPU㳰ϥɥ
 */

/*
 *  㳰٥ơ֥ι¤
 */
typedef struct exc_vector_entry {
	FP	exchdr;			/* 㳰ϥɥεư */
} EXCVE;

/*
 *  ߥϥɥ
 *
 *  ٥ȥֹ inhno γߥϥɥεưϤ inthdr ꤹ롥
 */
Inline void
define_inh(INHNO inhno, FP inthdr)
{
	EXCVE	*excvt;

	excvt = (EXCVE *) current_intb();
	excvt[inhno].exchdr = inthdr;
}

/*
 *  CPU㳰ϥɥ
 *
 *  ٥ȥֹ excno CPU㳰ϥɥεưϤ exchdr ꤹ롥
 */
Inline void
define_exc(EXCNO excno, FP exchdr)
{
	define_inh(excno, exchdr);
}

/*
 *  ߥϥɥ顿CPU㳰ϥɥν
 */

/*
 *  ߥϥɥνޥ
 *
 *  reqflg å˳ߤػߤʤȡreqflg å
 *  ˵ư줿ߥϥɥǥǥѥå׵ᤵ줿ˡǥ
 *  ѥåʤ
 */

#define INTHDR_ENTRY(inthdr)		\
extern void inthdr##_entry(void);	\
asm(".text				\n" \
".globl	_" #inthdr "_entry		\n" \
"_" #inthdr "_entry:			\n" \
"	pushm r14-r15			\n" /* å쥸¸ */ \
"	pushm r1-r5			\n" \
"	mvfaclo r1			\n" /* 졼¸ */ \
"	mvfachi r2			\n" \
"	pushm r1-r2			\n" \
"	add #36, r0, r1			\n" /* 㳰ե졼ƬȤ */ \
"	setpsw i			\n" \
"	bsr _" #inthdr "		\n" /* ߥϥɥƤӽФ */ \
"	clrpsw i			\n" \
"	mov.l 40[r0], r1		\n" \
"	btst #17, r1			\n" /* 褬ߥ⡼ɤʤ */ \
"	bz 1f				\n" /*           ˥꥿ */ \
"	mov.l #__kernel_reqflg, r1	\n" /* reqflg  TRUE Ǥ */ \
"	mov.l [r1], r1			\n" \
"	tst r1, r1			\n" \
"	bz 1f				\n" \
"	mov.l r0, r1			\n" \
"	setpsw u			\n" \
"	push.l 40[r1]			\n" /* ߥå PSW  */ \
"	push.l 36[r1]			\n" /* PC 桼å˰ư */ \
"	clrpsw u			\n" \
"	popm r1-r2			\n" /* 졼 */ \
"	mvtaclo r1			\n" \
"	mvtachi r2			\n" \
"	popm r1-r5			\n" /* å쥸 */ \
"	popm r14-r15			\n" \
"	add #8, r0			\n" \
"	bra _kernel_ret_int		\n" /*               ret_int  */ \
"1:	popm r1-r2			\n" /* 졼 */ \
"	mvtaclo r1			\n" \
"	mvtachi r2			\n" \
"	popm r1-r5			\n" /* å쥸 */ \
"	popm r14-r15			\n" \
"	rte				\n")

/*
 *  CPU㳰ϥɥνޥ
 */

#define	EXCHDR_ENTRY(exchdr)	INTHDR_ENTRY(exchdr)

#endif /* _MACRO_ONLY */

/*  CѤΥ٥  */
#define INT_ENTRY(inthdr)	inthdr##_entry
#define	EXC_ENTRY(exchdr)	exchdr##_entry
/*  ֥ѤΥ٥  */
#define INT_ENTRY_ASM(inthdr)	_inthdr##_entry
#define	EXC_ENTRY_ASM(exchdr)	exchdr##_entry

#ifndef _MACRO_ONLY

/*
 *  CPU㳰ȯΥƥȤλ
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
	return((*((UW *) p_excinf + 1) & 0x00020000) == 0);
}

/*
 *  CPU㳰ȯCPUå֤λ
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	return((*((UW *) p_excinf + 1) & 0x00010000) == 0x00000000);
}

/*
 *  ץå¸ν
 */
extern void	cpu_initialize(void);

/*
 *  ץå¸νλ
 */
extern void	cpu_terminate(void);

/*
 *  ̤ȯΥ顼ϻΥå¤
 */

typedef struct exc_stack {
	UW	acclo;
	UW	acchi;
	UW	r1;
	UW	r2;
	UW	r3;
	UW	r4;
	UW	r5;
	UW	r6;
	UW	r7;
	UW	r8;
	UW	r9;
	UW	r10;
	UW	r11;
	UW	r12;
	UW	r13;
	UW	r14;
	UW	r15;
	UW	pc;	/*  ץࡦ  		*/
	UW	psw;	/*  ץåơ	*/
} EXCSTACK;

/*
 * ̤ȯΥ顼 (cpu_config.c, cpu_support.S)
 */

extern void     cpu_experr(EXCSTACK *sp) throw();

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */
