/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_timer.h,v 1.6 2015/07/20 15:10:08 ssuzuki Exp $
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>
#include <rx63n.h>

/*
 *  ޳ߥϥɥΥ٥ֹ
 */
#define	INHNO_TIMER	28

#ifndef _MACRO_ONLY

/*
 *  ͤɽη
 */
typedef UW	CLOCK;

/*
 *  ͤɽȥߥáñ̤ȤѴ
 */
#define	TIMER_CLOCK		((PCLK / 8) / 1000)
#define	TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define	TO_USEC(clock)		((clock) * 1000 / TIMER_CLOCK)

/*
 *  ޤθͤȯͤȤߤʤȽ
 */
#define	GET_TOLERANCE	100	/* ٤θѤ͡ñ̤ɽ*/
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 * ڥޥåޥȥ쥸0(CMSTR0)Υӥå
 */
#define	CMSTR0_STR0	(0x0001)
#define	CMSTR0_STR1	(0x0002)

/*
 * ڥޥåȥ쥸(CMCR)Υӥå
 */
#define	CMCR_CMIE	(0x0040)
#define	CMCR_CKS1	(0x0002)
#define	CMCR_CKS0	(0x0001)

/*
 * ޳ߤͥ
 */
#define	IPR_CMI0	(0x02)

/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
hw_timer_initialize()
{
	/*
	 *  ޤʬ椪Ӽꤹ롥
	 *  ʬ=8=1ms
	 */
	sil_wrh_mem((VP) RX63N_CMT0_CMCOR, (TIMER_CLOCK	- 1));
	sil_wrh_mem((VP) RX63N_CMT0_CMCR, CMCR_CMIE);

	/*
	 *  ޳ߤγߥ٥ꤷ
	 *  ޥ롥
	 */
	sil_wrb_mem((VP) RX63N_IPR004, IPR_CMI0);
	bitset((VP) RX63N_IER03, 4);

	/*
	 *  ޤư򳫻Ϥ롥
	 */
	sil_wrh_mem((VP) RX63N_CMT0_CMCNT, 0x0000);
	sil_wrh_mem((VP) RX63N_CMSTR0,
		sil_reh_mem((VP) RX63N_CMSTR0) | CMSTR0_STR0);
}

/*
 *  ޳׵Υꥢ
 */
Inline void
hw_timer_int_clear()
{
	/*
	 * CMI0 ߤϥåߤʤΤǡ
	 * ׵դ׵ϥꥢ롣
	 */
}

/*
 *  ޤ߽
 */
Inline void
hw_timer_terminate()
{
	/*
	 *  ޤưߤ롥
	 */
	sil_wrh_mem((VP) RX63N_CMSTR0, 
		sil_reh_mem((VP) RX63N_CMSTR0) & ~CMSTR0_STR0);

	/*
	 *  ޳ߤγߥ٥ꤷ׵򥯥ꥢ塤
	 *  ޥ롥
	 */
	sil_wrb_mem((VP) RX63N_IPR004, 0x00);
	bitclr((VP) RX63N_IER03, 4);
}

/*
 *  ޤθͤɤߤ
 *
 *  ߶ػ߶ǸƤӽФȡ
 */
Inline CLOCK
hw_timer_get_current(void)
{
	return sil_reh_mem((VP) RX63N_CMT0_CMCNT);
}

/*
 *  ޳׵Υå
 */
Inline BOOL
hw_timer_fetch_interrupt(void)
{
	return(sil_reh_mem((VP) RX63N_IR28) != 0);
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
