/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_config.c,v 1.6 2015/07/20 15:12:38 ssuzuki Exp $
 */

/*
 *	åȥƥ¸⥸塼GR-SAKURAѡ
 */

#include <s_services.h>
#include "jsp_kernel.h"
#include "rx63n.h"
#include "rx63nsci.h"

/*
 * ץƥȥ쥸(PRCR)ͤӥӥå
 */
#define	PRCR_KEYVAL	(0xa500)
#define	PRCR_PRC3	(0x0008)
#define	PRCR_PRC1	(0x0002)
#define	PRCR_PRC0	(0x0001)

/*
 * ⥸塼륹ȥåץȥ쥸(MSTPCR*)Υӥå
 */
#define	MSTPCRX_MSTPX31	(0x80000000)
#define	MSTPCRX_MSTPX30	(0x40000000)
#define	MSTPCRX_MSTPX29	(0x20000000)
#define	MSTPCRX_MSTPX28	(0x10000000)
#define	MSTPCRX_MSTPX27	(0x08000000)
#define	MSTPCRX_MSTPX26	(0x04000000)
#define	MSTPCRX_MSTPX25	(0x02000000)
#define	MSTPCRX_MSTPX24	(0x01000000)
#define	MSTPCRX_MSTPX23	(0x00800000)
#define	MSTPCRX_MSTPX22	(0x00400000)
#define	MSTPCRX_MSTPX21	(0x00200000)
#define	MSTPCRX_MSTPX20	(0x00100000)
#define	MSTPCRX_MSTPX19	(0x00080000)
#define	MSTPCRX_MSTPX18	(0x00040000)
#define	MSTPCRX_MSTPX17	(0x00020000)
#define	MSTPCRX_MSTPX16	(0x00010000)
#define	MSTPCRX_MSTPX15	(0x00008000)
#define	MSTPCRX_MSTPX14	(0x00004000)
#define	MSTPCRX_MSTPX13	(0x00002000)
#define	MSTPCRX_MSTPX12	(0x00001000)
#define	MSTPCRX_MSTPX11	(0x00000800)
#define	MSTPCRX_MSTPX10	(0x00000400)
#define	MSTPCRX_MSTPX9	(0x00000200)
#define	MSTPCRX_MSTPX8	(0x00000100)
#define	MSTPCRX_MSTPX7	(0x00000080)
#define	MSTPCRX_MSTPX6	(0x00000040)
#define	MSTPCRX_MSTPX5	(0x00000020)
#define	MSTPCRX_MSTPX4	(0x00000010)
#define	MSTPCRX_MSTPX3	(0x00000008)
#define	MSTPCRX_MSTPX2	(0x00000004)
#define	MSTPCRX_MSTPX1	(0x00000002)
#define	MSTPCRX_MSTPX0	(0x00000001)

/*
 * 񤭹ߥץƥȥ쥸(PWPR)Υӥå
 */
#define	PWPR_B0WI	(0x80)
#define	PWPR_PFSWE	(0x40)

/*
 * P20 üҵǽ쥸(P20PFS)
 */
#define	P20PFS_PSEL_VAL	(0x0a)

/*
 * P21 üҵǽ쥸(P20PFS)
 */
#define	P21PFS_PSEL_VAL	(0x0a)

/*
 * ݡȥ⡼ɥ쥸(PMR)Υӥå
 */
#define	PMR_B7		(0x80)
#define	PMR_B6		(0x40)
#define	PMR_B5		(0x20)
#define	PMR_B4		(0x10)
#define	PMR_B3		(0x08)
#define	PMR_B2		(0x04)
#define	PMR_B1		(0x02)
#define	PMR_B0		(0x01)

/*
 *  åȥƥ¸ 롼
 */
void
sys_initialize()
{
	UW prcr_bak;

	/* MSTPCRA  MSTPCRB 쥸ؤν񤭹ߤĤ */
	prcr_bak = sil_reh_mem((VP) RX63N_PRCR) & 0x00ff;
	sil_wrh_mem((VP) RX63N_PRCR, PRCR_KEYVAL | prcr_bak | PRCR_PRC1);

	/* CMT0 Υȥå׾֤β */
	sil_wrw_mem((VP) RX63N_MSTPCRA,
			sil_rew_mem((VP) RX63N_MSTPCRA) & ~MSTPCRX_MSTPX15);

	/* SCI0 Υȥå׾֤β */
	sil_wrw_mem((VP) RX63N_MSTPCRB,
			sil_rew_mem((VP) RX63N_MSTPCRB) & ~MSTPCRX_MSTPX31);

	/* PFS 쥸ؤν񤭹ߤĤ */
	sil_wrb_mem((VP) RX63N_PWPR, sil_reb_mem((VP) RX63N_PWPR) & ~PWPR_B0WI);
	sil_wrb_mem((VP) RX63N_PWPR, sil_reb_mem((VP) RX63N_PWPR) | PWPR_PFSWE);

	/* üҤ TXDn  RXDn ȤƻѤ */
	sil_wrb_mem((VP) RX63N_P21PFS, P21PFS_PSEL_VAL);
	sil_wrb_mem((VP) RX63N_P20PFS, P20PFS_PSEL_VAL);

	/* PFS 쥸ؤν񤭹ߤػߤ */
	sil_wrb_mem((VP) RX63N_PWPR, sil_reb_mem((VP) RX63N_PWPR) | PWPR_B0WI);
	sil_wrb_mem((VP) RX63N_PWPR, sil_reb_mem((VP) RX63N_PWPR) & ~PWPR_PFSWE);

	/* PRCR.PRC1 ͤ򸵤᤹ */
	sil_wrh_mem((VP) RX63N_PRCR, PRCR_KEYVAL | prcr_bak);

	/* üҤյǽȤƻѤ */
	sil_wrb_mem((VP) RX63N_PORT2_PMR,
			sil_reb_mem((VP) RX63N_PORT2_PMR) | PMR_B1);
	sil_wrb_mem((VP) RX63N_PORT2_PMR,
			sil_reb_mem((VP) RX63N_PORT2_PMR) | PMR_B0);

	/*
	 *  ХʡɽѥꥢݡȤν
	 */
	rx63nsci_initialize();
	rx63nsci_opn_por(1, NULL);
}


/*
 *  åȥƥνλ
 */
void
sys_exit()
{
	while (1) ;
}


/*
 *  åȥƥʸ
 */
void
sys_putc(char c)
{
	if (c == '\n') {
		rx63nsci_snd_chr_pol(LOGTASK_PORTID, '\r');
	}
	rx63nsci_snd_chr_pol(LOGTASK_PORTID, c);
}
