/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 *  Copyright (C) 2010 by Cronus Computer Works, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id
 */

#include "jsp_kernel.h"
#include <sil.h>
#include <s_services.h>
#include "sh726xscif.h"

/*
 *  åȥƥ¸ν
 */
/*
 *  ꥢI/OݡȤν bannerϤΤᥫͥν̵ط˹Ԥ
 */
void
sys_initialize ()
{
	SIOPCB *siopcb;

	/* ѤյϤͭˤƤ */
	/*  SCIFǡϥݡȤ  */

#ifndef GDB_STUB

	/* SCIF2 */
	sil_wrb_mem (STBCR4, (VB) ((VB) sil_reb_mem (STBCR4) & ~0x20));
	sil_wrh_mem (PFCR0, sil_reh_mem (PFCR0) | (0x0400 | 0x0040));
#if TNUM_PORT >=2
	/* SCIF3 */
	sil_wrb_mem (STBCR4, (VB) ((VB) sil_reb_mem (STBCR4) & ~0x10));
	sil_wrh_mem (PFCR1, sil_reh_mem (PFCR1) | 0x0004);
	sil_wrh_mem (PFCR0, sil_reh_mem (PFCR0) | 0x4000);
#endif /*TNUM_PORT >=2 */

#else /* GDB_STUB */

	/* SCIF3 */
	sil_wrb_mem (STBCR4, (VB) ((VB) sil_reb_mem (STBCR4) & ~0x10));
	sil_wrh_mem (PFCR1, sil_reh_mem (PFCR1) | 0x0004);
	sil_wrh_mem (PFCR0, sil_reh_mem (PFCR0) | 0x4000);

#endif /* GDB_STUB */

	/* CMT0 */
	sil_wrb_mem (STBCR7, (VB) ((VB) sil_reb_mem (STBCR7) & ~0x04));
	/*
	 *  ǥХ¸Υץ
	 */
	/*ХʡϤ뤿 */
	sh2scif_initialize();
	siopcb = sh2scif_opn_por (LOGTASK_PORTID, 0);
}

/*
 *  åȥƥνλ
 */
void
sys_exit ()
{
	sh2_exit ();
}

/*
 *  åȥƥʸ
 */
void
sys_putc (char c)
{
	if (c == '\n') {
		sh2_putc (LOGTASK_PORTID, '\r');
	}
	sh2_putc (LOGTASK_PORTID, c);
}

/* ϡɥ */
/* ǤϥХΤ߹Ԥյsys_initializeǹԤ */
#ifndef GDB_STUB
void
hardware_init_hook (void)
{
	/* åȯν */
	sil_wrh_mem (FRQCR, 0x1104);	/* å I=144MHz, B=48MHz, P=24MHz */

	/* I/OݡȤ */
	sil_wrh_mem (PCIOR0, 0x0100);	/* PC8ݡ  (LED³ݡ) */
	sil_wrh_mem (PCCR2, 0x0000);	/* PC8⡼ ݡ (LED³ݡ) */

	/* å */
	sil_wrw_mem (CCR1, 0x00000808);	/* åեå */
	sil_wrw_mem (CCR1, CCR_MODE);	/* å⡼ɤ */
}
#else /*  GDB_STUB  */
void
hardware_init_hook (void)
{
}
#endif /*  GDB_STUB  */
