/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 *  Copyright (C) 2006 by GJ Business Division RICOH COMPANY,LTD. JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *  CPU¸ޥ⥸塼SH7047ѡ
 *  CMT0
 *
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>
#include "crb_h3.h"

/*
 *  ڥޥåޥȥ쥸CMSTRΥӥå
 */
#define CMSTR_STR1	0x0002	/* ȥ1 */
#define CMSTR_STR0  0x0001	/* ȥ0 */

/*
 *  ڥޥåޥȥ롿ơ쥸CMCSRΥӥå
 */
#define CMCSR_CMF   0x0080	/* ڥޥåե饰 */
#define CMCSR_CMIE  0x0040	/* ڥޥåߥ֥͡ */
#define CMCSR_CKS8  0x0000	/* 8ʬå쥯 */

/*
 *  ޳ߥϥɥΥ٥ֹ
 */
#define	INHNO_TIMER	CMI0

/*
 *   ޤ˶뤵륯åȿ[kHz]
 *   	40.000MHz/8 =5.0000MHz =5000.0kHz
 */
#define TIMER_CLOCK     (CLOCK_RATE/8000L)

#ifndef _MACRO_ONLY
/*
 *  ͤɽη
 */
typedef UH CLOCK;

/*
 *  ͤɽȥߥáñ̤ȤѴ
 *
 */
#define	TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define	TO_USEC(clock)		((clock) * 1000 / TIMER_CLOCK)
#define CLOCK_PER_TICK	((CLOCK) TO_CLOCK(TIC_NUME, TIC_DENO))

/*
 *  ǤΥ޼ñ̤ɽ
 */
#define	MAX_CLOCK	((CLOCK) 0xffff)

/*
 *  ޤθͤȯͤȤߤʤȽ
 */
#define	GET_TOLERANCE	100		/* ٤θѤ͡ñ̤ɽ */
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)


/*  ߥ٥쥸ȤΥեȿ  */
#define FRT_BIT_SHIFT	4

/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
hw_timer_initialize()
{
	/* ޥǥХΤν */
	sil_wrh_mem((VP)IOREG_CMSTR_BASE, 0x0000);	/* ޥȥå */
												/*  */
	sil_wrh_mem((VP)(IOREG_CMT0_BASE+IOREG_CMCOR_OFFSET), TO_CLOCK(TIC_NUME, TIC_DENO));

	/* ߥ٥   */
	define_int_plevel ((VH*)(IOREG_INTC_BASE+IOREG_IPRG_OFFSET), TIMER_INTLVL, FRT_BIT_SHIFT);

	/*  ׵򥯥ꥢȥåå */
	sil_wrh_mem((VP)(IOREG_CMT0_BASE+IOREG_CMCSR_OFFSET), (CMCSR_CMIE|CMCSR_CKS8));
	sil_wrh_mem((VP)IOREG_CMSTR_BASE, CMSTR_STR0);	/* ޥ */
}

/*
 *  ޳׵Υꥢ
 */
Inline void
hw_timer_int_clear()
{
	sil_wrh_mem((VP)(IOREG_CMT0_BASE+IOREG_CMCSR_OFFSET),
		(sil_reh_mem((VP)(IOREG_CMT0_BASE+IOREG_CMCSR_OFFSET)) & ~CMCSR_CMF));
}

/*
 *  ޤ߽
 *
 *  ޤưߤ롥
 */
Inline void
hw_timer_terminate()
{
	sil_wrh_mem((VP)IOREG_CMSTR_BASE,			/* ޤ */
		(sil_reh_mem((VP)IOREG_CMSTR_BASE) & ~CMSTR_STR0));
	sil_wrh_mem((VP)(IOREG_CMT0_BASE+IOREG_CMCSR_OFFSET), CMCSR_CKS8);/* ߤװΥꥢ */
}

/*
 *  ޤθͤɽФ
 *ޤưŪߤͤɤ߽Ф
 */
Inline CLOCK
hw_timer_get_current(void)
{
	return sil_reh_mem((VP)(IOREG_CMT0_BASE+IOREG_CMCNT_OFFSET));
}

/*
 *  ޳׵Υå
 */
Inline BOOL
hw_timer_fetch_interrupt(void)
{
	return ((sil_reh_mem((VP)(IOREG_CMT0_BASE+IOREG_CMCSR_OFFSET)) & CMCSR_CMIE) != 0);
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
