/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sh7615frt.h,v 1.5 2005/07/06 00:45:07 honda Exp $
 */

/*
 *	ޥɥ饤
 *  FRT
 */

#ifndef _SH7615FRT_H_
#define _SH7615FRT_H_

/*
 *   ޤؤϥåʬ
 *   	f/8ǥ
 */
#define TCR_CKS         0x0

/*
 *   ޤ˶뤵륯åȿ[kHz]
 *   	14.7456MHz/8 =1.8432MHz =1843.2kHz
 */
#define TIMER_CLOCK	1843


/*
 *  ͤɽη
 */
typedef UH CLOCK;

/*
 *  ͤɽȥߥáñ̤ȤѴ
 *
 */
#define	TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define	TO_USEC(clock)		((clock) * 1000 / TIMER_CLOCK)
#define CLOCK_PER_TICK	((CLOCK) TO_CLOCK(TIC_NUME, TIC_DENO))

/*
 *  ǤΥ޼ñ̤ɽ
 */
#define	MAX_CLOCK	((CLOCK) 0xffff)

/*
 *  ޤθͤȯͤȤߤʤȽ
 */
#define	GET_TOLERANCE	100		/* ٤θѤ͡ñ̤ɽ */
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  ȥ쥸Υɥ쥹
 */

#define FRT_FTCSR	(VB *)0xfffffe11
#define FRT_TOCR	(VB *)0xfffffe17
#define FRT_TCR		(VB *)0xfffffe16
#define FRT_OCRH	(VB *)0xfffffe14
#define FRT_OCRL	(VB *)0xfffffe15
#define FRT_TIER	(VB *)0xfffffe10
#define FRT_FRCH	(VB *)0xfffffe12
#define FRT_FRCL	(VB *)0xfffffe13


#ifndef _MACRO_ONLY

/*
 *  ޥ
 */
Inline void
sh2_timer_start ()
{
	/* OCRAפˤȯ */
	sil_wrb_mem (FRT_TIER, sil_reb_mem(FRT_TIER) | 0x08);
}

/*
 *  ް
 */
Inline void
sh2_timer_stop ()
{
	/* OCRAפˤȯԵ */
	sil_wrb_mem (FRT_TIER, sil_reb_mem(FRT_TIER) & ~0x08);
}
/*
 *  ޳׵Υꥢ
 *	TCR쥸IMFAӥåȤ1ɤ߽Фˣ񤭹
 */
Inline void
sh2_timer_int_clear ()
{
	/* ׵򥯥ꥢ     */
	/*  GRAڥޥåե饰 */
	sil_wrb_mem (FRT_FTCSR, sil_reb_mem (FRT_FTCSR) & 0xf7);
	/* OCRAڥޥåե饰Υꥢ */

}


/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
sh2_timer_initialize ()
{
	CLOCK cyc = TO_CLOCK (TIC_NUME, TIC_DENO);


	/*
	 *  ޴Ϣ
	 */
	sh2_timer_stop ();			/*  */
	/* ޾ͤΥå */
	assert (cyc <= MAX_CLOCK);

	/* OCRA */
	sil_wrb_mem (FRT_TOCR, 0x00);
	/*  ʬ  clock 1/8   */
	sil_wrb_mem (FRT_TCR, 0x00);
	/* OCRAפˤFRCΥꥢ */
	sil_wrb_mem (FRT_FTCSR, sil_reb_mem (FRT_FTCSR) | 0x01);
	/* ڥޥåե饰Υꥢ */
	sil_wrb_mem (FRT_FTCSR, sil_reb_mem (FRT_FTCSR) & 0xf7);
	/*  OCRA쥸ʥɸ͡      */
	sil_wrb_mem (FRT_OCRH, (CLOCK_PER_TICK >> 8) & 0x00ff);
	sil_wrb_mem (FRT_OCRL, (CLOCK_PER_TICK) & 0x00ff);
	/* OCRAפˤȯ */
	sil_wrb_mem (FRT_TIER, 0x09);
	/* 󥿤򥯥ꥢ             */
	sil_wrb_mem (FRT_FRCH, 0);
	sil_wrb_mem (FRT_FRCL, 0);
}

/*
 *  ޤ߽
 *
 *  ޤưߤ롥
 */
Inline void
sh2_timer_terminate ()
{
	sh2_timer_stop ();			/* ޤ     */
	sh2_timer_int_clear ();		/* ׵򥯥ꥢ */

	sil_wrb_mem (FRT_TIER, 0x01);	//Ե
	sil_wrb_mem (FRT_FRCH, 0);
	sil_wrb_mem (FRT_FRCL, 0);
	sil_wrb_mem (FRT_OCRH, 0);
	sil_wrb_mem (FRT_OCRL, 0);
}

/*
 *  ޤθͤɽФ
 *ͤɤ߽Ф
 */
Inline CLOCK
sh2_timer_get_current ()
{
	CLOCK	clk;
	CLOCK up, low;


	up = sil_reb_mem (FRT_FRCH);
	low = sil_reb_mem (FRT_FRCL);
	clk = (up << 8) | low;
	return (clk);
}

/*
 *  ޳׵Υå
 */
Inline BOOL
sh2_timer_fetch_interrupt ()
{
	return (sil_reb_mem (FRT_FTCSR) & 0x08);
}

#endif /* _MACRO_ONLY */
#endif /* _SH7615FRT_H_ */
