/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *                     2003         by Advanced Data Controls, Corp
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 *  @(#) $Id: cpu_defs.h,v 1.4 2005/07/27 11:06:36 honda Exp $
 */

/*
 *  ץå˰¸SH3/4ѡ
 *
 *  Υ󥯥롼ɥեϡkernel.h  sil.h ǥ󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤ뤳ȤϤʤΥե򥤥
 *  롼ɤˡt_stddef.h  itron.h 󥯥롼ɤΤǡ
 *  ˰¸Ƥ褤
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

/*
 *  ץå˰¸
 */
#ifndef _MACRO_ONLY

/*
 * /CPU㳰ϥɥֹη
 */
typedef	UINT		INHNO;		/* ߥϥɥֹ */
typedef	UINT		EXCNO;		/* CPU㳰ϥɥֹ */


/*
 * ߥޥηȳߥޥѹ/
 */
typedef	UINT		IPM;		/* ߥޥ */

extern ER	chg_ipm(IPM ipm)  throw();
extern ER	get_ipm(IPM *p_ipm)  throw();


/*
 *  INTNOȳߤζػ/
 */
typedef	UINT		INTNO;		/* ֹ */

extern ER	dis_int(INTNO intno)  throw();
extern ER	ena_int(INTNO intno)  throw();


/*
 *  åȥƥ¸Υӥ
 */
#ifdef _int64_
typedef	UD  SYSUTIM;	       /* ǽɾѥƥ */
#else
typedef	UINT  SYSUTIM;	       /* ǽɾѥƥ */
#endif
extern ER	vxget_tim(SYSUTIM *p_sysutim) throw();

/*
 *  ơ쥸SRˤθͤɽФ
 */
asm unsigned int __current_sr(void)
{
%
    stc sr,r0
}
/*
 *  ơ쥸SRˤθͤѹ
 */
asm void __set_sr(s)
{
%reg s

   ldc s,sr
}



/*
 * ߤγߥޥɽФ
 */
Inline UW
_current_intmask_()
{
    return(__current_sr() & 0x000000f0);
}

/*
 *  Ƥγߤػ
 */

Inline void
_disint_()
{
    UW sr;
    
    sr = __current_sr();
	sr |= 0x000000f0;
    __set_sr(sr);
}

/*
 *  ߥޥ
 */
Inline void
_set_intmask_(UW intmask)
{
    UW sr;
    
    sr=__current_sr();
    sr = (sr & ~0x000000f0) | intmask;
    __set_sr(sr);
}


/*
 * ߥå֤
 */
#define SIL_PRE_LOC UW _intmask_ = _current_intmask_()
#define SIL_LOC_INT()   _disint_()
#define SIL_UNL_INT()   _set_intmask_(_intmask_)


#endif /* _MACRO_ONLY */
#endif /* _CPU_DEFS_H_ */
