/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_config.c,v 1.6 2003/12/11 00:52:12 honda Exp $
 */


#include "jsp_kernel.h"
#include <ms7727cp01.h>
#include <st16c2550.h>

/*
 *  åȥƥ¸ 롼
 */
void
sys_initialize()
{
    /* PINT7 Hight٥Ǽ */
    sil_wrh_mem((VP)ICR2,
                (sil_reh_mem((VP)ICR2) | ICR2_PINT7S));

    /* PINT6 Hight٥Ǽ */
    sil_wrh_mem((VP)ICR2,
                (sil_reh_mem((VP)ICR2) | ICR2_PINT6S));    
    
    /*
     * 󥽡ѤΥꥢ륳ȥν
     */
    st16c2550_init();    
}


/*
 *  åȥƥνλ롼
 *
 *  ƥλ˻Ȥ̾ϥ˥ƤӽФǼ¸롥
 *  
 */
void
sys_exit(void)
{
    kernel_abort();
}

/*
 *   ƥʸλ
 */

#ifdef GDB_STUB
#define SYS_PUT_CHAR(c) stub_putc(c)
#else 
#define SYS_PUT_CHAR(c) st16c2550_pol_putc(c,LOGTASK_PORTID)
#endif /* GDB_STUB */

void
sys_putc(char c)
{
    if (c == '\n') {
        SYS_PUT_CHAR('\r');
    }
    SYS_PUT_CHAR(c);
}


