;
;   TOPPERS/JSP Kernel
;       Toyohashi Open Platform for Embedded Real-Time Systems/
;       Just Standard Profile Kernel
;
;   Copyright (C) 2006-2010 by Witz Corporation, JAPAN
;  
;   The above copyright holders grant permission gratis to use,
;   duplicate, modify, or redistribute (hereafter called use) this
;   software (including the one made by modifying this software),
;   provided that the following four conditions (1) through (4) are
;   satisfied.
;  
;   (1) When this software is used in the form of source code, the above
;       copyright notice, this use conditions, and the disclaimer shown
;       below must be retained in the source code without modification.
;  
;   (2) When this software is redistributed in the forms usable for the
;       development of other software, such as in library form, the above
;       copyright notice, this use conditions, and the disclaimer shown
;       below must be shown without modification in the document provided
;       with the redistributed software, such as the user manual.
;  
;   (3) When this software is redistributed in the forms unusable for the
;       development of other software, such as the case when the software
;       is embedded in a piece of equipment, either of the following two
;       conditions must be satisfied:
;  
;     (a) The above copyright notice, this use conditions, and the
;            disclaimer shown below must be shown without modification in
;         the document provided with the redistributed software, such as
;         the user manual.
;  
;     (b) How the software is to be redistributed must be reported to the
;         TOPPERS Project according to the procedure described
;         separately.
;  
;   (4) The above copyright holders and the TOPPERS Project are exempt
;       from responsibility for any type of damage directly or indirectly
;       caused from the use of this software and are indemnified by any
;       users or end users of this software from any and all causes of
;       action whatsoever.
;  
;   THIS SOFTWARE IS PROVIDED "AS IS." THE ABOVE COPYRIGHT HOLDERS AND
;   THE TOPPERS PROJECT DISCLAIM ANY EXPRESS OR IMPLIED WARRANTIES,
;   INCLUDING, BUT NOT LIMITED TO, ITS APPLICABILITY TO A PARTICULAR
;   PURPOSE. IN NO EVENT SHALL THE ABOVE COPYRIGHT HOLDERS AND THE
;   TOPPERS PROJECT BE LIABLE FOR ANY TYPE OF DAMAGE DIRECTLY OR
;   INDIRECTLY CAUSED FROM THE USE OF THIS SOFTWARE.
;
;   嵭Ԥϡʲ (1)(4) ξ˸¤ꡤܥեȥ
;   ܥեȥѤΤޤࡥʲƱˤѡʣѡ
;   ۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
;   (1) ܥեȥ򥽡ɤηѤˤϡ嵭
;       ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
;       ˴ޤޤƤ뤳ȡ
;   (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
;       ǤǺۤˤϡۤȼɥȡѼԥ
;       ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ̵
;       ڵǺܤ뤳ȡ
;   (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
;       ǤʤǺۤˤϡΤ줫ξȡ
;     (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
;         ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
;     (b) ۤη֤̤ˡˤäơTOPPERSץȤ
;         𤹤뤳ȡ
;   (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
;       ⡤嵭ԤTOPPERSץȤդ뤳ȡޤ
;       ܥեȥΥ桼ޤϥɥ桼Τʤͳ˴
;       ᤫ⡤嵭ԤTOPPERSץȤդ뤳ȡ
;  
;   ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
;   TOPPERSץȤϡܥեȥ˴ؤơλŪФ
;   ŬޤơʤݾڤԤʤޤܥեȥ
;   ˤľŪޤϴŪʤ»˴ؤƤ⡤Ǥ
;   ʤ
;  
;   @(#) $Id: cpu_support.app,v 1.1 2006/04/10 08:19:25 honda Exp $
;

	$MAXIMUM
	module cpu_support_app

;
;	ץå¸⥸塼 ֥TLCS-900L1ѡ
;

#define	SUPPORT_CHG_IPM
#include "jsp_rename.h"
#include "cpu_rename.h"
#include "sys_rename.h"
#include "offset.inc"

; ȥܥ
	extern large	__StackTop
	extern large	_reqflg
	extern large	_enadsp
	extern large	_intcnt
	extern large	_runtsk
	extern large	_schedtsk
	extern large	_call_texrtn
	extern large	_task_intmask


f_code section code large align=1,1

;
;	ǥѥå
;
;   dispatch ϡƥȾ֡߶ػ߾֤ǸƤӽФʤ
;   Фʤʤexit_and_dispatch ⡤ƥȾ֡
;   ߶ػ߾֤ǸƤӽФΤ§Ǥ뤬ͥ뵯ưб뤿ᡤ
;   ߥƥȾ֤ǸƤӽФˤбƤ롥
;	ƤӽФ: SRIFF=7 (߶ػ߾),
;				  intcnt = 0(ƥ), å
;
	public _dispatch

_dispatch:
	push	xiz			; ؿƽФݸɬפʥ쥸¸
	ld		xwa, (_runtsk)	; ư楿TCB
	ld		(xwa+TCB_sp), xsp	;
	lda		xhl, dispatch_r	;
	ld		(xwa+TCB_pc), xhl	;
	jr		dispatcher	;

;
;	ƤӽФ: SRIFF=7 (߶ػ߾),
;				  intcnt = 0(ƥ), å
;
;	xwa ˤruntsk Υɥ쥹ǼƤ
;
dispatch_r:
	pop		xiz		;
	ld		bc, (xwa+TCB_enatex)	;
	bit		TCB_enatex_bit, bc	;
	jr		z, dispatch_r_1	; enatex  FALSE ʤ꥿
	cpw		(xwa+TCB_texptn), 0	; 㳰װ
	jp		nz, _call_texrtn	;
	; call_texrtnľdispatch ƤӽФ.
dispatch_r_1:				; 㳰¹Ԥʤ
	ret				; dispatch ƤӽФ.

;
;	ư
;
;	Ǥ, CPUå֤ˤ, ư.
;
;	ƤӽФ: SRIFF=7 (߶ػ߾),
;				  intcnt = 0(ƥ), å
;
	public _activate_r

_activate_r:
	pop		xhl		; εưϤwhl 
#ifdef SUPPORT_CHG_IPM			/* t_unlock_cpu ν */
	push	sr			; ߥޥ task_intmask 
	ld		wa, (_task_intmask)	;
	andw	(xsp), ~0x7000	;
	or		(xsp), wa	;
	pop		sr			;
#else /* SUPPORT_CHG_IPM */
	ei		0		; ߵ
#endif /* SUPPORT_CHG_IPM */
	jp		xhl

;
;	dispatcherƤӽФ:
;		٤ƤΥΥƥȤ¸Ƥ.
;		SRIFF=7 (߶ػ߾)
;		ƥȤϥƥ(intcnt=0)
;	dispatcher ƽлΥå:
;		dispatch 餭: å
;		exit_and_dispatch 餭: 
;			exit_task 餭ϥå
;			ͥ뵯ưϳߥå
;		ret_int 餭: å
;		dispatcher_2 ǤγԤ餭: ߥå
;
	public _exit_and_dispatch

_exit_and_dispatch:
	ldw		(_intcnt), 0	; ͥȥ󥿥ꥢ(ƥ)
dispatcher:
	ld		xwa, (_schedtsk)	; schedtsk  runtsk 
	ld		(_runtsk), xwa	;
	or		xwa, xwa		; ¹Ԥ륿̵Хɥ롼פ
	jr		z, pre_idle_loop	;
	ld		xsp, (xwa+TCB_sp)	; åݥ󥿤
	ld		xhl, (xwa+TCB_pc)	;
	jp		xhl			; ¹ԺƳϤإ
;
;	¹Ԥ٤ޤԤĽ
;
pre_idle_loop:
	ld		xsp, __StackTop ; ѤΥåؤ
	incw	1, (_intcnt)	; 󥿥ƥ
;
;	󥿥ƥ,ߥåڤ괹Τ,
;	ȯ߽ˤɤΥåȤȤβ,
;	ߥϥɥǤΥǥѥåɻߤȤ2Ĥΰ̣롥
;
idle_loop:
#ifdef SUPPORT_CHG_IPM			/* t_unlock_cpu ν */
	push	sr			; ߥޥ task_intmask 
	ld		wa, (_task_intmask)	;
	andw	(xsp), ~0x7000	;
	or		(xsp), wa	;
	pop		sr			;
#else /* SUPPORT_CHG_IPM */
	ei		0		; ߵ
#endif /* SUPPORT_CHG_IPM */

	halt 		; IDLE2֤
	nop			; 嵭halt򥳥(nopΤ)ˤ
	nop			; ưԤʤɥ롼פȤʤ.
	nop			; 
	nop			; 
	ei		7			; ߶ػ
	cpw		(_reqflg), 0	; reqflg  FALSE Ǥ
	jr		z, idle_loop	;         idle_loop 
	ldw		(_reqflg), 0	; reqflg <--- FALSE
	decw		1, (_intcnt)	; ƥȤ᤹
	jr		dispatcher		; dispatcher 

;
;  ٱǥѥå
;
;	ƤӽФ: SRIFF=7 (߶ػ߾),
;				  intcnt = 0(ƥ), å
;				  reqflg = TRUE
;				  INTNEST쥸 = 1
;
ret_int:
	ldw		(_reqflg), 0	; reqflg <--- FALSE
	ld		de, 0	;
	ldc		intnest, de	; ǥѥåintnest 0
	push	xiz			; ؿƽФݸɬפʥ쥸¸
	ld		xwa, (_runtsk)	; runtsk 
	cpw		(_enadsp), 0	; enadsp  FALSE ʤ
	jr		z, ret_int_r	; ret_int_r 
	cp		xwa, (_schedtsk)	; runtsk schedtsk Ʊʤ
	jr		z, ret_int_r	; ret_int_r 
	or		xwa, xwa	; runtsk = NULL ʤ
	jr		z, dispatcher	; ¸dispather 
	ld		(xwa+TCB_sp), xsp	;
	lda		xhl, ret_int_r	;
	ld		(xwa+TCB_pc), xhl	;
	jr		dispatcher	;

;
;	ƤӽФ: SRIFF=7 (߶ػ߾),
;				  intcnt = 0(ƥ), å
;				  INTNEST쥸 = 0
;
;	xwa ˤruntsk Υɥ쥹ǼƤ
;
ret_int_r:
	pop		xiz
#ifdef SUPPORT_CHG_IPM		/* åˤSR IFF  */
	ld		de, (_task_intmask)	;
	andw	(xsp+24), ~0x7000	;
	or		(xsp+24), de	;
#endif /* SUPPORT_CHG_IPM */
	ld		bc, (xwa+TCB_enatex)	;
	bit		TCB_enatex_bit, bc	;
	jr		z, nest_ctrl_r	; enatex  FALSE ʤ꥿
	cpw		(xwa+TCB_texptn), 0	; 㳰װ
	call	nz, _call_texrtn	;
nest_ctrl_r:
	ld		de, 1	;
	ldc		intnest, de	; retiѤ˵Ūintnest 1
	jr		interrupt_r

;
;	/CPU㳰ζ̽
;
;	ƽФ:
;	SRIFF=7.
;	å¿ųߤʤߥå, Ǥʤ
;	  å
;	XHL ˤϳ/CPU㳰ϥɥΥɥ쥹ǼƤ.
;	AW ˤܳߤͥ٤ꤵ줿 SR ǼƤ.
;
;	쥸åˤɤΤ褦¸Ƥ뤫ʲ˼.
;	οޤǤϾ夬, ̤Υɥ쥹, åϲ
;	˸äѤ߾夲ΤȤ.
;
;	--------------------------------------
;	|        CPU㳰ϥɥΰ       |
;	|          CPU㳰(4byte)        |
;	|                                    |
;	|                                    |
;	--------------------------------------
;	|             XSP(4byte)             | åݥ󥿡
;	|             ʤΤ             | ʤγߤΤݻ롥
;	|                                    |
;	|                                    |
;	--------------------------------------
;	|             XIY(4byte)             |
;	|                                    |
;	|                                    |
;	|                                    |
;	--------------------------------------
;	|             XIX(4byte)             |
;	|                                    |
;	|                                    |
;	|                                    |
;	--------------------------------------
;	|             XDE(4byte)             |
;	|                                    |
;	|                                    |
;	|                                    |
;	--------------------------------------
;	|             XBC(4byte)             |
;	|                                    |
;	|                                    |
;	|                                    |
;	-------------------------------------- <-- ǽ롥
;	|             XHL(4byte)             |
;	|                                    |
;	|                                    |
;	|                                    |
;	--------------------------------------
;	|             XAW(4byte)             |
;	|                                    |
;	|                                    |
;	|                                    |
;	-------------------------------------- <-- ȯ˥ϡɥ
;	|              SR(2byte)             |     ˤƽ롥 p_excinf
;	|                                    |     ؤ褦˱黻롥
;	--------------------------------------
;	|              PC(4byte)             |
;	|                                    |
;	|                                    |
;	|                                    |
;	--------------------------------------
;
;	ϥɥ餫꥿󤷤, ¿ųߤǤʤ,  reqflg 
;	TRUE ˤʤäˡret_int ʬ롥
;
;	¿ųߤɤϳߥͥȥ󥿤ͤȽꤹ.
;	intcnt != 0 ʤ¿ųߤǤȽꤹ.
;	ʤϡɥ;塤ȯ߶ػߤԤޤǤδ֤
;	¿ųߤȯȡ¿ųߤǤ뤳Ȥ򥽥եȥǸΤ
;	ʤᡤǽȯ߽¹Ԥʤޤޥǥ
;	ѥåǽ롥¿ųߤΤ뤿˥ϡɥ
;	INTNEST 쥸Ѥ롥
;
;	reqflg CPUå֤ǥå. Ǥʤȡ
;	reqflg å˵ư줿ߥϥɥ
;	ǥѥå׵ᤵ줿ˡǥѥåʤ.
;
	public _interrupt

_interrupt:
	push	xbc			; å쥸λĤ¸
	push	xde			;
	push	xix			;
	push	xiy			;

	ld		xbc, xsp	; CPU㳰˻Ѥ뤿ᤳǼ
	cpw		(_intcnt), 0	;
	jr		nz, from_int	;
	ld		xsp, __StackTop ; ʤγߤξ祹åڤؤ
	push	xbc			; SPݻ
from_int:				;
	incw	1, (_intcnt)	; ߥͥȥȤ򥤥󥯥

	add		xbc, 24	; CPU㳰
	push	xbc			; ߽Ǥ̤
	push	wa			;
	pop		sr			; ܳߤͥ٤ι⤤ߵ
	call	xhl			; ߥϥɥ/CPU㳰ƤӽФ
	ei		7			; ߶ػ
	pop		xbc			; å碌(CPU㳰)

	decw	1, (_intcnt)	; ߥͥȥȤǥ
	jr		nz, from_int_r	;
	pop		xbc			; ʤγߤξ祿SP
	ld		xsp, xbc	;
	ldc		de, intnest	; ȯ߶ػߤޤǤδ֤¿ųߤ
	djnz	de, from_int_r	; ȯƤϥǥѥåʤ
	cpw		(_reqflg), 0	; reqflg  TRUE Ǥ
	jp		nz, ret_int	;              ret_int 
from_int_r:		;
interrupt_r:	;
	pop		xiy	;å쥸
	pop		xix	;
	pop		xde	;
	pop		xbc	;
	pop		xhl	;
	pop		xwa	;
	reti	;

;
; ̤ѳߤν
;
	public unused_interrupt

unused_interrupt:
	reti


	end


