/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003      by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣѡ
 *  ۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ǤǺۤˤϡۤȼɥȡѼԥ
 *      ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ̵
 *      ڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ǤʤǺۤˤϡΤ줫ξȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡޤ
 *      ܥեȥΥ桼ޤϥɥ桼Τʤͳ˴
 *      ᤫ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪФ
 *  ŬޤơʤݾڤԤʤޤܥեȥ
 *  ˤľŪޤϴŪʤ»˴ؤƤ⡤Ǥ
 *  ʤ
 */

/*
 *  ץå¸⥸塼Xstormy16ѡ
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  ͥ̾Υ͡
 */
#include <cpu_rename.h>

/*
 *  ץåü̿Υ饤ؿ
 */
#include <cpu_insn.h>

/*
 *  chg_ipm/get_ipm ϥݡȤʤ
 */
#undef  SUPPORT_CHG_IPM

/*
 *  calltex ϻѤʤ
 */
#define OMIT_CALLTEX

/*
 *  ꥢݡȿ
 */
#define TNUM_PORT   2   /* ݡȤ륷ꥢݡȤο */

/*
 *  ꥢݡֹ˴ؤ
 */
#define LOGTASK_PORTID  1   /* ƥѤ륷ꥢݡֹ */

/*
 *  ɬץå
 */
#define LOGTASK_STACK_SIZE 256

/*
 *  ХåեΥ
 */
#define TCNT_SYSLOG_BUFFER  8

/*
 *  TCB ΥեɤΥӥå
 */
#define TBIT_TCB_TSTAT      8   /* tstat եɤΥӥå */
#define TBIT_TCB_PRIORITY   4   /* priority եɤΥӥå */

#ifndef _MACRO_ONLY

/*
 *  ƥȥ֥å
 */
typedef struct task_context_block {
    unsigned short sp;          /* åݥ */
    unsigned short mode;        /* dispatcher */
} CTXB;

/*
 *  /󥿥ѥХѿ
 */
extern unsigned short _kernel_intnest ;

/*
 *  ƥֻ
 */
#define sense_context() ( _kernel_intnest > 0)
#define sense_lock() (!( __PSW & 0x0080 ))
#define t_sense_lock sense_lock
#define i_sense_lock sense_lock
#define t_lock_cpu() ({__asm__( "clr1 psw,#7" );})
#define t_unlock_cpu() ({__asm__( "set1 psw,#7" );})
#define i_lock_cpu t_lock_cpu
#define i_unlock_cpu t_unlock_cpu

/*
 *  CPU㳰ȯΥƥȤλ
 */
#define exc_sense_context(p_excinf) ( _kernel_intnest > 1 )

/*
 *  CPU㳰ȯCPUå֤λ
 */
#define exc_sense_lock(p_excinf) (!(((unsigned short*)p_excinf)[-1] & 0x0080))

/*
 *  ߥϥɥޥ
 */
#define INTHDR_ENTRY(inthdr) extern void inthdr(void)
#define INT_ENTRY(inthdr) inthdr

/*
 *  CPU㳰ޥ
 */
#define EXCHDR_ENTRY(exchdr) extern void exchdr(VP sp)
#define EXC_ENTRY(exchdr) exchdr

/*
 *  ץå¸ν
 */
extern void cpu_initialize(void);

/*
 *  ץå¸νλ
 */
extern void cpu_terminate(void);

/*
 *  ߥϥɥ
 */
extern void define_inh(INHNO inhno, FP inthdr) ;

/*
 *  CPU㳰ϥɥ
 */
extern void define_exc(EXCNO excno, FP exchdr) ;

/*
 *  åȥƥʸ
 */
extern void sys_putc(char c);

/*
 *  ǥѥå
 *  ǹ̥ͥؤΥǥѥåcpu_support.S
 */
extern void dispatch(void);

/*
 *  ǥѥå
 *  ߤΥƥȤΤƤƥǥѥåcpu_support.S
 */
extern void exit_and_dispatch(void);

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */
