/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003      by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣѡ
 *  ۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ǤǺۤˤϡۤȼɥȡѼԥ
 *      ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ̵
 *      ڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ǤʤǺۤˤϡΤ줫ξȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡޤ
 *      ܥեȥΥ桼ޤϥɥ桼Τʤͳ˴
 *      ᤫ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪФ
 *  ŬޤơʤݾڤԤʤޤܥեȥ
 *  ˤľŪޤϴŪʤ»˴ؤƤ⡤Ǥ
 *  ʤ
 */

#define CHIP_NAME "LC88F0099"
#define RAM_SIZE 0x7800
#define ROM_SIZE 0x78000
#define VRAM_SIZE 0x0000
#define VRAM_ROW 0
#define VRAM_COLUMN 0
#define CGROM_SIZE 0x0000
#define BCD(x)  (((x)/10)%10)*0x10+((x)%10)
#define BCD4(x) BCD((x)/100),BCD(x)
#define BCD6(x) BCD((x)/10000),BCD((x)/100),BCD(x)

/*
 *  EVAǥХåѵȽ̾
 *  (section0x7f00-0x7fff˥󥯤)
 */

        .section .chip_info,"a"
        .global _chip_info
_chip_info:
        .org    0xc0
        .ascii  "CHIPINFORMATION"               /* C0-CF : fixed string */
        .org    0xd0
        .ascii  CHIP_NAME                       /* D0-DF : chip name */
        .org    0xe0
        .byte   0x10, 0x00                      /* E0-E1 : format version */
	.org	0xe8
        .byte   BCD4(ROM_SIZE/1024)             /* E8-F5 : Memory sizes */
        .byte   BCD6(RAM_SIZE)
        .byte   BCD6(VRAM_SIZE)
        .byte   BCD4(VRAM_ROW)
        .byte   BCD4(VRAM_COLUMN)
        .byte   BCD4(CGROM_SIZE/1024)
	.org	0xf9
        .byte   0x01                            /* F9 : package type */
        .space  6, 0x00

/*
 *  桼ץ󥳡
 *  (section0x77f00-0x77fff˥󥯤)
 */

	.section .user_option,"a"
	.org	0xbc
	jmpf	0x08000				/* BC-BF : Jump to reset vector */
	.org	0xd0
        .ascii  CHIP_NAME                       /* D0-DF : chip name */
	.org	0xe0
	.byte   0x02, 0x00			/* E0 : Su script version */
	.org	0xe8
        .byte   BCD4(ROM_SIZE/1024)             /* E8-F5 : Memory sizes */
        .byte   BCD6(RAM_SIZE)
        .byte   BCD6(VRAM_SIZE)
        .byte   BCD4(VRAM_ROW)
        .byte   BCD4(VRAM_COLUMN)
        .byte   BCD4(CGROM_SIZE/1024)
	.org	0xf9
        .byte   0x01                            /* F9 : package type */
	.space	6, 0x00

        .end
