/*
 * Decompiled with CFR 0.152.
 */
package sourceview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.text.Segment;
import net.sourceforge.jsxe.DocumentBuffer;
import net.sourceforge.jsxe.gui.EnhancedDialog;
import net.sourceforge.jsxe.gui.Messages;
import net.sourceforge.jsxe.jsXe;
import net.sourceforge.jsxe.util.Log;
import org.syntax.jedit.JEditTextArea;
import sourceview.CharIndexedSegment;
import sourceview.RESearchMatcher;
import sourceview.SourceView;

public class SourceViewSearchDialog
extends EnhancedDialog {
    private static int m_dialogHeight = 200;
    private static int m_dialogWidth = 350;
    private static SourceViewSearchDialog m_dialog = null;
    private static final String IGNORE_CASE = "source.ignore.case";
    private SourceView m_view;
    private JComboBox m_findComboBox;
    private JComboBox m_replaceComboBox;
    private JCheckBox m_ignoreCaseCheckBox;

    public static SourceViewSearchDialog getSearchDialog() {
        return m_dialog;
    }

    public static void showSearchDialog(SourceView view) {
        if (m_dialog == null) {
            Container parent = view.getParent();
            while (!(parent instanceof Frame)) {
                parent = parent.getParent();
            }
            Frame frame = (Frame)parent;
            m_dialog = new SourceViewSearchDialog(frame, view);
        }
        m_dialog.setVisible(true);
    }

    public SourceViewSearchDialog(Frame parentFrame, SourceView view) {
        super(parentFrame, "Search and Replace", false);
        this.m_view = view;
        JPanel frame = new JPanel();
        this.getContentPane().add((Component)frame, "Center");
        JButton findButton = new JButton("Find");
        JButton replaceButton = new JButton("Replace&Find");
        JButton cancelButton = new JButton(Messages.getMessage((String)"common.cancel"));
        findButton.addActionListener(new FindAction());
        replaceButton.addActionListener(new ReplaceAction());
        cancelButton.addActionListener(new CancelAction());
        Border border = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        frame.setBorder(border);
        this.setSize(m_dialogWidth, m_dialogHeight);
        this.setLocationRelativeTo(parentFrame);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        frame.setLayout(layout);
        this.m_findComboBox = new JComboBox();
        this.m_findComboBox.setName("FindComboBox");
        this.m_findComboBox.setEditable(true);
        this.m_replaceComboBox = new JComboBox();
        this.m_replaceComboBox.setName("ReplaceComboBox");
        this.m_replaceComboBox.setEditable(true);
        DocumentBuffer buffer = this.m_view.getDocumentBuffer();
        boolean ignoreCase = Boolean.valueOf(jsXe.getProperty((String)IGNORE_CASE));
        this.m_ignoreCaseCheckBox = new JCheckBox("Ignore Case", ignoreCase);
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.weightx = 1.0;
        constraints.fill = 1;
        constraints.insets = new Insets(1, 0, 1, 0);
        JLabel searchLabel = new JLabel("Search for:");
        layout.setConstraints(searchLabel, constraints);
        frame.add(searchLabel);
        constraints.gridy = 1;
        constraints.gridx = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.weightx = 1.0;
        constraints.fill = 1;
        constraints.insets = new Insets(1, 0, 1, 0);
        layout.setConstraints(this.m_findComboBox, constraints);
        frame.add(this.m_findComboBox);
        constraints.gridy = 2;
        constraints.gridx = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.weightx = 1.0;
        constraints.fill = 1;
        constraints.insets = new Insets(1, 0, 1, 0);
        JLabel replaceLabel = new JLabel("Replace With:");
        layout.setConstraints(replaceLabel, constraints);
        frame.add(replaceLabel);
        constraints.gridy = 3;
        constraints.gridx = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.weightx = 1.0;
        constraints.fill = 1;
        constraints.insets = new Insets(1, 0, 1, 0);
        layout.setConstraints(this.m_replaceComboBox, constraints);
        frame.add(this.m_replaceComboBox);
        constraints.gridy = 4;
        constraints.gridx = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.weightx = 1.0;
        constraints.fill = 1;
        constraints.insets = new Insets(1, 0, 1, 0);
        layout.setConstraints(this.m_ignoreCaseCheckBox, constraints);
        frame.add(this.m_ignoreCaseCheckBox);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(findButton);
        buttonsPanel.add(replaceButton);
        buttonsPanel.add(cancelButton);
        this.getContentPane().add((Component)frame, "North");
        this.getContentPane().add((Component)buttonsPanel, "South");
        this.getRootPane().setDefaultButton(findButton);
    }

    public void dispose() {
        m_dialog = null;
        super.dispose();
    }

    public void ok() {
        this.find(false);
    }

    public void cancel() {
        jsXe.setProperty((String)IGNORE_CASE, (String)String.valueOf(this.m_ignoreCaseCheckBox.isSelected()));
        this.dispose();
    }

    private void find(boolean doReplace) {
        this.find(doReplace, this.m_view.getTextArea().getCaretPosition());
    }

    private void find(boolean doReplace, int startIndex) {
        try {
            String selText;
            Object searchItem = this.m_findComboBox.getSelectedItem();
            Object replaceItem = this.m_replaceComboBox.getSelectedItem();
            boolean ignoreCase = this.m_ignoreCaseCheckBox.isSelected();
            String search = "";
            if (searchItem != null) {
                search = searchItem.toString();
            }
            String replace = "";
            if (replaceItem != null) {
                replace = replaceItem.toString();
            }
            RESearchMatcher matcher = new RESearchMatcher(search, replace, ignoreCase);
            JEditTextArea textArea = this.m_view.getTextArea();
            if (doReplace && (selText = textArea.getSelectedText()) != null && !selText.equals("")) {
                String replaceString = matcher.substitute(selText);
                textArea.setSelectedText(replaceString);
            }
            DocumentBuffer buffer = this.m_view.getDocumentBuffer();
            Segment seg = buffer.getSegment(0, buffer.getLength());
            int caretPosition = startIndex;
            CharIndexedSegment charSeg = new CharIndexedSegment(seg, caretPosition);
            int[] match = matcher.nextMatch(charSeg, false, true, true, false);
            buffer.setProperty("sourceview.last.find.string", search);
            if (match != null) {
                Log.log((int)1, (Object)((Object)this), (Object)(match[0] + " " + match[1]));
                int start = match[0] + caretPosition;
                int end2 = match[1] + caretPosition;
                textArea.select(start, end2);
            } else {
                int again = JOptionPane.showConfirmDialog(this.m_view, "No more matches were found. Continue search from the beginning?", "No More Matches Found", 0);
                if (again == 0) {
                    this.find(doReplace, 0);
                }
            }
            this.requestFocus();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this.m_view, ex, "Search Error", 2);
        }
    }

    private class ReplaceAction
    implements ActionListener {
        private ReplaceAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SourceViewSearchDialog.this.find(true);
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SourceViewSearchDialog.this.cancel();
        }
    }

    public class FindAction
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            SourceViewSearchDialog.this.find(false);
        }
    }
}

