/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JOptionPane;
import net.sourceforge.jsxe.DocumentBuffer;
import net.sourceforge.jsxe.gui.Messages;
import net.sourceforge.jsxe.gui.TabbedView;
import net.sourceforge.jsxe.jsXe;
import net.sourceforge.jsxe.util.Log;
import net.sourceforge.jsxe.util.MiscUtilities;
import org.apache.xml.resolver.Catalog;
import org.xml.sax.InputSource;

public class CatalogManager {
    private static boolean loadedCache;
    private static boolean loadedCatalogs;
    private static int cache;
    private static Catalog catalog;
    private static Set catalogFiles;
    private static HashMap resourceCache;
    private static HashMap reverseResourceCache;
    private static String resourceDir;
    private static Object IGNORE;
    static /* synthetic */ Class class$net$sourceforge$jsxe$CatalogManager;

    public static InputSource resolve(String current, String publicId, String systemId) throws Exception {
        Entry entry;
        CatalogManager.load();
        if (publicId != null && publicId.length() == 0) {
            publicId = null;
        }
        if (systemId != null && systemId.length() == 0) {
            systemId = null;
        }
        String newSystemId = null;
        String parent = current != null ? ((entry = (Entry)reverseResourceCache.get(current)) != null ? entry.uri : MiscUtilities.getParentOfPath(current)) : null;
        if (publicId == null && systemId != null && parent != null && systemId.startsWith(parent)) {
            newSystemId = systemId.substring(parent.length());
            if (newSystemId.startsWith("/")) {
                newSystemId = newSystemId.substring(1);
            }
            newSystemId = CatalogManager.resolveSystem(newSystemId);
        }
        if (newSystemId == null) {
            newSystemId = publicId == null ? CatalogManager.resolveSystem(systemId) : CatalogManager.resolvePublic(systemId, publicId);
        }
        if (newSystemId == null) {
            if (systemId == null) {
                return null;
            }
            if (MiscUtilities.isURL(systemId)) {
                newSystemId = systemId;
            }
        }
        if (newSystemId == null) {
            return null;
        }
        Log.log(3, class$net$sourceforge$jsxe$CatalogManager == null ? (class$net$sourceforge$jsxe$CatalogManager = CatalogManager.class$("net.sourceforge.jsxe.CatalogManager")) : class$net$sourceforge$jsxe$CatalogManager, "Attempting to load SystemId: " + newSystemId);
        if (newSystemId.startsWith("file:")) {
            String filename;
            DocumentBuffer buf;
            String testId = MiscUtilities.getParentOfPath(current) + MiscUtilities.getFileName(newSystemId);
            if (new File(new URI(testId)).exists()) {
                newSystemId = testId;
            }
            if ((buf = jsXe.getOpenBuffer(new File(filename = MiscUtilities.uriToFile(newSystemId)))) != null) {
                Log.log(3, class$net$sourceforge$jsxe$CatalogManager == null ? (class$net$sourceforge$jsxe$CatalogManager = CatalogManager.class$("net.sourceforge.jsxe.CatalogManager")) : class$net$sourceforge$jsxe$CatalogManager, "Found open buffer for " + newSystemId);
                InputSource source = new InputSource(systemId);
                source.setCharacterStream(new StringReader(buf.getText(0, buf.getLength())));
                return source;
            }
            try {
                InputSource source = new InputSource(systemId);
                source.setByteStream(new URL(newSystemId).openStream());
                Log.log(3, class$net$sourceforge$jsxe$CatalogManager == null ? (class$net$sourceforge$jsxe$CatalogManager = CatalogManager.class$("net.sourceforge.jsxe.CatalogManager")) : class$net$sourceforge$jsxe$CatalogManager, "Using local file: " + newSystemId);
                return source;
            }
            catch (IOException ioe) {
                Log.log(7, class$net$sourceforge$jsxe$CatalogManager == null ? (class$net$sourceforge$jsxe$CatalogManager = CatalogManager.class$("net.sourceforge.jsxe.CatalogManager")) : class$net$sourceforge$jsxe$CatalogManager, "Cannot find cached file " + newSystemId);
                Entry entry2 = (Entry)reverseResourceCache.get(newSystemId);
                if (entry2 != null) {
                    resourceCache.remove(entry2);
                    resourceCache.remove(new Entry(1, publicId, entry2.uri));
                    reverseResourceCache.remove(newSystemId);
                    return CatalogManager.resolve(current, publicId, systemId);
                }
                throw ioe;
            }
        }
        if (cache != 0) {
            TabbedView view = jsXe.getActiveView();
            if (cache == 2 || CatalogManager.showDownloadResourceDialog(view, newSystemId)) {
                InputSource source = new InputSource(systemId);
                File file = CatalogManager.copyToLocalFile(newSystemId);
                CatalogManager.addUserResource(publicId, systemId, file.toURL().toString());
                source.setByteStream(new FileInputStream(file));
                return source;
            }
            return null;
        }
        return null;
    }

    public static boolean isLocal(Entry e) {
        if (e == null || jsXe.getSettingsDirectory() == null) {
            return false;
        }
        try {
            URL url = new File(jsXe.getSettingsDirectory()).toURL();
            String fileUrl = (String)resourceCache.get(e);
            return fileUrl.startsWith(url.toString());
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    public static void propertiesChanged() {
        if (jsXe.getSettingsDirectory() == null) {
            cache = 0;
        } else {
            resourceDir = jsXe.getSettingsDirectory() + System.getProperty("file.separator") + "dtds";
            cache = jsXe.getIntegerProperty("xml.cache", 1);
        }
        if (cache == 0) {
            CatalogManager.clearCache();
        }
        loadedCatalogs = false;
    }

    public static void save() {
        if (loadedCache) {
            int systemCount = 0;
            int publicCount = 0;
            Iterator keys = resourceCache.keySet().iterator();
            while (keys.hasNext()) {
                Entry entry = (Entry)keys.next();
                Object uri = resourceCache.get(entry);
                if (uri == IGNORE) continue;
                if (entry.type == 1) {
                    jsXe.setProperty("xml.cache.public-id." + publicCount, entry.id);
                    jsXe.setProperty("xml.cache.public-id." + publicCount + ".uri", uri.toString());
                    ++publicCount;
                    continue;
                }
                jsXe.setProperty("xml.cache.system-id." + systemCount, entry.id);
                jsXe.setProperty("xml.cache.system-id." + systemCount + ".uri", uri.toString());
                ++systemCount;
            }
            jsXe.setProperty("xml.cache.public-id." + publicCount, null);
            jsXe.setProperty("xml.cache.public-id." + publicCount + ".uri", null);
            jsXe.setProperty("xml.cache.system-id." + systemCount, null);
            jsXe.setProperty("xml.cache.system-id." + systemCount + ".uri", null);
        }
    }

    public static void clearCache() {
        CatalogManager.load();
        Iterator files = resourceCache.values().iterator();
        while (files.hasNext()) {
            Object obj = files.next();
            if (!(obj instanceof String)) continue;
            String file = MiscUtilities.uriToFile((String)obj);
            Log.log(5, class$net$sourceforge$jsxe$CatalogManager == null ? CatalogManager.class$("net.sourceforge.jsxe.CatalogManager") : class$net$sourceforge$jsxe$CatalogManager, "Deleting " + file);
            new File(file).delete();
        }
        resourceCache.clear();
    }

    private CatalogManager() {
    }

    private static void addUserResource(String publicId, String systemId, String url) {
        if (publicId != null) {
            Entry pe = new Entry(1, publicId, url);
            resourceCache.put(pe, url);
        }
        Entry se = new Entry(0, systemId, url);
        resourceCache.put(se, url);
        reverseResourceCache.put(url, se);
    }

    private static File copyToLocalFile(String path) throws IOException {
        if (jsXe.getSettingsDirectory() == null) {
            return null;
        }
        String userDir = jsXe.getSettingsDirectory();
        File _resourceDir = new File(resourceDir);
        if (!_resourceDir.exists()) {
            _resourceDir.mkdir();
        }
        InputStream stream = MiscUtilities.isURL(path) ? new URL(path).openStream() : new FileInputStream(path);
        BufferedInputStream in = new BufferedInputStream(stream);
        File localFile = File.createTempFile("cache", ".xml", _resourceDir);
        Log.log(3, class$net$sourceforge$jsxe$CatalogManager == null ? (class$net$sourceforge$jsxe$CatalogManager = CatalogManager.class$("net.sourceforge.jsxe.CatalogManager")) : class$net$sourceforge$jsxe$CatalogManager, "Caching file " + path + " to " + localFile.getName());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(localFile));
        byte[] buf = new byte[4096];
        int count = 0;
        while ((count = in.read(buf)) != -1) {
            out.write(buf, 0, count);
        }
        out.close();
        return localFile;
    }

    private static String resolvePublic(String systemId, String publicId) throws Exception {
        Entry e = new Entry(1, publicId, null);
        String uri = (String)resourceCache.get(e);
        if (uri == null) {
            return catalog.resolvePublic(publicId, null);
        }
        if (uri == IGNORE) {
            return null;
        }
        return uri;
    }

    private static String resolveSystem(String id) throws Exception {
        Entry e = new Entry(0, id, null);
        String uri = (String)resourceCache.get(e);
        if (uri == null) {
            return catalog.resolveSystem(id);
        }
        if (uri == IGNORE) {
            return null;
        }
        return uri;
    }

    private static boolean showDownloadResourceDialog(Component comp, String systemId) {
        Entry e = new Entry(0, systemId, null);
        if (resourceCache.get(e) == IGNORE) {
            return false;
        }
        int result = JOptionPane.showConfirmDialog(comp, Messages.getMessage("xml.download-resource.message", new String[]{systemId}), Messages.getMessage("xml.download-resource.title"), 0, 3);
        if (result == 0) {
            return true;
        }
        resourceCache.put(e, IGNORE);
        return false;
    }

    private static synchronized void load() {
        int i;
        if (!loadedCache) {
            String uri;
            String prop;
            String id;
            Log.log(3, class$net$sourceforge$jsxe$CatalogManager == null ? (class$net$sourceforge$jsxe$CatalogManager = CatalogManager.class$("net.sourceforge.jsxe.CatalogManager")) : class$net$sourceforge$jsxe$CatalogManager, "Loading cached files");
            loadedCache = true;
            resourceCache = new HashMap();
            reverseResourceCache = new HashMap();
            i = 0;
            while ((id = jsXe.getProperty(prop = "xml.cache.public-id." + i++, null)) != null) {
                try {
                    uri = jsXe.getProperty(prop + ".uri", null);
                    Log.log(3, class$net$sourceforge$jsxe$CatalogManager == null ? CatalogManager.class$("net.sourceforge.jsxe.CatalogManager") : class$net$sourceforge$jsxe$CatalogManager, "Loading cached file: " + uri);
                    resourceCache.put(new Entry(1, id, uri), uri);
                }
                catch (Exception ex2) {
                    Log.log(9, class$net$sourceforge$jsxe$CatalogManager == null ? CatalogManager.class$("net.sourceforge.jsxe.CatalogManager") : class$net$sourceforge$jsxe$CatalogManager, ex2);
                }
            }
            i = 0;
            while ((id = jsXe.getProperty(prop = "xml.cache.system-id." + i++, null)) != null) {
                try {
                    uri = jsXe.getProperty(prop + ".uri", null);
                    Log.log(3, class$net$sourceforge$jsxe$CatalogManager == null ? CatalogManager.class$("net.sourceforge.jsxe.CatalogManager") : class$net$sourceforge$jsxe$CatalogManager, "Loading cached file: " + uri);
                    Entry se = new Entry(0, id, uri);
                    resourceCache.put(se, uri);
                    reverseResourceCache.put(uri, se);
                }
                catch (Exception ex2) {
                    Log.log(9, class$net$sourceforge$jsxe$CatalogManager == null ? CatalogManager.class$("net.sourceforge.jsxe.CatalogManager") : class$net$sourceforge$jsxe$CatalogManager, ex2);
                }
            }
        }
        if (!loadedCatalogs) {
            Log.log(3, class$net$sourceforge$jsxe$CatalogManager == null ? (class$net$sourceforge$jsxe$CatalogManager = CatalogManager.class$("net.sourceforge.jsxe.CatalogManager")) : class$net$sourceforge$jsxe$CatalogManager, "Loading catalogs");
            loadedCatalogs = true;
            catalog = new Catalog();
            catalogFiles = new HashSet();
            catalog.setupReaders();
            try {
                String prop;
                String uri;
                catalog.loadSystemCatalogs();
                i = 0;
                while ((uri = jsXe.getProperty(prop = "xml.catalog." + i++, null)) != null) {
                    Log.log(3, class$net$sourceforge$jsxe$CatalogManager == null ? CatalogManager.class$("net.sourceforge.jsxe.CatalogManager") : class$net$sourceforge$jsxe$CatalogManager, "Loading catalog: " + uri);
                    try {
                        if (MiscUtilities.isURL(uri)) {
                            catalogFiles.add(uri);
                        } else {
                            catalogFiles.add(MiscUtilities.resolveSymlinks(uri));
                        }
                        catalog.parseCatalog(uri);
                    }
                    catch (Exception ex2) {
                        Log.log(9, class$net$sourceforge$jsxe$CatalogManager == null ? CatalogManager.class$("net.sourceforge.jsxe.CatalogManager") : class$net$sourceforge$jsxe$CatalogManager, ex2);
                    }
                }
            }
            catch (Exception ex1) {
                Log.log(9, class$net$sourceforge$jsxe$CatalogManager == null ? (class$net$sourceforge$jsxe$CatalogManager = CatalogManager.class$("net.sourceforge.jsxe.CatalogManager")) : class$net$sourceforge$jsxe$CatalogManager, ex1);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        IGNORE = new Object();
    }

    private static class Entry {
        public static final int SYSTEM = 0;
        public static final int PUBLIC = 1;
        public int type;
        public String id;
        public String uri;

        public Entry(int type, String id, String uri) {
            this.type = type;
            this.id = id;
            this.uri = uri;
        }

        public boolean equals(Object o) {
            if (o instanceof Entry) {
                Entry e = (Entry)o;
                return e.type == this.type && e.id.equals(this.id);
            }
            return false;
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

