/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.filechooser.FileFilter;

public class CustomFileFilter
extends FileFilter {
    private Collection extensions;
    private String description;

    public CustomFileFilter(Collection exts, String desc) {
        this.extensions = exts;
        this.description = desc;
    }

    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String ext = this.getExtension(f);
            Iterator iterator = this.extensions.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().toString().equals(ext)) continue;
                return true;
            }
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    private String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }
}

