/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import net.sourceforge.jsxe.ActionPlugin;
import net.sourceforge.jsxe.PluginDependencyException;
import net.sourceforge.jsxe.PluginLoadException;
import net.sourceforge.jsxe.ViewPlugin;
import net.sourceforge.jsxe.gui.Messages;
import net.sourceforge.jsxe.jsXe;
import net.sourceforge.jsxe.util.ArrayListEnumeration;
import net.sourceforge.jsxe.util.Log;
import net.sourceforge.jsxe.util.MiscUtilities;

public class JARClassLoader
extends ClassLoader {
    public static final String PLUGIN_NAME = "jsxe-plugin-name";
    public static final String PLUGIN_CLASS = "jsxe-plugin-class";
    public static final String PLUGIN_VERSION = "jsxe-plugin-version";
    public static final String PLUGIN_HUMAN_READABLE_NAME = "jsxe-plugin-human-readable-name";
    public static final String PLUGIN_AUTHOR = "jsxe-plugin-author";
    public static final String PLUGIN_RELEASE_DATE = "jsxe-plugin-release-date";
    public static final String PLUGIN_URL = "jsxe-plugin-url";
    public static final String PLUGIN_DESCRIPTION = "jsxe-plugin-description";
    private static HashMap m_files = new HashMap();
    private static HashMap m_jarFiles = new HashMap();
    private static HashMap m_viewPlugins = new HashMap();
    private static HashMap m_actionPlugins = new HashMap();
    private Properties m_pluginProperties = new Properties();
    static /* synthetic */ Class class$net$sourceforge$jsxe$ActionPlugin;
    static /* synthetic */ Class class$net$sourceforge$jsxe$ViewPlugin;

    protected Class findClass(String name) throws ClassNotFoundException {
        String classFileName = name.replace('.', '/').concat(".class");
        Iterator jarItr = m_jarFiles.values().iterator();
        while (jarItr.hasNext()) {
            try {
                JarFile zipFile = (JarFile)jarItr.next();
                ZipEntry entry = zipFile.getEntry(classFileName);
                if (entry == null) continue;
                InputStream in = zipFile.getInputStream(entry);
                boolean fail = false;
                int len = (int)entry.getSize();
                byte[] data = new byte[len];
                int success = 0;
                int offset = 0;
                while (success < len && !fail) {
                    if ((success = in.read(data, offset += success, len -= success)) != -1) continue;
                    fail = true;
                }
                Class<?> c = this.defineClass(name, data, 0, data.length);
                return c;
            }
            catch (IOException io) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    protected Enumeration findResources(String name) throws IOException {
        Iterator fileItr = m_files.values().iterator();
        Iterator jarItr = m_jarFiles.values().iterator();
        ArrayList<URL> urls = new ArrayList<URL>();
        while (fileItr.hasNext()) {
            File file = (File)fileItr.next();
            JarFile jarfile = (JarFile)jarItr.next();
            JarEntry entry = jarfile.getJarEntry(name);
            if (entry == null) continue;
            urls.add(new URL("jar:" + file.toURL().toString() + "!/" + name));
        }
        return new ArrayListEnumeration(urls);
    }

    protected URL findResource(String name) {
        Iterator filesItr = m_files.values().iterator();
        Iterator jarItr = m_jarFiles.values().iterator();
        while (jarItr.hasNext()) {
            try {
                File file = (File)filesItr.next();
                JarFile jarfile = (JarFile)jarItr.next();
                JarEntry entry = jarfile.getJarEntry(name);
                if (entry == null) continue;
                return new URL("jar:" + file.toURL().toString() + "!/" + name);
            }
            catch (IOException ioe) {
                jsXe.exiterror(this, ioe, 1);
            }
        }
        return null;
    }

    public Enumeration getPluginResources(String name) throws IOException {
        return this.findResources(name);
    }

    public URL getPluginResource(String name) {
        return this.findResource(name);
    }

    public void addJarFile(String path) throws FileNotFoundException, IOException {
        this.addJarFile(new File(path));
    }

    public void addJarFile(File file) throws FileNotFoundException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("The jar file was not found");
        }
        JarFile jarFile = new JarFile(file);
        this.setProperties(jarFile);
        this.definePackages(jarFile);
        m_files.put(file.getName(), file);
        m_jarFiles.put(file.getName(), jarFile);
    }

    public ArrayList addDirectory(String path) {
        ArrayList<IOException> errors = new ArrayList<IOException>();
        File directory = new File(path);
        File[] files = directory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar");
            }
        });
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    this.addJarFile(files[i]);
                    continue;
                }
                catch (IOException e) {
                    errors.add(e);
                }
            }
        }
        return errors;
    }

    public ArrayList getAllPluginNames() {
        ArrayList names = new ArrayList();
        names.addAll(this.getViewPluginNames());
        names.addAll(this.getActionPluginNames());
        return names;
    }

    public ArrayList getAllPlugins() {
        ArrayList plugins = new ArrayList();
        plugins.addAll(this.getViewPlugins());
        plugins.addAll(this.getActionPlugins());
        return plugins;
    }

    public ArrayList getViewPluginNames() {
        return new ArrayList(m_viewPlugins.keySet());
    }

    public ArrayList getViewPlugins() {
        Iterator pluginItr = this.getViewPluginNames().iterator();
        ArrayList<ViewPlugin> plugins = new ArrayList<ViewPlugin>();
        while (pluginItr.hasNext()) {
            String pluginName = pluginItr.next().toString();
            ViewPlugin plugin = (ViewPlugin)m_viewPlugins.get(pluginName);
            plugins.add(plugin);
        }
        return plugins;
    }

    public ViewPlugin getViewPlugin(String name) {
        return (ViewPlugin)m_viewPlugins.get(name);
    }

    public ArrayList getActionPluginNames() {
        return new ArrayList(m_actionPlugins.keySet());
    }

    public ArrayList getActionPlugins() {
        Iterator pluginItr = this.getActionPluginNames().iterator();
        ArrayList<ActionPlugin> plugins = new ArrayList<ActionPlugin>();
        while (pluginItr.hasNext()) {
            String pluginName = pluginItr.next().toString();
            ActionPlugin plugin = (ActionPlugin)m_actionPlugins.get(pluginName);
            plugins.add(plugin);
        }
        return plugins;
    }

    public ActionPlugin getActionPlugin(String name) {
        return (ActionPlugin)m_actionPlugins.get(name);
    }

    public ActionPlugin getPlugin(String name) {
        ActionPlugin plugin = this.getViewPlugin(name);
        if (plugin == null) {
            plugin = this.getActionPlugin(name);
        }
        return plugin;
    }

    public ArrayList startPlugins() {
        Messages.initPluginMessages();
        Iterator jarItr = m_jarFiles.keySet().iterator();
        ArrayList<Exception> errors = new ArrayList<Exception>();
        while (jarItr.hasNext()) {
            JarFile jarFile = (JarFile)m_jarFiles.get(jarItr.next().toString());
            try {
                this.startPlugin(jarFile);
            }
            catch (IOException e) {
                errors.add(e);
            }
            catch (PluginDependencyException e2) {
                errors.add(e2);
            }
            catch (PluginLoadException e3) {
                errors.add(e3);
            }
        }
        return errors;
    }

    public String getPluginProperty(String name, String key) {
        return this.m_pluginProperties.getProperty(name + "." + key);
    }

    public String getPluginProperty(ActionPlugin plugin, String key) {
        return this.m_pluginProperties.getProperty(plugin.getClass().getName() + "." + key);
    }

    private void checkDependencies(JarFile file) throws IOException, PluginDependencyException {
        String dep;
        String name = this.getManifestAttribute(file, PLUGIN_NAME);
        int i = 0;
        while ((dep = this.m_pluginProperties.getProperty(name + ".dependency." + i++)) != null) {
            int index = dep.indexOf(32);
            if (index == -1) {
                throw new PluginDependencyException(name, Messages.getMessage("Plugin.Dependency.Invalid", new Object[]{name, dep}));
            }
            String what = dep.substring(0, index);
            String arg = dep.substring(index + 1);
            if (what.equals("jdk")) {
                if (MiscUtilities.compareStrings(System.getProperty("java.version"), arg, false) >= 0) continue;
                throw new PluginDependencyException(name, "Java", arg, System.getProperty("java.version"));
            }
            if (what.equals("jsxe") || what.equals("jsXe")) {
                if (arg.length() != 11) {
                    throw new PluginDependencyException(name, Messages.getMessage("Plugin.Dependency.Invalid.jsXe.Version", new Object[]{arg}));
                }
                if (MiscUtilities.compareStrings(jsXe.getBuild(), arg, false) >= 0) continue;
                String needs = MiscUtilities.buildToVersion(arg);
                throw new PluginDependencyException(name, "jsXe", needs, jsXe.getVersion());
            }
            if (what.equals("plugin")) {
                int index2 = arg.indexOf(32);
                if (index2 == -1) {
                    throw new PluginDependencyException(name, Messages.getMessage("Plugin.Dependency.Invalid", new Object[]{name, dep}));
                }
                String plugin = arg.substring(0, index2);
                String needVersion = arg.substring(index2 + 1);
                String currVersion = this.getPluginProperty(plugin, PLUGIN_VERSION);
                if (currVersion == null) {
                    throw new PluginDependencyException(name, Messages.getMessage("Plugin.Dependency.No.Version", new Object[]{name, plugin}));
                }
                if (MiscUtilities.compareStrings(currVersion, needVersion, false) < 0) {
                    throw new PluginDependencyException(name, plugin, needVersion, currVersion);
                }
                if (this.getPlugin(plugin) instanceof ActionPlugin.Broken) {
                    throw new PluginDependencyException(name, Messages.getMessage("Plugin.Dependency.Failed.Load", new Object[]{name, plugin}));
                }
                try {
                    this.checkDependencies((JarFile)m_jarFiles.get(plugin));
                    continue;
                }
                catch (PluginDependencyException e) {
                    throw new PluginDependencyException(name, Messages.getMessage("Plugin.Dependency.Failed.Load", new Object[]{name, plugin}));
                }
            }
            if (what.equals("class")) {
                try {
                    this.loadClass(arg, false);
                    continue;
                }
                catch (Exception e) {
                    throw new PluginDependencyException(name, arg, null);
                }
            }
            throw new PluginDependencyException(name, Messages.getMessage("Plugin.Dependency.Invalid", new Object[]{name, dep}));
        }
    }

    private void definePackages(JarFile zipFile) throws IOException {
        try {
            Manifest manifest = zipFile.getManifest();
            if (manifest != null) {
                Map<String, Attributes> entries = manifest.getEntries();
                Iterator<String> i = entries.keySet().iterator();
                while (i.hasNext()) {
                    String path = i.next();
                    if (path.endsWith(".class")) continue;
                    String name = path.replace('/', '.');
                    if (name.endsWith(".")) {
                        name = name.substring(0, name.length() - 1);
                    }
                    this.definePackage(path, name, manifest, null);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private Package definePackage(String path, String name, Manifest man, URL url) throws IllegalArgumentException {
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        URL sealBase = null;
        Attributes attr = man.getAttributes(path);
        if (attr != null) {
            specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        }
        if ((attr = man.getMainAttributes()) != null) {
            if (specTitle == null) {
                specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specVersion == null) {
                specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (specVendor == null) {
                specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (implTitle == null) {
                implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implVersion == null) {
                implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (implVendor == null) {
                implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
        }
        return super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    private void setProperties(JarFile jarFile) throws IOException {
        String mainClass = this.getManifestAttribute(jarFile, PLUGIN_CLASS);
        String pluginName = this.getManifestAttribute(jarFile, PLUGIN_NAME);
        if (pluginName != null && mainClass != null) {
            ZipEntry entry;
            String propPrefix1 = mainClass + ".";
            String propPrefix2 = pluginName + ".";
            String implVersion = this.getManifestAttribute(jarFile, PLUGIN_VERSION);
            String url = this.getManifestAttribute(jarFile, PLUGIN_URL);
            String humanReadableName = this.getManifestAttribute(jarFile, PLUGIN_HUMAN_READABLE_NAME);
            String description = this.getManifestAttribute(jarFile, PLUGIN_DESCRIPTION);
            String author = this.getManifestAttribute(jarFile, PLUGIN_AUTHOR);
            String releaseDate = this.getManifestAttribute(jarFile, PLUGIN_RELEASE_DATE);
            this.m_pluginProperties.setProperty(propPrefix1 + PLUGIN_NAME, pluginName);
            this.m_pluginProperties.setProperty(propPrefix2 + PLUGIN_NAME, pluginName);
            this.m_pluginProperties.setProperty(propPrefix1 + PLUGIN_CLASS, mainClass);
            this.m_pluginProperties.setProperty(propPrefix2 + PLUGIN_CLASS, mainClass);
            if (implVersion != null) {
                this.m_pluginProperties.setProperty(propPrefix1 + PLUGIN_VERSION, implVersion);
                this.m_pluginProperties.setProperty(propPrefix2 + PLUGIN_VERSION, implVersion);
            }
            if (url != null) {
                this.m_pluginProperties.setProperty(propPrefix1 + PLUGIN_URL, url);
                this.m_pluginProperties.setProperty(propPrefix2 + PLUGIN_URL, url);
            }
            if (author != null) {
                this.m_pluginProperties.setProperty(propPrefix1 + PLUGIN_AUTHOR, author);
                this.m_pluginProperties.setProperty(propPrefix2 + PLUGIN_AUTHOR, author);
            }
            if (releaseDate != null) {
                this.m_pluginProperties.setProperty(propPrefix1 + PLUGIN_RELEASE_DATE, releaseDate);
                this.m_pluginProperties.setProperty(propPrefix2 + PLUGIN_RELEASE_DATE, releaseDate);
            }
            if (humanReadableName != null) {
                this.m_pluginProperties.setProperty(propPrefix1 + PLUGIN_HUMAN_READABLE_NAME, humanReadableName);
                this.m_pluginProperties.setProperty(propPrefix2 + PLUGIN_HUMAN_READABLE_NAME, humanReadableName);
            }
            if (description != null) {
                this.m_pluginProperties.setProperty(propPrefix1 + PLUGIN_DESCRIPTION, description);
                this.m_pluginProperties.setProperty(propPrefix2 + PLUGIN_DESCRIPTION, description);
            }
            if ((entry = jarFile.getEntry("dependency.props")) != null) {
                String dep;
                InputStream stream = jarFile.getInputStream(entry);
                Properties dependencies = new Properties();
                dependencies.load(stream);
                int i = 0;
                while ((dep = dependencies.getProperty("dependency." + i)) != null) {
                    this.m_pluginProperties.setProperty(propPrefix1 + "dependency." + i, dep);
                    this.m_pluginProperties.setProperty(propPrefix2 + "dependency." + i++, dep);
                }
            }
        }
    }

    private void startPlugin(JarFile jarfile) throws IOException, PluginDependencyException, PluginLoadException {
        block14: {
            Log.log(5, this, "Attempting to start plugin from jar file " + jarfile.getName());
            String mainPluginClass = this.getManifestAttribute(jarfile, PLUGIN_CLASS);
            String pluginName = this.getManifestAttribute(jarfile, PLUGIN_NAME);
            String humanReadableName = this.getManifestAttribute(jarfile, PLUGIN_HUMAN_READABLE_NAME);
            String version = this.getManifestAttribute(jarfile, PLUGIN_VERSION);
            if (this.getPlugin(pluginName) != null) {
                throw new PluginLoadException(jarfile, Messages.getMessage("Plugin.Load.Already.Loaded", new Object[]{pluginName}));
            }
            if (mainPluginClass == null) {
                throw new PluginLoadException(jarfile, Messages.getMessage("Plugin.Load.No.Plugin.Class"));
            }
            if (pluginName == null) {
                throw new PluginLoadException(jarfile, Messages.getMessage("Plugin.Load.No.Plugin.Name"));
            }
            if (humanReadableName == null) {
                throw new PluginLoadException(jarfile, Messages.getMessage("Plugin.Load.No.Plugin.HR.Name"));
            }
            if (version == null) {
                throw new PluginLoadException(jarfile, Messages.getMessage("Plugin.Load.No.Plugin.Version"));
            }
            try {
                this.checkDependencies(jarfile);
                Class<?> pluginClass = this.loadClass(mainPluginClass);
                int modifiers = pluginClass.getModifiers();
                if (!Modifier.isInterface(modifiers) && !Modifier.isAbstract(modifiers) && (class$net$sourceforge$jsxe$ActionPlugin == null ? (class$net$sourceforge$jsxe$ActionPlugin = JARClassLoader.class$("net.sourceforge.jsxe.ActionPlugin")) : class$net$sourceforge$jsxe$ActionPlugin).isAssignableFrom(pluginClass)) {
                    Object plugin = pluginClass.newInstance();
                    if ((class$net$sourceforge$jsxe$ViewPlugin == null ? (class$net$sourceforge$jsxe$ViewPlugin = JARClassLoader.class$("net.sourceforge.jsxe.ViewPlugin")) : class$net$sourceforge$jsxe$ViewPlugin).isAssignableFrom(pluginClass)) {
                        Log.log(5, this, "Started View Plugin: " + pluginName);
                        ViewPlugin viewPlugin = (ViewPlugin)plugin;
                        m_viewPlugins.put(pluginName, viewPlugin);
                    } else {
                        Log.log(5, this, "Started Action Plugin: " + pluginName);
                        ActionPlugin actionPlugin = (ActionPlugin)plugin;
                        m_actionPlugins.put(pluginName, actionPlugin);
                    }
                    break block14;
                }
                throw new PluginLoadException(jarfile, Messages.getMessage("Plugin.Load.Wrong.Main.Class"));
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e.getMessage());
            }
            catch (InstantiationException e) {
                throw new IOException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IOException(e.getMessage());
            }
            catch (PluginDependencyException e) {
                m_actionPlugins.put(pluginName, new ActionPlugin.Broken());
                throw e;
            }
            catch (IOException e) {
                m_actionPlugins.put(pluginName, new ActionPlugin.Broken());
                throw e;
            }
        }
    }

    private String getManifestAttribute(JarFile file, String name) throws IOException {
        return this.getManifestAttribute(file, new Attributes.Name(name));
    }

    private String getManifestAttribute(JarFile file, Attributes.Name name) throws IOException {
        Manifest manifest;
        String value = null;
        if (file != null && name != null && (manifest = file.getManifest()) != null) {
            Attributes attr = manifest.getMainAttributes();
            if (attr != null) {
                value = attr.getValue(name);
            }
            if (value == null && (attr = manifest.getAttributes("common")) != null) {
                value = attr.getValue(name);
            }
        }
        return value;
    }

    private String getNameForPlugin(ActionPlugin plugin) {
        Iterator itr = this.getAllPluginNames().iterator();
        while (itr.hasNext()) {
            String name = itr.next().toString();
            if (this.getPlugin(name) != plugin) continue;
            return name;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

