/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.dom;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.text.Segment;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.jsxe.dom.AdapterNode;
import net.sourceforge.jsxe.dom.DOMOutput;
import net.sourceforge.jsxe.dom.DOMSerializer;
import net.sourceforge.jsxe.dom.DOMSerializerConfiguration;
import net.sourceforge.jsxe.dom.XMLDocumentListener;
import net.sourceforge.jsxe.dom.completion.CompletionInfo;
import net.sourceforge.jsxe.dom.completion.ElementDecl;
import net.sourceforge.jsxe.dom.completion.EntityDecl;
import net.sourceforge.jsxe.jsXe;
import net.sourceforge.jsxe.util.Log;
import net.sourceforge.jsxe.util.MiscUtilities;
import org.apache.xerces.impl.xs.XSDDescription;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.grammars.XSGrammar;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDocument {
    public static final String ENCODING = "encoding";
    public static final String WS_IN_ELEMENT_CONTENT = "element-content-whitespace";
    public static final String FORMAT_XML = "format-pretty-print";
    public static final String INDENT = "indent";
    public static final String IS_USING_SOFT_TABS = "soft-tabs";
    public static final String IS_VALIDATING = "validating";
    public static final String LINE_SEPARATOR = "line-separator";
    private static final int GZIP_MAGIC_1 = 31;
    private static final int GZIP_MAGIC_2 = 139;
    private static final int UNICODE_MAGIC_1 = 254;
    private static final int UNICODE_MAGIC_2 = 255;
    private static final int UTF8_MAGIC_1 = 239;
    private static final int UTF8_MAGIC_2 = 187;
    private static final int UTF8_MAGIC_3 = 191;
    private static final int READ_SIZE = 5120;
    private static final int WRITE_SIZE = 5120;
    private static final int IO_BUFFER_SIZE = 32768;
    private Document m_document;
    private AdapterNode m_adapterNode;
    private ContentManager m_content;
    private boolean m_parsedMode = false;
    private boolean m_syncedWithContent = false;
    private ArrayList m_parseErrors = new ArrayList();
    private ArrayList m_parseFatalErrors = new ArrayList();
    private EntityResolver m_entityResolver;
    private ArrayList listeners = new ArrayList();
    private Properties props = new Properties();
    private URI m_uri = null;
    private boolean m_formattedLastTime = false;
    private HashMap m_mappings;

    public XMLDocument(URI uri, InputStream reader) throws IOException {
        this(uri, reader, null);
    }

    public XMLDocument(URI uri, InputStream reader, EntityResolver resolver) throws IOException {
        this.m_entityResolver = resolver;
        this.setDefaultProperties();
        this.setURI(uri);
        this.setModel(reader);
        reader.close();
    }

    public XMLDocument(URI uri, InputStream reader, EntityResolver resolver, Properties properties) throws IOException {
        this.m_entityResolver = resolver;
        this.setDefaultProperties();
        this.setURI(uri);
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = propertyNames.nextElement().toString();
            this.setProperty(key, properties.getProperty(key));
        }
        this.setModel(reader);
        reader.close();
    }

    public boolean checkWellFormedness() throws SAXParseException, SAXException, ParserConfigurationException, IOException {
        if (!this.m_parsedMode) {
            this.parseDocument();
            this.m_adapterNode = new AdapterNode(this, this.m_document);
            this.m_parsedMode = true;
        }
        return this.m_parsedMode;
    }

    public String setProperty(String key, String value) {
        String oldValue = this.getProperty(key);
        if (oldValue == null || !oldValue.equals(value)) {
            oldValue = (String)this.props.setProperty(key, value);
            if (key.equals(ENCODING)) {
                this.m_syncedWithContent = false;
            }
            if (key.equals(FORMAT_XML)) {
                this.m_syncedWithContent = false;
                if (Boolean.valueOf(value).booleanValue()) {
                    this.setProperty(WS_IN_ELEMENT_CONTENT, "false");
                }
            }
            if (key.equals(WS_IN_ELEMENT_CONTENT)) {
                this.m_syncedWithContent = false;
                if (Boolean.valueOf(value).booleanValue()) {
                    this.setProperty(FORMAT_XML, "false");
                }
            }
            if (key.equals(IS_USING_SOFT_TABS)) {
                this.m_syncedWithContent = false;
            }
            if (key.equals(IS_VALIDATING)) {
                if (Boolean.valueOf(value).booleanValue()) {
                    this.syncContentWithDOM();
                } else {
                    this.m_parseErrors = new ArrayList();
                    this.m_parseFatalErrors = new ArrayList();
                }
            }
            if (key.equals(INDENT) && MiscUtilities.isTrue(this.getProperty(FORMAT_XML)) && MiscUtilities.isTrue(this.getProperty(IS_USING_SOFT_TABS))) {
                this.m_syncedWithContent = false;
            }
            this.firePropertyChanged(key, oldValue);
        }
        return oldValue;
    }

    public Document getDocumentCopy() {
        try {
            this.checkWellFormedness();
        }
        catch (SAXParseException e) {
        }
        catch (SAXException e) {
        }
        catch (ParserConfigurationException e) {
        }
        catch (IOException e) {
            jsXe.exiterror(this, e, 1);
        }
        if (this.m_document != null) {
            return (Document)this.m_document.cloneNode(true);
        }
        return null;
    }

    public AdapterNode getDocType() {
        AdapterNode docType = null;
        this.getAdapterNode();
        if (this.m_adapterNode != null) {
            int childCount = this.m_adapterNode.childCount();
            for (int i = 0; i < childCount && docType == null; ++i) {
                if (this.m_adapterNode.child(i).getNodeType() != 10) continue;
                docType = this.m_adapterNode.child(i);
            }
        }
        return docType;
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.props.getProperty(key, defaultValue);
    }

    public AdapterNode getRootElementNode() {
        AdapterNode rootElement = null;
        this.getAdapterNode();
        if (this.m_adapterNode != null) {
            int childCount = this.m_adapterNode.childCount();
            rootElement = this.m_adapterNode.child(0);
            for (int i = 1; i < childCount && rootElement.getNodeType() != 1; ++i) {
                rootElement = this.m_adapterNode.child(i);
            }
        }
        return rootElement;
    }

    public AdapterNode getAdapterNode() {
        try {
            this.checkWellFormedness();
        }
        catch (SAXParseException e) {
        }
        catch (SAXException e) {
        }
        catch (ParserConfigurationException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.m_adapterNode;
    }

    public AdapterNode newAdapterNode(AdapterNode parent, Node node) {
        AdapterNode newNode = null;
        if (node != null) {
            newNode = parent != null ? new AdapterNode(parent, node) : new AdapterNode(node);
        }
        return newNode;
    }

    public AdapterNode newAdapterNode(AdapterNode parent, String name, String value, short type) {
        Node newNode = null;
        switch (type) {
            case 1: {
                newNode = this.m_document.createElementNS("", name);
                break;
            }
            case 3: {
                newNode = this.m_document.createTextNode(value);
                break;
            }
            case 4: {
                newNode = this.m_document.createCDATASection(value);
                break;
            }
            case 8: {
                newNode = this.m_document.createComment(value);
                break;
            }
            case 7: {
                newNode = this.m_document.createProcessingInstruction(name, value);
                break;
            }
            case 5: {
                if (this.entityDeclared(name)) {
                    newNode = this.m_document.createEntityReference(name);
                    break;
                }
                throw new DOMException(12, "Entity \"" + name + "\"" + " has not been declared.");
            }
            case 10: {
                throw new DOMException(7, "DOM level 2 does not allow modification of the document type node");
            }
            default: {
                throw new DOMException(9, "An attempt was made to add a node that was not supported.");
            }
        }
        return this.newAdapterNode(parent, newNode);
    }

    public String getText(int start, int length) throws IOException {
        if (start < 0 || length < 0 || start + length > this.m_content.getLength()) {
            throw new ArrayIndexOutOfBoundsException(start + ":" + length);
        }
        this.syncContentWithDOM();
        return this.m_content.getText(start, length);
    }

    public Segment getSegment(int start, int length) throws IOException {
        if (start < 0 || length < 0 || start + length > this.m_content.getLength()) {
            throw new ArrayIndexOutOfBoundsException(start + ":" + length);
        }
        if (this.m_parsedMode) {
            this.syncContentWithDOM();
        }
        Segment seg = new Segment();
        this.m_content.getText(start, length, seg);
        return seg;
    }

    public int getLength() {
        this.syncContentWithDOM();
        return this.m_content.getLength();
    }

    public List getErrors() {
        this.syncContentWithDOM();
        this.parseWithoutUpdate();
        return this.m_parseErrors;
    }

    public boolean isWellFormed() throws IOException {
        try {
            this.checkWellFormedness();
        }
        catch (SAXException saxe) {
        }
        catch (ParserConfigurationException pce) {
            throw new IOException(pce.getMessage());
        }
        return this.m_parsedMode;
    }

    public boolean isValid() throws IOException {
        if (Boolean.valueOf(this.getProperty(IS_VALIDATING)).booleanValue()) {
            this.syncContentWithDOM();
            this.parseWithoutUpdate();
            return this.m_parseErrors.size() == 0 && this.m_parseFatalErrors.size() == 0;
        }
        return false;
    }

    public boolean entityDeclared(String entityName) {
        return this.getEntityDecl(entityName) != null;
    }

    public ElementDecl getElementDecl(String name) {
        CompletionInfo info;
        String prefix = MiscUtilities.getNSPrefixFromQualifiedName(name);
        if (prefix == null) {
            prefix = "";
        }
        if ((info = (CompletionInfo)this.m_mappings.get(prefix)) == null) {
            return null;
        }
        String lName = MiscUtilities.getLocalNameFromQualifiedName(name);
        ElementDecl decl = info.getElement(lName);
        if (decl == null) {
            return null;
        }
        return decl.withPrefix(prefix);
    }

    public EntityDecl getEntityDecl(String name) {
        return this.getNoNamespaceCompletionInfo().getEntity(name);
    }

    public List getAllowedEntities() {
        return this.getNoNamespaceCompletionInfo().getEntities();
    }

    public void serialize(OutputStream out) throws IOException, UnsupportedEncodingException {
        int size;
        boolean parsedBeforeSerialization = this.m_parsedMode;
        String newLine = this.getProperty(LINE_SEPARATOR);
        this.syncContentWithDOM();
        String encoding = this.getProperty(ENCODING);
        if (encoding.equals("UTF-8Y")) {
            out.write(239);
            out.write(187);
            out.write(191);
            out.flush();
            encoding = "UTF-8";
        }
        int length = this.m_content.getLength();
        BufferedWriter outbuf = new BufferedWriter(new OutputStreamWriter(out, encoding), 32768);
        Segment seg = new Segment();
        for (int index = 0; index < length; index += size) {
            size = 5120;
            try {
                size = Math.min(length - index, 5120);
            }
            catch (NumberFormatException nf) {
                Log.log(9, this, nf);
            }
            this.m_content.getText(index, size, seg);
            int startOffset = seg.offset;
            int endOffset = size + seg.offset;
            for (int i = startOffset; i < endOffset; ++i) {
                if (seg.array[i] != '\n') continue;
                outbuf.write(seg.array, seg.offset, i - seg.offset);
                outbuf.write(newLine.toCharArray(), 0, newLine.length());
                seg.count -= i - seg.offset + 1;
                seg.offset += i - seg.offset + 1;
            }
            outbuf.write(seg.array, seg.offset, seg.count);
        }
        outbuf.close();
        if (!this.m_parsedMode && parsedBeforeSerialization) {
            try {
                this.checkWellFormedness();
            }
            catch (SAXException saxe) {
                throw new IOException(saxe.getMessage());
            }
            catch (ParserConfigurationException pce) {
                throw new IOException(pce.getMessage());
            }
            finally {
                this.m_parsedMode = true;
            }
        }
    }

    public String serializeNodeToString(AdapterNode node) {
        String value = null;
        try {
            LSSerializer serializer = this.getSerializer();
            value = serializer.writeToString(node.getNode());
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return value;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.m_entityResolver = resolver;
    }

    public void setURI(URI uri) {
        this.m_uri = uri;
    }

    public URI getURI() {
        return this.m_uri;
    }

    public void insertText(int offset, String text) throws IOException {
        if (text.length() > 0) {
            this.syncContentWithDOM();
            this.m_content.insert(offset, text);
            this.m_parsedMode = false;
            this.m_adapterNode = null;
            this.fireStructureChanged(null);
        }
    }

    public void removeText(int offset, int length) throws IOException {
        if (length > 0) {
            this.syncContentWithDOM();
            this.m_content.remove(offset, length);
            this.m_parsedMode = false;
            this.m_adapterNode = null;
            this.fireStructureChanged(null);
        }
    }

    protected void setModel(InputStream stream) throws IOException {
        int bytesRead;
        Reader reader = this.autodetect(stream);
        char[] buf = new char[5120];
        ContentManager content = new ContentManager();
        boolean CRLF = false;
        boolean CROnly = false;
        boolean lastWasCR = false;
        do {
            if ((bytesRead = reader.read(buf, 0, 5120)) == -1) continue;
            int lastLine = 0;
            block5: for (int i = 0; i < bytesRead; ++i) {
                switch (buf[i]) {
                    case '\r': {
                        if (lastWasCR) {
                            CROnly = true;
                            CRLF = false;
                        } else {
                            lastWasCR = true;
                        }
                        content.insert(content.getLength(), new String(buf, lastLine, i - lastLine));
                        content.insert(content.getLength(), "\n");
                        lastLine = i + 1;
                        continue block5;
                    }
                    case '\n': {
                        if (lastWasCR) {
                            CROnly = false;
                            CRLF = true;
                            lastWasCR = false;
                            lastLine = i + 1;
                            continue block5;
                        }
                        CROnly = false;
                        CRLF = false;
                        content.insert(content.getLength(), new String(buf, lastLine, i - lastLine));
                        content.insert(content.getLength(), "\n");
                        lastLine = i + 1;
                        continue block5;
                    }
                    default: {
                        if (!lastWasCR) continue block5;
                        CROnly = true;
                        CRLF = false;
                        lastWasCR = false;
                    }
                }
            }
            content.insert(content.getLength(), new String(buf, lastLine, bytesRead - lastLine));
        } while (bytesRead != -1);
        String lineSeparator = CRLF ? "\r\n" : (CROnly ? "\r" : "\n");
        this.setProperty(LINE_SEPARATOR, lineSeparator);
        this.m_content = content;
        this.m_parsedMode = false;
        this.m_adapterNode = null;
    }

    public void addXMLDocumentListener(XMLDocumentListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeXMLDocumentListener(XMLDocumentListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    protected void fireStructureChanged(AdapterNode location) {
        ListIterator iterator = this.listeners.listIterator();
        while (iterator.hasNext()) {
            XMLDocumentListener listener = (XMLDocumentListener)iterator.next();
            listener.structureChanged(this, location);
        }
        this.m_syncedWithContent = false;
    }

    protected HashMap getCompletionInfoMappings() {
        return this.m_mappings;
    }

    private void setDefaultProperties() {
        this.setProperty(FORMAT_XML, "false");
        this.setProperty(IS_USING_SOFT_TABS, "false");
        this.setProperty(WS_IN_ELEMENT_CONTENT, "true");
        this.setProperty(ENCODING, "UTF-8");
        this.setProperty(INDENT, "4");
        this.setProperty(IS_VALIDATING, "false");
    }

    private void firePropertyChanged(String key, String oldValue) {
        ListIterator iterator = this.listeners.listIterator();
        while (iterator.hasNext()) {
            XMLDocumentListener listener = (XMLDocumentListener)iterator.next();
            listener.propertyChanged(this, key, oldValue);
        }
    }

    private void syncContentWithDOM() {
        if (this.m_parsedMode && !this.m_syncedWithContent) {
            try {
                Log.log(3, this, "Serializing document");
                LSSerializer serializer = this.getSerializer();
                ContentManager content = new ContentManager();
                ContentManagerWriter writer = new ContentManagerWriter(content);
                DOMOutput out = new DOMOutput(writer);
                if (!serializer.write(this.m_document, out)) {
                    throw new IOException("Could not serialize XML document.");
                }
                writer.close();
                this.m_content = content;
                boolean formatting = Boolean.valueOf(this.getProperty(FORMAT_XML));
                if (formatting && !this.m_formattedLastTime || !this.m_parsedMode) {
                    this.m_parsedMode = false;
                    try {
                        this.parseDocument();
                        this.m_adapterNode = new AdapterNode(this, this.m_document);
                        this.m_parsedMode = true;
                    }
                    catch (Exception e) {
                        jsXe.exiterror(this, e, 1);
                    }
                    this.fireStructureChanged(null);
                }
                this.m_formattedLastTime = formatting;
            }
            catch (IOException ioe) {
                jsXe.exiterror(this, ioe, 1);
            }
        }
        this.m_syncedWithContent = true;
    }

    private LSSerializer getSerializer() {
        DOMSerializerConfiguration config = new DOMSerializerConfiguration();
        config.setFeature(FORMAT_XML, Boolean.valueOf(this.getProperty(FORMAT_XML)));
        config.setFeature(WS_IN_ELEMENT_CONTENT, Boolean.valueOf(this.getProperty(WS_IN_ELEMENT_CONTENT)));
        config.setParameter(INDENT, new Integer(this.getProperty(INDENT)));
        config.setParameter("error-handler", new SerializeErrorHandler());
        config.setFeature(IS_USING_SOFT_TABS, Boolean.valueOf(this.getProperty(IS_USING_SOFT_TABS)));
        config.setParameter(ENCODING, this.getProperty(ENCODING));
        DOMSerializer serializer = new DOMSerializer(config);
        serializer.setNewLine("\n");
        return serializer;
    }

    public void parseDocument() throws SAXParseException, SAXException, ParserConfigurationException, IOException {
        Log.log(3, this, this.m_uri != null ? "Parsing Document: " + this.m_uri.toString() : "Parsing Document");
        Boolean validating = Boolean.valueOf(this.getProperty(IS_VALIDATING));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setExpandEntityReferences(false);
        factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setAttribute("http://xml.org/sax/features/external-general-entities", false);
        factory.setAttribute("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setAttribute("http://xml.org/sax/features/namespaces", true);
        factory.setAttribute("http://xml.org/sax/features/validation", false);
        factory.setAttribute("http://apache.org/xml/features/validation/schema", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(null);
        if (this.m_entityResolver != null) {
            builder.setEntityResolver(this.m_entityResolver);
        }
        String text = this.getText(0, this.getLength());
        Document doc = builder.parse(new InputSource(new StringReader(text)));
        doc.getDocumentElement().normalize();
        this.parseWithoutUpdate();
        this.m_document = doc;
        this.m_syncedWithContent = true;
    }

    public void parseWithoutUpdate() {
        Log.log(3, this, this.m_uri != null ? "Validating Document: " + this.m_uri.toString() : "Validating Document");
        this.m_parseErrors = new ArrayList();
        this.m_parseFatalErrors = new ArrayList();
        Boolean validating = Boolean.valueOf(this.getProperty(IS_VALIDATING));
        SymbolTable symbolTable = new SymbolTable();
        XMLGrammarPoolImpl grammarPool = new XMLGrammarPoolImpl();
        SchemaHandler handler = new SchemaHandler(grammarPool);
        SAXParser reader = new SAXParser(symbolTable, (XMLGrammarPool)grammarPool);
        try {
            reader.setFeature("http://xml.org/sax/features/validation", validating.booleanValue());
            reader.setFeature("http://apache.org/xml/features/validation/schema", validating.booleanValue());
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            reader.setErrorHandler((ErrorHandler)new ParseErrorHandler());
            if (this.m_entityResolver != null) {
                reader.setEntityResolver(this.m_entityResolver);
            }
            reader.setContentHandler((ContentHandler)handler);
            reader.setProperty("http://xml.org/sax/properties/declaration-handler", (Object)handler);
        }
        catch (SAXException se) {
            Log.log(9, this, se);
        }
        this.m_mappings = new HashMap();
        try {
            String text = this.getText(0, this.getLength());
            reader.parse(new InputSource(new StringReader(text)));
        }
        catch (SAXException se) {
            Log.log(7, this, se.getMessage());
            this.m_parseErrors.add(se);
        }
        catch (IOException ie) {
            Log.log(7, this, ie.getMessage());
            this.m_parseErrors.add(ie);
        }
    }

    private CompletionInfo getNoNamespaceCompletionInfo() {
        CompletionInfo info = (CompletionInfo)this.m_mappings.get("");
        if (info == null) {
            info = new CompletionInfo();
            this.m_mappings.put("", info);
        }
        return info;
    }

    private void xsElementToElementDecl(CompletionInfo info, XSElementDeclaration element, ElementDecl parent) {
        String name = element.getName();
        if (parent != null) {
            if (parent.content == null) {
                parent.content = new HashSet();
            }
            parent.content.add(name);
        }
        if (info.getElement(name) != null) {
            return;
        }
        ElementDecl elementDecl = new ElementDecl(info, name, null);
        info.addElement(elementDecl);
        XSTypeDefinition typedef = element.getTypeDefinition();
        if (typedef.getTypeCategory() == 15) {
            XSComplexTypeDefinition complex = (XSComplexTypeDefinition)typedef;
            XSParticle particle = complex.getParticle();
            if (particle != null) {
                XSTerm particleTerm = particle.getTerm();
                if (particleTerm instanceof XSWildcard) {
                    elementDecl.any = true;
                } else {
                    this.xsTermToElementDecl(info, particleTerm, elementDecl);
                }
            }
            XSObjectList attributes = complex.getAttributeUses();
            for (int i = 0; i < attributes.getLength(); ++i) {
                XSAttributeUse attr = (XSAttributeUse)attributes.item(i);
                boolean required = attr.getRequired();
                XSAttributeDeclaration decl = attr.getAttrDeclaration();
                String attrName = decl.getName();
                String value = decl.getConstraintValue();
                String type = decl.getTypeDefinition().getName();
                if (type == null) {
                    type = "CDATA";
                }
                StringList enumList = decl.getTypeDefinition().getLexicalEnumeration();
                ArrayList<String> values = null;
                if (enumList.getLength() > 0) {
                    values = new ArrayList<String>();
                    for (int j = 0; j < enumList.getLength(); ++j) {
                        values.add(enumList.item(j));
                    }
                }
                elementDecl.addAttribute(new ElementDecl.AttributeDecl(attrName, value, values, type, required));
            }
        }
    }

    private void xsTermToElementDecl(CompletionInfo info, XSTerm term, ElementDecl parent) {
        if (term instanceof XSElementDeclaration) {
            this.xsElementToElementDecl(info, (XSElementDeclaration)term, parent);
        } else if (term instanceof XSModelGroup) {
            XSObjectList content = ((XSModelGroup)term).getParticles();
            for (int i = 0; i < content.getLength(); ++i) {
                XSTerm childTerm = ((XSParticleDecl)content.item(i)).getTerm();
                this.xsTermToElementDecl(info, childTerm, parent);
            }
        }
    }

    private Reader autodetect(InputStream in) throws IOException {
        in = new BufferedInputStream(in);
        int XML_PI_LENGTH = 50;
        String encoding = this.getProperty(ENCODING);
        if (!in.markSupported()) {
            Log.log(7, this, "Mark not supported: " + in);
        } else {
            in.mark(XML_PI_LENGTH);
            int b1 = in.read();
            int b2 = in.read();
            int b3 = in.read();
            if (encoding.equals("UTF-8Y")) {
                if (b1 != 239 || b2 != 187 || b3 != 191) {
                    in.reset();
                }
                encoding = "UTF-8";
            } else if (b1 == 254 && b2 == 255 || b1 == 255 && b2 == 254) {
                in.reset();
                encoding = "UTF-16";
                this.setProperty(ENCODING, encoding);
            } else if (b1 == 239 && b2 == 187 && b3 == 191) {
                this.setProperty(ENCODING, "UTF-8Y");
                encoding = "UTF-8";
            } else {
                int index;
                int count;
                in.reset();
                byte[] _xmlPI = new byte[XML_PI_LENGTH];
                int offset = 0;
                while ((count = in.read(_xmlPI, offset, XML_PI_LENGTH - offset)) != -1 && (offset += count) != XML_PI_LENGTH) {
                }
                String xmlPI = new String(_xmlPI, 0, offset, "ASCII");
                if (xmlPI.startsWith("<?xml") && (index = xmlPI.indexOf("encoding=")) != -1 && index + 9 != xmlPI.length()) {
                    char ch = xmlPI.charAt(index + 9);
                    int endIndex = xmlPI.indexOf(ch, index + 10);
                    encoding = xmlPI.substring(index + 10, endIndex);
                    if (MiscUtilities.isSupportedEncoding(encoding)) {
                        this.setProperty(ENCODING, encoding);
                    } else {
                        Log.log(7, this, "XML PI specifies unsupported encoding: " + encoding);
                    }
                }
                in.reset();
            }
        }
        return new InputStreamReader(in, encoding);
    }

    private class SchemaHandler
    extends DefaultHandler
    implements DeclHandler {
        private XMLGrammarPoolImpl m_m_grammarPool;
        private HashMap m_m_activePrefixes = new HashMap();

        public SchemaHandler(XMLGrammarPoolImpl grammarPool) {
            this.m_m_grammarPool = grammarPool;
        }

        public void endDocument() throws SAXException {
            CompletionInfo info;
            Grammar grammar = this.getGrammarForNamespace(null);
            if (grammar != null && (info = this.grammarToCompletionInfo(grammar)) != null) {
                XMLDocument.this.m_mappings.put("", info);
            }
        }

        public void startPrefixMapping(String prefix, String uri) {
            this.m_m_activePrefixes.put(prefix, uri);
        }

        public void endPrefixMapping(String prefix) {
            CompletionInfo info;
            CompletionInfo info2;
            String uri = (String)this.m_m_activePrefixes.get(prefix);
            if (uri != null && (info2 = CompletionInfo.getCompletionInfoForNamespace(uri)) != null) {
                XMLDocument.this.m_mappings.put(prefix, info2);
                return;
            }
            Grammar grammar = this.getGrammarForNamespace(uri);
            if (grammar != null && (info = this.grammarToCompletionInfo(grammar)) != null) {
                XMLDocument.this.m_mappings.put(prefix, info);
            }
        }

        public void elementDecl(String name, String model) {
            ElementDecl element = XMLDocument.this.getElementDecl(name);
            if (element == null) {
                CompletionInfo info = XMLDocument.this.getNoNamespaceCompletionInfo();
                element = new ElementDecl(info, name, model);
                info.addElement(element);
            } else {
                element.setContent(model);
            }
        }

        public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) {
            ArrayList<String> values;
            ElementDecl element = XMLDocument.this.getElementDecl(eName);
            if (element == null) {
                CompletionInfo info = XMLDocument.this.getNoNamespaceCompletionInfo();
                element = new ElementDecl(info, eName, null);
                info.addElement(element);
            }
            if (element.getAttribute(aName) != null) {
                return;
            }
            if (type.startsWith("(")) {
                values = new ArrayList<String>();
                StringTokenizer st = new StringTokenizer(type.substring(1, type.length() - 1), "|");
                while (st.hasMoreTokens()) {
                    values.add(st.nextToken());
                }
            } else {
                values = null;
            }
            boolean required = "#REQUIRED".equals(valueDefault);
            element.addAttribute(new ElementDecl.AttributeDecl(aName, value, values, type, required));
        }

        public void internalEntityDecl(String name, String value) {
            if (name.startsWith("%")) {
                return;
            }
            XMLDocument.this.getNoNamespaceCompletionInfo().addEntity(0, name, value);
        }

        public void externalEntityDecl(String name, String publicId, String systemId) {
            if (name.startsWith("%")) {
                return;
            }
            XMLDocument.this.getNoNamespaceCompletionInfo().addEntity(1, name, publicId, systemId);
        }

        private CompletionInfo grammarToCompletionInfo(Grammar grammar) {
            if (!(grammar instanceof XSGrammar)) {
                return null;
            }
            CompletionInfo info = new CompletionInfo();
            XSModel model = ((XSGrammar)grammar).toXSModel();
            XSNamedMap elements = model.getComponents((short)2);
            for (int i = 0; i < elements.getLength(); ++i) {
                XSElementDeclaration element = (XSElementDeclaration)elements.item(i);
                XMLDocument.this.xsElementToElementDecl(info, element, null);
            }
            XSNamedMap attributes = model.getComponents((short)1);
            for (int i = 0; i < attributes.getLength(); ++i) {
                XSObject attribute = attributes.item(i);
                Log.log(7, this, "look! " + attribute);
            }
            return info;
        }

        private Grammar getGrammarForNamespace(String uri) {
            XSDDescription schemaDesc = new XSDDescription();
            schemaDesc.setTargetNamespace(uri);
            Grammar grammar = this.m_m_grammarPool.getGrammar((XMLGrammarDescription)schemaDesc);
            return grammar;
        }
    }

    private class ParseErrorHandler
    implements ErrorHandler {
        private ParseErrorHandler() {
        }

        public void error(SAXParseException exception) {
            Log.log(7, this, "parse error: " + exception.getMessage());
            XMLDocument.this.m_parseErrors.add(exception);
        }

        public void fatalError(SAXParseException exception) {
            Log.log(7, this, "parse fatalError: " + exception.getMessage());
            XMLDocument.this.m_parseFatalErrors.add(exception);
        }

        public void warning(SAXParseException exception) {
            Log.log(3, this, "parse warning: " + exception.getMessage());
        }
    }

    private class SerializeErrorHandler
    implements DOMErrorHandler {
        private SerializeErrorHandler() {
        }

        public boolean handleError(DOMError error) {
            if (error.getType() == "cdata-sections-splitted") {
                XMLDocument.this.m_syncedWithContent = true;
                XMLDocument.this.m_parsedMode = false;
                XMLDocument.this.m_adapterNode = null;
                return true;
            }
            return false;
        }
    }

    private static class ContentManagerWriter
    extends Writer {
        private ContentManager m_m_content;
        private boolean m_m_closed = false;

        public ContentManagerWriter(ContentManager content) {
            this.m_m_content = content;
        }

        public void write(char[] cbuf) throws IOException {
            if (this.m_m_closed) {
                throw new IOException("ContentManagerWriter is closed");
            }
            this.m_m_content.insert(this.m_m_content.getLength(), new String(cbuf));
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            if (this.m_m_closed) {
                throw new IOException("ContentManagerWriter is closed");
            }
            this.m_m_content.insert(this.m_m_content.getLength(), new String(cbuf, off, len));
        }

        public void write(int b) throws IOException {
            if (this.m_m_closed) {
                throw new IOException("ContentManagerWriter is closed");
            }
            char[] carray = new char[]{(char)b};
            this.m_m_content.insert(this.m_m_content.getLength(), new String(carray));
        }

        public void write(String str) throws IOException {
            if (this.m_m_closed) {
                throw new IOException("ContentManagerWriter is closed");
            }
            this.m_m_content.insert(this.m_m_content.getLength(), str);
        }

        public void flush() throws IOException {
            if (this.m_m_closed) {
                throw new IOException("ContentManagerWriter is closed");
            }
        }

        public void close() {
            this.m_m_closed = true;
        }
    }

    private static class ContentManager {
        private char[] text = new char[1024];
        private int gapStart = 0;
        private int gapEnd = 0;
        private int length = 0;

        public final int getLength() {
            return this.length;
        }

        public char getCharAt(int start) {
            if (start >= this.gapStart) {
                return this.text[start + this.gapEnd - this.gapStart];
            }
            if (start + 1 <= this.gapStart) {
                return this.text[start];
            }
            if (this.gapStart - start > 0) {
                return this.text[start];
            }
            return this.text[this.gapEnd + start - 1];
        }

        public String getText(int start, int len) {
            if (start >= this.gapStart) {
                return new String(this.text, start + this.gapEnd - this.gapStart, len);
            }
            if (start + len <= this.gapStart) {
                return new String(this.text, start, len);
            }
            return new String(this.text, start, this.gapStart - start).concat(new String(this.text, this.gapEnd, start + len - this.gapStart));
        }

        public void getText(int start, int len, Segment seg) {
            if (start >= this.gapStart) {
                seg.array = this.text;
                seg.offset = start + this.gapEnd - this.gapStart;
                seg.count = len;
            } else if (start + len <= this.gapStart) {
                seg.array = this.text;
                seg.offset = start;
                seg.count = len;
            } else {
                seg.array = new char[len];
                System.arraycopy(this.text, start, seg.array, 0, this.gapStart - start);
                System.arraycopy(this.text, this.gapEnd, seg.array, this.gapStart - start, len + start - this.gapStart);
                seg.offset = 0;
                seg.count = len;
            }
        }

        public void insert(int start, String str) {
            int len = str.length();
            this.moveGapStart(start);
            if (this.gapEnd - this.gapStart < len) {
                this.ensureCapacity(this.length + len + 1024);
                this.moveGapEnd(start + len + 1024);
            }
            str.getChars(0, len, this.text, start);
            this.gapStart += len;
            this.length += len;
        }

        public void insert(int start, Segment seg) {
            this.moveGapStart(start);
            if (this.gapEnd - this.gapStart < seg.count) {
                this.ensureCapacity(this.length + seg.count + 1024);
                this.moveGapEnd(start + seg.count + 1024);
            }
            System.arraycopy(seg.array, seg.offset, this.text, start, seg.count);
            this.gapStart += seg.count;
            this.length += seg.count;
        }

        public void _setContent(char[] text, int length) {
            this.text = text;
            this.gapEnd = 0;
            this.gapStart = 0;
            this.length = length;
        }

        public void remove(int start, int len) {
            this.moveGapStart(start);
            this.gapEnd += len;
            this.length -= len;
        }

        private void moveGapStart(int newStart) {
            int newEnd = this.gapEnd + (newStart - this.gapStart);
            if (newStart != this.gapStart) {
                if (newStart > this.gapStart) {
                    System.arraycopy(this.text, this.gapEnd, this.text, this.gapStart, newStart - this.gapStart);
                } else if (newStart < this.gapStart) {
                    System.arraycopy(this.text, newStart, this.text, newEnd, this.gapStart - newStart);
                }
            }
            this.gapStart = newStart;
            this.gapEnd = newEnd;
        }

        private void moveGapEnd(int newEnd) {
            System.arraycopy(this.text, this.gapEnd, this.text, newEnd, this.length - this.gapStart);
            this.gapEnd = newEnd;
        }

        private void ensureCapacity(int capacity) {
            if (capacity >= this.text.length) {
                char[] textN = new char[capacity * 2];
                System.arraycopy(this.text, 0, textN, 0, this.length + (this.gapEnd - this.gapStart));
                this.text = textN;
            }
        }
    }
}

